/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item;

import iskallia.vault.block.CoinPileDecorBlock;
import iskallia.vault.init.ModItems;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;

public class CoinBlockItem
extends BlockItem {
    private final List<Component> tooltip = new ArrayList<Component>();

    public CoinBlockItem(Block block) {
        this(block, new Item.Properties().m_41491_(ModItems.VAULT_MOD_GROUP));
    }

    public CoinBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public CoinBlockItem withTooltip(Component tooltip) {
        this.tooltip.add(tooltip);
        return this;
    }

    public CoinBlockItem withTooltip(Component ... tooltip) {
        this.tooltip.addAll(Arrays.asList(tooltip));
        return this;
    }

    public CoinBlockItem withTooltip(List<Component> tooltip) {
        this.tooltip.addAll(tooltip);
        return this;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        if (!this.tooltip.isEmpty()) {
            tooltip.add(TextComponent.f_131282_);
            tooltip.addAll(this.tooltip);
        }
    }

    public InteractionResult m_40576_(BlockPlaceContext context) {
        if (!context.m_7059_()) {
            return InteractionResult.FAIL;
        }
        BlockPlaceContext blockplacecontext = this.m_7732_(context);
        if (blockplacecontext == null) {
            return InteractionResult.FAIL;
        }
        BlockState blockState = context.m_43725_().m_8055_(context.m_8083_());
        int existingCoins = 0;
        if (blockState.m_60734_() instanceof CoinPileDecorBlock) {
            existingCoins = (Integer)blockState.m_61143_((Property)CoinPileDecorBlock.COINS);
        } else {
            blockState = this.m_5965_(blockplacecontext);
            if (blockState == null) {
                return InteractionResult.FAIL;
            }
        }
        ItemStack stack = context.m_43722_();
        Player player = context.m_43723_();
        boolean isShiftKeyDown = player != null && player.m_6144_();
        int coinsTillFull = 64 - existingCoins;
        int coinsToAdd = isShiftKeyDown ? Math.min(coinsTillFull, stack.m_41613_()) : 1;
        int newCoins = existingCoins + coinsToAdd;
        blockState = this.updateCoinsState(blockState, newCoins);
        if (!this.m_7429_(blockplacecontext, blockState)) {
            return InteractionResult.FAIL;
        }
        BlockPos blockpos = blockplacecontext.m_8083_();
        Level level = blockplacecontext.m_43725_();
        ItemStack itemstack = blockplacecontext.m_43722_();
        BlockState blockstate1 = level.m_8055_(blockpos);
        if (blockstate1.m_60713_(blockState.m_60734_()) && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            CriteriaTriggers.f_10591_.m_59469_(serverPlayer, blockpos, itemstack);
        }
        level.m_142346_((Entity)player, GameEvent.f_157797_, blockpos);
        SoundType soundtype = blockstate1.getSoundType((LevelReader)level, blockpos, (Entity)context.m_43723_());
        level.m_5594_(player, blockpos, this.getPlaceSound(blockstate1, level, blockpos, context.m_43723_()), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
        if (player == null || !player.m_150110_().f_35937_) {
            itemstack.m_41774_(coinsToAdd);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public BlockState updateCoinsState(BlockState blockState, int newCoins) {
        int size = switch (newCoins) {
            case 2 -> 2;
            case 3 -> 3;
            case 4 -> 4;
            case 5, 6, 7 -> 5;
            case 8, 9, 10, 11, 12, 13, 14, 15 -> 6;
            case 16, 17, 18, 19, 20, 21, 22, 23 -> 7;
            case 24, 25, 26, 27, 28, 29, 30, 31 -> 8;
            case 32, 33, 34, 35, 36, 37, 38, 39 -> 9;
            case 40, 41, 42, 43, 44, 45, 46, 47 -> 10;
            case 48, 49, 50, 51, 52, 53, 54, 55 -> 11;
            case 56, 57, 58, 59, 60, 61, 62, 63 -> 12;
            case 64 -> 13;
            default -> 1;
        };
        return (BlockState)((BlockState)blockState.m_61124_((Property)CoinPileDecorBlock.SIZE, (Comparable)Integer.valueOf(size))).m_61124_((Property)CoinPileDecorBlock.COINS, (Comparable)Integer.valueOf(Math.min(64, newCoins)));
    }
}

