/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.integration;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import iskallia.vault.integration.IntegrationSB;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.network.PacketDistributor;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotTypePreset;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;
import top.theillusivec4.curios.common.CuriosHelper;
import top.theillusivec4.curios.common.network.NetworkHandler;
import top.theillusivec4.curios.common.network.server.sync.SPacketSyncStack;

public class IntegrationCurios {
    public static Collection<CompoundTag> getSerializedCuriosItemStacks(Player player) {
        return player.getCapability(CuriosCapability.INVENTORY).map(inv -> {
            ArrayList<CompoundTag> stacks = new ArrayList<CompoundTag>();
            for (ICurioStacksHandler handle : inv.getCurios().values()) {
                IDynamicStackHandler stackHandler = handle.getStacks();
                for (int index = 0; index < stackHandler.getSlots(); ++index) {
                    ItemStack stack = stackHandler.getStackInSlot(index);
                    if (stack.m_41619_()) continue;
                    stacks.add(stack.serializeNBT());
                }
            }
            return stacks;
        }).orElse(Collections.emptyList());
    }

    public static Map<String, List<ItemStack>> getCuriosItemStacks(LivingEntity entity) {
        return entity.getCapability(CuriosCapability.INVENTORY).map(inv -> {
            HashMap contents = new HashMap();
            inv.getCurios().forEach((key, handle) -> {
                IDynamicStackHandler stackHandler = handle.getStacks();
                for (int index = 0; index < stackHandler.getSlots(); ++index) {
                    contents.computeIfAbsent(key, str -> new ArrayList()).add(stackHandler.getStackInSlot(index));
                }
            });
            return contents;
        }).orElse(Collections.emptyMap());
    }

    public static void clearCurios(LivingEntity entity) {
        CuriosApi.getCuriosHelper().getCuriosHandler(entity).ifPresent(handler -> handler.getCurios().values().forEach(stacksHandler -> {
            IDynamicStackHandler stackHandler = stacksHandler.getStacks();
            IDynamicStackHandler cosmeticStackHandler = stacksHandler.getCosmeticStacks();
            String id = stacksHandler.getIdentifier();
            for (int i = 0; i < stackHandler.getSlots(); ++i) {
                UUID uuid = UUID.nameUUIDFromBytes((id + i).getBytes());
                NonNullList renderStates = stacksHandler.getRenders();
                SlotContext slotContext = new SlotContext(id, entity, i, false, renderStates.size() > i && (Boolean)renderStates.get(i) != false);
                ItemStack stack = stackHandler.getStackInSlot(i);
                Multimap map = CuriosApi.getCuriosHelper().getAttributeModifiers(slotContext, uuid, stack);
                HashMultimap slots = HashMultimap.create();
                HashSet<CuriosHelper.SlotAttributeWrapper> toRemove = new HashSet<CuriosHelper.SlotAttributeWrapper>();
                for (Attribute attribute : map.keySet()) {
                    if (!(attribute instanceof CuriosHelper.SlotAttributeWrapper)) continue;
                    CuriosHelper.SlotAttributeWrapper wrapper = (CuriosHelper.SlotAttributeWrapper)attribute;
                    slots.putAll((Object)wrapper.identifier, (Iterable)map.get((Object)attribute));
                    toRemove.add(wrapper);
                }
                for (Attribute attribute : toRemove) {
                    map.removeAll((Object)attribute);
                }
                entity.m_21204_().m_22161_(map);
                handler.removeSlotModifiers((Multimap)slots);
                CuriosApi.getCuriosHelper().getCurio(stack).ifPresent(curio -> curio.onUnequip(slotContext, stack));
                stackHandler.setStackInSlot(i, ItemStack.f_41583_);
                NetworkHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)new SPacketSyncStack(entity.m_142049_(), id, i, ItemStack.f_41583_, SPacketSyncStack.HandlerType.EQUIPMENT, new CompoundTag()));
                cosmeticStackHandler.setStackInSlot(i, ItemStack.f_41583_);
                NetworkHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)new SPacketSyncStack(entity.m_142049_(), id, i, ItemStack.f_41583_, SPacketSyncStack.HandlerType.COSMETIC, new CompoundTag()));
            }
        }));
    }

    public static CompoundTag getMappedSerializedCuriosItemStacks(Player player, BiPredicate<Player, ItemStack> stackFilter, boolean removeSnapshotItems) {
        return player.getCapability(CuriosCapability.INVENTORY).map(inv -> {
            CompoundTag tag = new CompoundTag();
            inv.getCurios().forEach((key, handle) -> {
                CompoundTag keyMap = new CompoundTag();
                IDynamicStackHandler stackHandler = handle.getStacks();
                for (int slot = 0; slot < stackHandler.getSlots(); ++slot) {
                    ItemStack stack = stackHandler.getStackInSlot(slot);
                    if (!stackFilter.test(player, stack) || stack.m_41619_()) continue;
                    ItemStack stackCopy = stack.m_41777_();
                    if (ModList.get().isLoaded("sophisticatedbackpacksvh")) {
                        IntegrationSB.addSnapshotDataIfBackpack(stackCopy);
                    }
                    keyMap.m_128365_(String.valueOf(slot), (Tag)stackCopy.serializeNBT());
                    if (!removeSnapshotItems) continue;
                    stackHandler.setStackInSlot(slot, ItemStack.f_41583_);
                }
                tag.m_128365_(key, (Tag)keyMap);
            });
            return tag;
        }).orElse(new CompoundTag());
    }

    public static List<ItemStack> applyMappedSerializedCuriosItemStacks(Player player, CompoundTag tag, boolean replaceExisting) {
        return player.getCapability(CuriosCapability.INVENTORY).map(inv -> {
            ArrayList filledItems = new ArrayList();
            for (String handlerKey : tag.m_128431_()) {
                inv.getStacksHandler(handlerKey).ifPresent(handle -> {
                    IDynamicStackHandler stackHandler = handle.getStacks();
                    CompoundTag handlerKeyMap = tag.m_128469_(handlerKey);
                    for (String strSlot : handlerKeyMap.m_128431_()) {
                        int slot;
                        try {
                            slot = Integer.parseInt(strSlot);
                        }
                        catch (NumberFormatException exc) {
                            continue;
                        }
                        if (slot < 0 || slot >= stackHandler.getSlots()) continue;
                        ItemStack stack = ItemStack.m_41712_((CompoundTag)handlerKeyMap.m_128469_(strSlot));
                        if (ModList.get().isLoaded("sophisticatedbackpacksvh")) {
                            IntegrationSB.restoreSnapshotIfBackpack(stack);
                        }
                        if (replaceExisting || stackHandler.getStackInSlot(slot).m_41619_()) {
                            stackHandler.setStackInSlot(slot, stack);
                            continue;
                        }
                        filledItems.add(stack);
                    }
                });
            }
            return filledItems;
        }).orElse(Collections.emptyList());
    }

    public static ItemStack getItemFromCuriosHeadSlot(Player player, Predicate<ItemStack> stackMatcher) {
        return CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).map(h -> h.getStacksHandler(SlotTypePreset.HEAD.getIdentifier()).map(stackHandler -> {
            IDynamicStackHandler stacks = stackHandler.getStacks();
            for (int slot = 0; slot < stacks.getSlots(); ++slot) {
                ItemStack stackInSlot = stacks.getStackInSlot(slot);
                if (!stackMatcher.test(stackInSlot)) continue;
                return stackInSlot;
            }
            return ItemStack.f_41583_;
        }).orElse(ItemStack.f_41583_)).orElse(ItemStack.f_41583_);
    }

    public static void registerHeadSlot(InterModEnqueueEvent evt) {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.HEAD.getMessageBuilder().build());
    }
}

