/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.init;

import iskallia.vault.VaultMod;
import iskallia.vault.dynamodel.DynamicModelProperties;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModWeaponModels {
    private static final Map<ResourceLocation, ModelDefinition> SWORDS = new HashMap<ResourceLocation, ModelDefinition>();
    private static final Map<ResourceLocation, ModelDefinition> AXES = new HashMap<ResourceLocation, ModelDefinition>();
    public static final ModelDefinition RED_SWORD = ModWeaponModels.registerSword(new ModelDefinition(VaultMod.id("gear/sword/red_sword"), "Red Sword").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll()));
    public static final ModelDefinition RED_AXE = ModWeaponModels.registerAxe(new ModelDefinition(VaultMod.id("gear/axe/red_axe"), "Red Axe").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll()));

    public static Map<ResourceLocation, ModelDefinition> getSwords() {
        return Collections.unmodifiableMap(SWORDS);
    }

    public static Map<ResourceLocation, ModelDefinition> getAxes() {
        return Collections.unmodifiableMap(AXES);
    }

    @SubscribeEvent
    public static void stitchVaultArmorTextures(TextureStitchEvent.Pre event) {
    }

    @SubscribeEvent
    public static void bakeModels(ModelBakeEvent event) {
    }

    private static ModelDefinition registerSword(ModelDefinition definition) {
        SWORDS.put(definition.getId(), definition);
        return definition;
    }

    private static ModelDefinition registerAxe(ModelDefinition definition) {
        AXES.put(definition.getId(), definition);
        return definition;
    }

    public static class ModelDefinition {
        ResourceLocation id;
        String displayName;
        DynamicModelProperties modelProperties;

        public ModelDefinition(ResourceLocation id, String displayName) {
            this.id = id;
            this.displayName = displayName;
        }

        public ModelDefinition properties(DynamicModelProperties modelProperties) {
            this.modelProperties = modelProperties;
            return this;
        }

        public ResourceLocation getId() {
            return this.id;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public DynamicModelProperties getModelProperties() {
            return this.modelProperties;
        }
    }
}

