/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.init;

import com.google.common.base.Function;
import com.google.common.base.Predicates;
import iskallia.vault.VaultMod;
import iskallia.vault.block.CryoChamberBlock;
import iskallia.vault.block.PlaceholderBlock;
import iskallia.vault.block.TreasureDoorBlock;
import iskallia.vault.client.util.color.ColorUtil;
import iskallia.vault.config.gear.VaultGearTypeConfig;
import iskallia.vault.etching.EtchingRegistry;
import iskallia.vault.etching.EtchingSet;
import iskallia.vault.gear.VaultGearHelper;
import iskallia.vault.gear.VaultGearState;
import iskallia.vault.gear.data.AttributeGearData;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.trinket.TrinketEffect;
import iskallia.vault.gear.trinket.TrinketEffectRegistry;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.ItemDrillArrow;
import iskallia.vault.item.MagnetItem;
import iskallia.vault.item.crystal.VaultCrystalItem;
import iskallia.vault.util.calc.BlockChanceHelper;
import iskallia.vault.world.data.ServerVaults;
import java.util.Arrays;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;

public class ModModels {
    public static void setupRenderLayers() {
        ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.VAULT_PORTAL, (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.TREASURE_DOOR, (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.VAULT_ALTAR, (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.VAULT_ARTIFACT, (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.MVP_CROWN, (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.KEY_PRESS, (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.XP_ALTAR, (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.BLOOD_ALTAR, (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.TIME_ALTAR, (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.SOUL_ALTAR, (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.VAULT_GLASS, (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.FINAL_VAULT_FRAME, (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.ELITE_SPAWNER, (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.SUGAR_PLUM_FAIRY_FLOWER, (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.CRYSTAL_CLUSTER, (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.LARGE_CRYSTAL_BUD, (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.MEDIUM_CRYSTAL_BUD, (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.SMALL_CRYSTAL_BUD, (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.MONOLITH, (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.BLACK_MARKET, (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.ANIMAL_JAR, (RenderType)RenderType.m_110466_());
        ModModels.setRenderLayers(ModBlocks.CRYO_CHAMBER, RenderType.m_110451_(), RenderType.m_110466_());
        ModModels.setRenderLayers(ModBlocks.HOURGLASS, RenderType.m_110451_(), RenderType.m_110466_());
        ModModels.setRenderLayers(ModBlocks.STABILIZER, RenderType.m_110451_(), RenderType.m_110466_());
        ModModels.setRenderLayers(ModBlocks.RAID_CONTROLLER_BLOCK, RenderType.m_110451_(), RenderType.m_110466_());
        ModModels.setRenderLayers(ModBlocks.VAULT_CHARM_CONTROLLER_BLOCK, RenderType.m_110451_(), RenderType.m_110466_());
    }

    private static void setRenderLayers(Block block, RenderType ... renderTypes) {
        ItemBlockRenderTypes.setRenderLayer((Block)block, (Predicate)Predicates.in(Arrays.asList(renderTypes)));
    }

    public static void registerItemColors(ItemColors colors) {
        colors.m_92689_((stack, tintLayer) -> {
            if (tintLayer > 0) {
                VaultGearData data = VaultGearData.read(stack);
                if (data.getState() == VaultGearState.UNIDENTIFIED) {
                    VaultGearTypeConfig.RollType type = data.getFirstValue(ModGearAttributes.GEAR_ROLL_TYPE).flatMap(ModConfigs.VAULT_GEAR_TYPE_CONFIG::getRollPool).orElse(null);
                    if (type != null) {
                        return ColorUtil.blendColors(type.getColor(), -1, 0.8f);
                    }
                }
                return -1;
            }
            return VaultGearHelper.getGearColor(stack);
        }, new ItemLike[]{ModItems.HELMET, ModItems.CHESTPLATE, ModItems.LEGGINGS, ModItems.BOOTS, ModItems.AXE, ModItems.SWORD, ModItems.SHIELD, ModItems.IDOL_BENEVOLENT, ModItems.IDOL_OMNISCIENT, ModItems.IDOL_TIMEKEEPER, ModItems.IDOL_MALEVOLENCE});
        colors.m_92689_((stack, tintIndex) -> tintIndex == 1 ? MagnetItem.getTextureColor(stack) : -1, new ItemLike[]{ModItems.MAGNET_ITEM});
    }

    public static class ItemProperty {
        public static ItemPropertyFunction ETCHING = (stack, world, entity, seed) -> {
            EtchingSet<?> data = AttributeGearData.read(stack);
            EtchingSet etching = ((AttributeGearData)((Object)data)).getFirstValue(ModGearAttributes.ETCHING).orElse(null);
            if (etching == null) {
                return -1.0f;
            }
            return EtchingRegistry.getOrderedEntries().indexOf((Object)etching);
        };
        public static ItemPropertyFunction TRINKET = (stack, world, entity, seed) -> {
            TrinketEffect<?> data = AttributeGearData.read(stack);
            TrinketEffect trinket = ((AttributeGearData)((Object)data)).getFirstValue(ModGearAttributes.TRINKET_EFFECT).orElse(null);
            if (trinket == null) {
                return -1.0f;
            }
            return TrinketEffectRegistry.getOrderedEntries().indexOf((Object)trinket);
        };
        public static ItemPropertyFunction PLACEHOLDER_TYPE = (stack, world, entity, seed) -> {
            CompoundTag nbt = stack.m_41783_();
            if (nbt == null) {
                return -1.0f;
            }
            PlaceholderBlock.Type type = PlaceholderBlock.Type.fromString(nbt.m_128461_("type"));
            if (type == null) {
                return -1.0f;
            }
            return type.ordinal();
        };
        public static ItemPropertyFunction TREASURE_DOOR_TYPE = (stack, world, entity, seed) -> {
            CompoundTag nbt = stack.m_41783_();
            if (nbt == null) {
                return -1.0f;
            }
            TreasureDoorBlock.Type type = TreasureDoorBlock.Type.fromString(nbt.m_128461_("type"));
            if (type == null) {
                return -1.0f;
            }
            return type.ordinal();
        };

        public static void register() {
            ItemProperty.registerItemProperty(ModItems.ETCHING, "etching", ETCHING);
            ItemProperty.registerItemProperty(ModItems.TRINKET, "trinket", TRINKET);
            ItemProperty.registerItemProperty((Item)ModItems.SHIELD, "blocking", (stack, world, entity, seed) -> {
                Player player;
                if (entity instanceof Player && BlockChanceHelper.isPlayerBlocking(player = (Player)entity)) {
                    return 1.0f;
                }
                return entity != null && entity.m_6117_() && entity.m_21211_() == stack ? 1.0f : 0.0f;
            });
            ItemProperties.register((Item)ModItems.DRILL_ARROW, (ResourceLocation)new ResourceLocation("tier"), (stack, world, entity, seed) -> (float)ItemDrillArrow.getArrowTier(stack).ordinal() / (float)ItemDrillArrow.ArrowTier.values().length);
            ItemProperties.register((Item)Item.m_41439_((Block)ModBlocks.CRYO_CHAMBER), (ResourceLocation)new ResourceLocation("type"), (stack, world, entity, seed) -> (float)stack.m_41773_() / (float)CryoChamberBlock.ChamberState.values().length);
            ItemProperties.register((Item)ModItems.VAULT_CRYSTAL, (ResourceLocation)new ResourceLocation("model"), (stack, world, entity, seed) -> VaultCrystalItem.getData(stack).getModel().getSerializedId());
            ItemProperties.register((Item)ModItems.VAULT_COMPASS, (ResourceLocation)new ResourceLocation("angle"), (ItemPropertyFunction)new CompassPropertyFunction());
            ItemProperty.registerItemProperty(ModBlocks.PLACEHOLDER.m_5456_(), "placeholder_type", PLACEHOLDER_TYPE);
            ItemProperty.registerItemProperty(ModBlocks.TREASURE_DOOR.m_5456_(), "treasure_door_type", TREASURE_DOOR_TYPE);
            ItemProperty.registerItemProperty(ModItems.MAGNET_ITEM, "magnet_perk", (stack, world, entity, seed) -> MagnetItem.getPerk(stack).ordinal());
            ItemProperties.registerGeneric((ResourceLocation)VaultMod.id("count"), (s, w, e, l) -> s.m_41613_());
        }

        public static void registerOverrides() {
            ItemProperty.override(Items.f_42740_, new ResourceLocation("blocking"), (Function<ItemPropertyFunction, ItemPropertyFunction>)((Function)existing -> (stack, world, entity, seed) -> {
                Player player;
                if (entity instanceof Player && BlockChanceHelper.isPlayerBlocking(player = (Player)entity)) {
                    return 1.0f;
                }
                return existing.m_141951_(stack, world, entity, seed);
            }));
        }

        public static void registerItemProperty(Item item, String name, ItemPropertyFunction property) {
            ItemProperties.register((Item)item, (ResourceLocation)VaultMod.id(name), (ItemPropertyFunction)property);
        }

        public static void override(Item item, ResourceLocation key, Function<ItemPropertyFunction, ItemPropertyFunction> decorateFn) {
            ItemPropertyFunction existing = ItemProperties.m_117829_((Item)item, (ResourceLocation)key);
            if (existing != null) {
                ItemProperties.register((Item)item, (ResourceLocation)key, (ItemPropertyFunction)((ItemPropertyFunction)decorateFn.apply((Object)existing)));
            }
        }

        private static class CompassPropertyFunction
        implements ClampedItemPropertyFunction {
            private final ItemProperties.CompassWobble wobble = new ItemProperties.CompassWobble();
            private final ItemProperties.CompassWobble wobbleRandom = new ItemProperties.CompassWobble();

            private CompassPropertyFunction() {
            }

            public float m_142187_(ItemStack compass, @Nullable ClientLevel level, @Nullable LivingEntity livingEntity, int seed) {
                Level level2;
                if (!(livingEntity instanceof Player)) {
                    return 0.0f;
                }
                Player player = (Player)livingEntity;
                if (level == null && (level2 = livingEntity.f_19853_) instanceof ClientLevel) {
                    ClientLevel clientLevel;
                    level = clientLevel = (ClientLevel)level2;
                }
                BlockPos portalPos = new BlockPos(24, 24, 24);
                long gameTime = level.m_46467_();
                if (ServerVaults.isInVault((Entity)player) && player.m_20182_().m_82531_((double)portalPos.m_123341_() + 0.5, player.m_20182_().m_7098_(), (double)portalPos.m_123343_() + 0.5) > 1.0E-5) {
                    double yRotation = player.m_146908_();
                    yRotation = Mth.m_14109_((double)(yRotation / 360.0), (double)1.0);
                    double index = this.getAngleTo(Vec3.m_82512_((Vec3i)portalPos), (Entity)player) / 6.2831854820251465;
                    if (this.wobble.m_117933_(gameTime)) {
                        this.wobble.m_117935_(gameTime, 0.5 - (yRotation - 0.25));
                    }
                    return Mth.m_14091_((float)((float)(index += this.wobble.f_117927_)), (float)1.0f);
                }
                if (this.wobbleRandom.m_117933_(gameTime)) {
                    this.wobbleRandom.m_117935_(gameTime, Math.random());
                }
                float randomRotation = (float)(this.wobbleRandom.f_117927_ + (double)((float)this.hash(seed) / 2.1474836E9f));
                return Mth.m_14091_((float)randomRotation, (float)1.0f);
            }

            private int hash(int seed) {
                return seed * 1327217883;
            }

            private double getAngleTo(Vec3 portalPos, Entity player) {
                return Math.atan2(portalPos.m_7094_() - player.m_20189_(), portalPos.m_7096_() - player.m_20185_());
            }
        }
    }
}

