/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.init;

import iskallia.vault.init.ModNetwork;
import iskallia.vault.mixin.MixinBooleanValue;
import iskallia.vault.mixin.MixinIntegerValue;
import iskallia.vault.network.message.ClientboundSyncVaultAllowWaypointsMessage;
import java.util.function.BiConsumer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber
public class ModGameRules {
    public static GameRules.Key<GameRules.BooleanValue> FINAL_VAULT_ALLOW_PARTY;
    public static GameRules.Key<GameRules.BooleanValue> VAULT_JOIN_REQUIRE_PARTY;
    public static GameRules.Key<GameRules.IntegerValue> VAULT_TEMPLATE_CACHE_SIZE;
    public static GameRules.Key<GameRules.BooleanValue> CASUAL_VAULTS;
    public static GameRules.Key<GameRules.BooleanValue> VAULT_ALLOW_WAYPOINTS;

    public static void initialize() {
        FINAL_VAULT_ALLOW_PARTY = ModGameRules.register("finalVaultAllowParty", GameRules.Category.MISC, ModGameRules.booleanRule(true));
        VAULT_JOIN_REQUIRE_PARTY = ModGameRules.register("vaultJoinRequireParty", GameRules.Category.MISC, ModGameRules.booleanRule(true));
        VAULT_TEMPLATE_CACHE_SIZE = ModGameRules.register("vaultTemplateCacheSize", GameRules.Category.MISC, ModGameRules.integerRule(16));
        CASUAL_VAULTS = ModGameRules.register("vaultCasualMode", GameRules.Category.MISC, ModGameRules.booleanRule(false));
        VAULT_ALLOW_WAYPOINTS = ModGameRules.register("vaultAllowWaypoints", GameRules.Category.MISC, ModGameRules.booleanRule(false, (server, value) -> ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new ClientboundSyncVaultAllowWaypointsMessage(value.m_46223_()))));
    }

    public static <T extends GameRules.Value<T>> GameRules.Key<T> register(String name, GameRules.Category category, GameRules.Type<T> type) {
        return GameRules.m_46189_((String)name, (GameRules.Category)category, type);
    }

    public static GameRules.Type<GameRules.BooleanValue> booleanRule(boolean defaultValue) {
        return MixinBooleanValue.create(defaultValue, (minecraftServer, booleanValue) -> {});
    }

    public static GameRules.Type<GameRules.BooleanValue> booleanRule(boolean defaultValue, BiConsumer<MinecraftServer, GameRules.BooleanValue> changeListener) {
        return MixinBooleanValue.create(defaultValue, changeListener);
    }

    public static GameRules.Type<GameRules.IntegerValue> integerRule(int defaultValue) {
        return MixinIntegerValue.create(defaultValue);
    }

    @SubscribeEvent
    public static void syncGameRules(OnDatapackSyncEvent event) {
        ServerPlayer player = event.getPlayer();
        if (player == null) {
            event.getPlayerList().m_11314_().forEach(serverPlayer -> ModNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new ClientboundSyncVaultAllowWaypointsMessage(serverPlayer.m_183503_().m_46469_().m_46207_(VAULT_ALLOW_WAYPOINTS))));
            return;
        }
        ModNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ClientboundSyncVaultAllowWaypointsMessage(player.m_183503_().m_46469_().m_46207_(VAULT_ALLOW_WAYPOINTS)));
    }

    @SubscribeEvent
    public static void syncGameRulesOnDimensionChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        ModNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new ClientboundSyncVaultAllowWaypointsMessage(serverPlayer.m_183503_().m_46469_().m_46207_(VAULT_ALLOW_WAYPOINTS)));
    }
}

