/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.init;

import iskallia.vault.VaultMod;
import iskallia.vault.entity.IPlayerSkinHolder;
import iskallia.vault.entity.entity.AggressiveCowBossEntity;
import iskallia.vault.entity.entity.AggressiveCowEntity;
import iskallia.vault.entity.entity.ArenaBossEntity;
import iskallia.vault.entity.entity.ArenaTrackerEntity;
import iskallia.vault.entity.entity.BlueBlazeEntity;
import iskallia.vault.entity.entity.BoogiemanEntity;
import iskallia.vault.entity.entity.DollMiniMeEntity;
import iskallia.vault.entity.entity.DrillArrowEntity;
import iskallia.vault.entity.entity.EffectCloudEntity;
import iskallia.vault.entity.entity.EtchingVendorEntity;
import iskallia.vault.entity.entity.EternalEntity;
import iskallia.vault.entity.entity.FighterEntity;
import iskallia.vault.entity.entity.FloatingItemEntity;
import iskallia.vault.entity.entity.MonsterEyeEntity;
import iskallia.vault.entity.entity.RobotEntity;
import iskallia.vault.entity.entity.SpiritEntity;
import iskallia.vault.entity.entity.TreasureGoblinEntity;
import iskallia.vault.entity.entity.VaultFighterEntity;
import iskallia.vault.entity.entity.VaultGuardianEntity;
import iskallia.vault.entity.entity.VaultGummySoldier;
import iskallia.vault.entity.entity.VaultSandEntity;
import iskallia.vault.entity.entity.VaultSpiderBabyEntity;
import iskallia.vault.entity.entity.VaultSpiderEntity;
import iskallia.vault.entity.entity.elite.EliteDrownedEntity;
import iskallia.vault.entity.entity.elite.EliteHuskEntity;
import iskallia.vault.entity.entity.elite.EliteSpiderEntity;
import iskallia.vault.entity.entity.elite.EliteStrayEntity;
import iskallia.vault.entity.entity.elite.EliteWitherSkeleton;
import iskallia.vault.entity.entity.elite.EliteZombieEntity;
import iskallia.vault.entity.entity.eyesore.EyesoreEntity;
import iskallia.vault.entity.entity.eyesore.EyesoreFireballEntity;
import iskallia.vault.entity.entity.eyesore.EyestalkEntity;
import iskallia.vault.entity.entity.tier1.Tier1CreeperEntity;
import iskallia.vault.entity.entity.tier1.Tier1DrownedEntity;
import iskallia.vault.entity.entity.tier1.Tier1EndermanEntity;
import iskallia.vault.entity.entity.tier1.Tier1HuskEntity;
import iskallia.vault.entity.entity.tier1.Tier1PiglinEntity;
import iskallia.vault.entity.entity.tier1.Tier1SkeletonEntity;
import iskallia.vault.entity.entity.tier1.Tier1StrayEntity;
import iskallia.vault.entity.entity.tier1.Tier1WitherSkeletonEntity;
import iskallia.vault.entity.entity.tier1.Tier1ZombieEntity;
import iskallia.vault.entity.model.FighterModel;
import iskallia.vault.entity.model.ModModelLayers;
import iskallia.vault.entity.model.TreasureGoblinModel;
import iskallia.vault.entity.model.VaultSpiderBabyModel;
import iskallia.vault.entity.model.elite.EliteDrownedModel;
import iskallia.vault.entity.model.elite.EliteHuskModel;
import iskallia.vault.entity.model.elite.EliteSkeletonModel;
import iskallia.vault.entity.model.elite.EliteSpiderModel;
import iskallia.vault.entity.model.elite.EliteStrayModel;
import iskallia.vault.entity.model.elite.EliteWitherSkeletonModel;
import iskallia.vault.entity.model.elite.EliteZombieModel;
import iskallia.vault.entity.model.eyesore.EyesoreModel;
import iskallia.vault.entity.model.eyesore.EyestalkModel;
import iskallia.vault.entity.renderer.elite.EliteEnderOrnamentLayer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.registries.DataSerializerEntry;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;

public class ModEntities {
    public static final DeferredRegister<DataSerializerEntry> ENTITY_DATA_SERIALIZERS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.DATA_SERIALIZERS, (String)"the_vault");
    public static List<EntityType<VaultFighterEntity>> VAULT_FIGHTER_TYPES;
    public static EntityType<FighterEntity> FIGHTER;
    public static EntityType<ArenaBossEntity> ARENA_BOSS;
    public static EntityType<ArenaTrackerEntity> ARENA_TRACKER;
    public static EntityType<VaultGuardianEntity> VAULT_GUARDIAN;
    public static EntityType<EternalEntity> ETERNAL;
    public static EntityType<TreasureGoblinEntity> TREASURE_GOBLIN;
    public static EntityType<AggressiveCowEntity> AGGRESSIVE_COW;
    public static EntityType<EtchingVendorEntity> ETCHING_VENDOR;
    public static EntityType<VaultSpiderEntity> VAULT_SPIDER;
    public static EntityType<VaultSpiderBabyEntity> VAULT_SPIDER_BABY;
    public static EntityType<VaultGummySoldier> VAULT_GREEN_GUMMY_SOLDIER;
    public static EntityType<VaultGummySoldier> VAULT_BLUE_GUMMY_SOLDIER;
    public static EntityType<VaultGummySoldier> VAULT_YELLOW_GUMMY_SOLDIER;
    public static EntityType<VaultGummySoldier> VAULT_RED_GUMMY_SOLDIER;
    public static EntityType<MonsterEyeEntity> MONSTER_EYE;
    public static EntityType<RobotEntity> ROBOT;
    public static EntityType<BlueBlazeEntity> BLUE_BLAZE;
    public static EntityType<BoogiemanEntity> BOOGIEMAN;
    public static EntityType<AggressiveCowBossEntity> AGGRESSIVE_COW_BOSS;
    public static EntityType<EyesoreEntity> EYESORE;
    public static EntityType<EyestalkEntity> EYESTALK;
    public static EntityType<DollMiniMeEntity> DOLL_MINI_ME;
    public static EntityType<EliteZombieEntity> ELITE_ZOMBIE;
    public static EntityType<EliteHuskEntity> ELITE_HUSK;
    public static EntityType<EliteDrownedEntity> ELITE_DROWNED;
    public static EntityType<EliteSpiderEntity> ELITE_SPIDER;
    public static EntityType<Skeleton> ELITE_SKELETON;
    public static EntityType<EliteStrayEntity> ELITE_STRAY;
    public static EntityType<EliteWitherSkeleton> ELITE_WITHER_SKELETON;
    public static EntityType<EnderMan> ELITE_ENDERMAN;
    public static EntityType<Witch> ELITE_WITCH;
    public static EntityType<Tier1CreeperEntity> T1_CREEPER;
    public static EntityType<Tier1DrownedEntity> T1_DROWNED;
    public static EntityType<Tier1EndermanEntity> T1_ENDERMAN;
    public static EntityType<Tier1HuskEntity> T1_HUSK;
    public static EntityType<Tier1PiglinEntity> T1_PIGLIN;
    public static EntityType<Tier1SkeletonEntity> T1_SKELETON;
    public static EntityType<Tier1StrayEntity> T1_STRAY;
    public static EntityType<Tier1WitherSkeletonEntity> T1_WITHER_SKELETON;
    public static EntityType<Tier1ZombieEntity> T1_ZOMBIE;
    public static EntityType<DrillArrowEntity> DRILL_ARROW;
    public static EntityType<EffectCloudEntity> EFFECT_CLOUD;
    public static EntityType<VaultSandEntity> VAULT_SAND;
    public static EntityType<FloatingItemEntity> FLOATING_ITEM;
    public static EntityType<EyesoreFireballEntity> EYESORE_FIREBALL;
    public static EntityType<SpiritEntity> SPIRIT;
    public static EntityType<FighterEntity.ThrowableBrick> BRICK;
    private static final Map<EntityType<? extends LivingEntity>, Supplier<AttributeSupplier.Builder>> ATTRIBUTE_BUILDERS;

    public static void register(RegistryEvent.Register<EntityType<?>> event) {
        for (int i = 0; i < 10; ++i) {
            VAULT_FIGHTER_TYPES.add(ModEntities.registerVaultFighter(i, event));
        }
        FIGHTER = ModEntities.registerLiving("fighter", EntityType.Builder.m_20704_(FighterEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.6f, 1.95f), Zombie::m_34328_, event);
        ARENA_BOSS = ModEntities.registerLiving("arena_boss", EntityType.Builder.m_20704_(ArenaBossEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.6f, 1.95f), ArenaBossEntity::createAttributes, event);
        ARENA_TRACKER = ModEntities.registerLiving("arena_tracker", EntityType.Builder.m_20704_(ArenaTrackerEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.0f, 0.0f), Zombie::m_34328_, event);
        VAULT_GUARDIAN = ModEntities.registerLiving("vault_guardian", EntityType.Builder.m_20704_(VaultGuardianEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(1.3f, 2.95f), Zombie::m_34328_, event);
        ETERNAL = ModEntities.registerLiving("eternal", EntityType.Builder.m_20704_(EternalEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.6f, 1.95f), Zombie::m_34328_, event);
        TREASURE_GOBLIN = ModEntities.registerLiving("treasure_goblin", EntityType.Builder.m_20704_(TreasureGoblinEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.5f, 1.5f), Zombie::m_34328_, event);
        AGGRESSIVE_COW = ModEntities.registerLiving("aggressive_cow", EntityType.Builder.m_20704_(AggressiveCowEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.9f, 1.4f).m_20702_(8), AggressiveCowEntity::createAttributes, event);
        ETCHING_VENDOR = ModEntities.registerLiving("etching_vendor", EntityType.Builder.m_20704_(EtchingVendorEntity::new, (MobCategory)MobCategory.MISC), Zombie::m_34328_, event);
        VAULT_SPIDER = ModEntities.registerLiving("vault_spider", EntityType.Builder.m_20704_(VaultSpiderEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.7f, 0.5f), Spider::m_33815_, event);
        VAULT_SPIDER_BABY = ModEntities.registerLiving("vault_spider_baby", EntityType.Builder.m_20704_(VaultSpiderBabyEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.8f, 0.5f), Spider::m_33815_, event);
        VAULT_GREEN_GUMMY_SOLDIER = ModEntities.registerLiving("vault_green_gummy_soldier", EntityType.Builder.m_20704_(VaultGummySoldier::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.72f, 1.95f).m_20702_(8), VaultGummySoldier::createAttributes, event);
        VAULT_BLUE_GUMMY_SOLDIER = ModEntities.registerLiving("vault_blue_gummy_soldier", EntityType.Builder.m_20704_(VaultGummySoldier::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.72f, 1.95f).m_20702_(8), VaultGummySoldier::createAttributes, event);
        VAULT_YELLOW_GUMMY_SOLDIER = ModEntities.registerLiving("vault_yellow_gummy_soldier", EntityType.Builder.m_20704_(VaultGummySoldier::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.72f, 1.95f).m_20702_(8), VaultGummySoldier::createAttributes, event);
        VAULT_RED_GUMMY_SOLDIER = ModEntities.registerLiving("vault_red_gummy_soldier", EntityType.Builder.m_20704_(VaultGummySoldier::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.72f, 1.95f).m_20702_(8), VaultGummySoldier::createAttributes, event);
        MONSTER_EYE = ModEntities.registerLiving("monster_eye", EntityType.Builder.m_20704_(MonsterEyeEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(4.08f, 4.08f), Zombie::m_34328_, event);
        ROBOT = ModEntities.registerLiving("robot", EntityType.Builder.m_20704_(RobotEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(2.8f, 5.4f), Zombie::m_34328_, event);
        BLUE_BLAZE = ModEntities.registerLiving("blue_blaze", EntityType.Builder.m_20704_(BlueBlazeEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(1.2f, 3.6f), Zombie::m_34328_, event);
        BOOGIEMAN = ModEntities.registerLiving("boogieman", EntityType.Builder.m_20704_(BoogiemanEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(1.2f, 3.9f), Zombie::m_34328_, event);
        AGGRESSIVE_COW_BOSS = ModEntities.registerLiving("aggressive_cow_boss", EntityType.Builder.m_20704_(AggressiveCowBossEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(2.6999998f, 4.2f), AggressiveCowEntity::createAttributes, event);
        EYESORE = ModEntities.registerLiving("eyesore", EntityType.Builder.m_20704_(EyesoreEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(5.5f, 5.5f), EyesoreEntity::createAttributes, event);
        EYESTALK = ModEntities.registerLiving("eyestalk", EntityType.Builder.m_20704_(EyestalkEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.2f, 0.4f), EyestalkEntity::createAttributes, event);
        DOLL_MINI_ME = ModEntities.registerLiving("doll_mini_me", EntityType.Builder.m_20704_(DollMiniMeEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.6f, 1.95f), DollMiniMeEntity::createAttributes, event);
        ELITE_ZOMBIE = ModEntities.registerLiving("elite_zombie", EntityType.Builder.m_20704_(EliteZombieEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.72f, 2.85f).m_20702_(8), Zombie::m_34328_, event);
        ELITE_HUSK = ModEntities.registerLiving("elite_husk", EntityType.Builder.m_20704_(EliteHuskEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.72f, 2.85f).m_20702_(8), Zombie::m_34328_, event);
        ELITE_DROWNED = ModEntities.registerLiving("elite_drowned", EntityType.Builder.m_20704_(EliteDrownedEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.72f, 2.85f).m_20702_(8), Zombie::m_34328_, event);
        ELITE_SPIDER = ModEntities.registerLiving("elite_spider", EntityType.Builder.m_20704_(EliteSpiderEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(1.68f, 2.0f).m_20702_(8), Spider::m_33815_, event);
        ELITE_SKELETON = ModEntities.registerLiving("elite_skeleton", EntityType.Builder.m_20704_(Skeleton::new, (MobCategory)MobCategory.MONSTER).m_20719_().m_20699_(0.75f, 2.85f).m_20702_(8), AbstractSkeleton::m_32166_, event);
        ELITE_STRAY = ModEntities.registerLiving("elite_stray", EntityType.Builder.m_20704_(EliteStrayEntity::new, (MobCategory)MobCategory.MONSTER).m_20719_().m_20699_(0.72f, 2.39f).m_20714_(new Block[]{Blocks.f_152499_}).m_20702_(8), AbstractSkeleton::m_32166_, event);
        ELITE_WITHER_SKELETON = ModEntities.registerLiving("elite_wither_skeleton", EntityType.Builder.m_20704_(EliteWitherSkeleton::new, (MobCategory)MobCategory.MONSTER).m_20719_().m_20714_(new Block[]{Blocks.f_50070_}).m_20699_(0.75f, 2.85f).m_20702_(8), AbstractSkeleton::m_32166_, event);
        ELITE_ENDERMAN = ModEntities.registerLiving("elite_enderman", EntityType.Builder.m_20704_(EnderMan::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.72f, 3.5f).m_20702_(8), EnderMan::m_32541_, event);
        ELITE_WITCH = ModEntities.registerLiving("elite_witch", EntityType.Builder.m_20704_(Witch::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.72f, 2.34f).m_20702_(8), Witch::m_34155_, event);
        T1_CREEPER = ModEntities.registerLiving("t1_creeper", EntityType.Builder.m_20704_(Tier1CreeperEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.72f, 2.34f).m_20702_(8), Creeper::m_32318_, event);
        T1_DROWNED = ModEntities.registerLiving("t1_drowned", EntityType.Builder.m_20704_(Tier1DrownedEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.72f, 2.34f).m_20702_(8), Zombie::m_34328_, event);
        T1_ENDERMAN = ModEntities.registerLiving("t1_enderman", EntityType.Builder.m_20704_(Tier1EndermanEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.72f, 2.34f).m_20702_(8), EnderMan::m_32541_, event);
        T1_HUSK = ModEntities.registerLiving("t1_husk", EntityType.Builder.m_20704_(Tier1HuskEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.72f, 2.34f).m_20702_(8), Zombie::m_34328_, event);
        T1_PIGLIN = ModEntities.registerLiving("t1_piglin", EntityType.Builder.m_20704_(Tier1PiglinEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.72f, 2.34f).m_20702_(8), Piglin::m_34770_, event);
        T1_SKELETON = ModEntities.registerLiving("t1_skeleton", EntityType.Builder.m_20704_(Tier1SkeletonEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.72f, 2.34f).m_20702_(8), AbstractSkeleton::m_32166_, event);
        T1_STRAY = ModEntities.registerLiving("t1_stray", EntityType.Builder.m_20704_(Tier1StrayEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.72f, 2.34f).m_20702_(8), AbstractSkeleton::m_32166_, event);
        T1_WITHER_SKELETON = ModEntities.registerLiving("t1_wither_skeleton", EntityType.Builder.m_20704_(Tier1WitherSkeletonEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.72f, 2.34f).m_20702_(8), AbstractSkeleton::m_32166_, event);
        T1_ZOMBIE = ModEntities.registerLiving("t1_zombie", EntityType.Builder.m_20704_(Tier1ZombieEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.72f, 2.34f).m_20702_(8), Zombie::m_34328_, event);
        DRILL_ARROW = ModEntities.register("drill_arrow", EntityType.Builder.m_20704_(DrillArrowEntity::new, (MobCategory)MobCategory.MISC), event);
        EFFECT_CLOUD = ModEntities.register("effect_cloud", EntityType.Builder.m_20704_(EffectCloudEntity::new, (MobCategory)MobCategory.MISC), event);
        VAULT_SAND = ModEntities.register("vault_sand", EntityType.Builder.m_20704_(VaultSandEntity::new, (MobCategory)MobCategory.MISC), event);
        FLOATING_ITEM = ModEntities.register("floating_item", EntityType.Builder.m_20704_(FloatingItemEntity::new, (MobCategory)MobCategory.MISC), event);
        EYESORE_FIREBALL = ModEntities.register("eyesore_fireball", EntityType.Builder.m_20704_(EyesoreFireballEntity::new, (MobCategory)MobCategory.MISC), event);
        SPIRIT = ModEntities.registerLiving("spirit", EntityType.Builder.m_20704_(SpiritEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.6f, 1.8f).m_20702_(8), Witch::m_34155_, event);
        BRICK = ModEntities.register("brick", EntityType.Builder.m_20704_(FighterEntity.ThrowableBrick::new, (MobCategory)MobCategory.MISC).m_20699_(0.25f, 0.25f).m_20702_(4).m_20717_(10), event);
    }

    private static EntityType<VaultFighterEntity> registerVaultFighter(int count, RegistryEvent.Register<EntityType<?>> event) {
        return ModEntities.registerLiving((String)(count > 0 ? "vault_fighter_" + count : "vault_fighter"), EntityType.Builder.m_20704_(VaultFighterEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.6f, 1.95f), Zombie::m_34328_, event);
    }

    private static <T extends Entity> EntityType<T> register(String name, EntityType.Builder<T> builder, RegistryEvent.Register<EntityType<?>> event) {
        EntityType entityType = builder.m_20712_(VaultMod.sId(name));
        event.getRegistry().register((IForgeRegistryEntry)((EntityType)entityType.setRegistryName(VaultMod.id(name))));
        return entityType;
    }

    private static <T extends LivingEntity> EntityType<T> registerLiving(String name, EntityType.Builder<T> builder, Supplier<AttributeSupplier.Builder> attributes, RegistryEvent.Register<EntityType<?>> event) {
        EntityType<T> entityType = ModEntities.register(name, builder, event);
        if (attributes != null) {
            ATTRIBUTE_BUILDERS.put(entityType, attributes);
        }
        return entityType;
    }

    public static void registerAttributes(EntityAttributeCreationEvent event) {
        ATTRIBUTE_BUILDERS.forEach((e, b) -> event.put(e, ((AttributeSupplier.Builder)b.get()).m_22265_()));
        ATTRIBUTE_BUILDERS.clear();
    }

    static {
        ENTITY_DATA_SERIALIZERS.register("optional_game_profile", () -> new DataSerializerEntry(IPlayerSkinHolder.OPTIONAL_GAME_PROFILE_SERIALIZER));
        VAULT_FIGHTER_TYPES = new ArrayList<EntityType<VaultFighterEntity>>();
        ATTRIBUTE_BUILDERS = new HashMap<EntityType<? extends LivingEntity>, Supplier<AttributeSupplier.Builder>>();
    }

    public static class Models {
        public static void registerLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
            Supplier<LayerDefinition> outerArmorLayerSupplier = () -> LayerDefinition.m_171565_((MeshDefinition)HumanoidModel.m_170681_((CubeDeformation)new CubeDeformation(1.0f), (float)0.0f), (int)64, (int)32);
            Supplier<LayerDefinition> innerArmorLayerSupplier = () -> LayerDefinition.m_171565_((MeshDefinition)HumanoidModel.m_170681_((CubeDeformation)new CubeDeformation(0.5f), (float)0.0f), (int)64, (int)32);
            event.registerLayerDefinition(ModModelLayers.TREASURE_GOBLIN, TreasureGoblinModel::createBodyLayer);
            event.registerLayerDefinition(ModModelLayers.EYESORE, EyesoreModel::createBodyLayer);
            event.registerLayerDefinition(ModModelLayers.EYESTALK, EyestalkModel::createBodyLayer);
            event.registerLayerDefinition(ModModelLayers.ETERNAL, Models::getPlayerModelDefinition);
            event.registerLayerDefinition(ModModelLayers.STATUE, Models::getPlayerModelDefinition);
            event.registerLayerDefinition(ModModelLayers.FIGHTER, FighterModel::createBodyLayer);
            event.registerLayerDefinition(ModModelLayers.FIGHTER_T3, FighterModel::createBodyLayerT3);
            event.registerLayerDefinition(ModModelLayers.FIGHTER_T4, FighterModel::createBodyLayerT4);
            event.registerLayerDefinition(ModModelLayers.ELITE_ZOMBIE, EliteZombieModel::createBodyLayer);
            event.registerLayerDefinition(ModModelLayers.ELITE_HUSK, EliteHuskModel::createBodyLayer);
            event.registerLayerDefinition(ModModelLayers.ELITE_DROWNED, EliteDrownedModel::createBodyLayer);
            event.registerLayerDefinition(ModModelLayers.ELITE_DROWNED_INNER_ARMOR, innerArmorLayerSupplier);
            event.registerLayerDefinition(ModModelLayers.ELITE_DROWNED_OUTER_ARMOR, outerArmorLayerSupplier);
            event.registerLayerDefinition(ModModelLayers.ELITE_SPIDER, EliteSpiderModel::createBodyLayer);
            event.registerLayerDefinition(ModModelLayers.ELITE_SKELETON, EliteSkeletonModel::createBodyLayer);
            event.registerLayerDefinition(ModModelLayers.ELITE_STRAY, EliteStrayModel::createBodyLayer);
            event.registerLayerDefinition(ModModelLayers.ELITE_WITHER_SKELETON, EliteWitherSkeletonModel::createBodyLayer);
            event.registerLayerDefinition(ModModelLayers.ELITE_ENDERMAN_ORNAMENT, EliteEnderOrnamentLayer.EnderOrnamentModel::createBodyLayer);
            event.registerLayerDefinition(ModModelLayers.VAULT_SPIDER_BABY, VaultSpiderBabyModel::createBodyLayer);
        }

        @NotNull
        private static LayerDefinition getPlayerModelDefinition() {
            return LayerDefinition.m_171565_((MeshDefinition)PlayerModel.m_170825_((CubeDeformation)CubeDeformation.f_171458_, (boolean)true), (int)64, (int)64);
        }
    }
}

