/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.init;

import iskallia.vault.VaultMod;
import iskallia.vault.dynamodel.DynamicBakedModel;
import iskallia.vault.dynamodel.DynamicModel;
import iskallia.vault.dynamodel.DynamicModelProperties;
import iskallia.vault.dynamodel.baked.JsonFileBakedModel;
import iskallia.vault.dynamodel.model.armor.ArmorLayers;
import iskallia.vault.dynamodel.model.armor.ArmorModel;
import iskallia.vault.dynamodel.model.armor.ArmorPieceModel;
import iskallia.vault.dynamodel.model.item.CoconutShieldModel;
import iskallia.vault.dynamodel.model.item.HandHeldModel;
import iskallia.vault.dynamodel.model.item.PlainItemModel;
import iskallia.vault.dynamodel.model.item.ShieldModel;
import iskallia.vault.dynamodel.registry.ArmorPieceModelRegistry;
import iskallia.vault.dynamodel.registry.DynamicModelRegistries;
import iskallia.vault.dynamodel.registry.DynamicModelRegistry;
import iskallia.vault.gear.model.armor.layers.AngelArmorLayers;
import iskallia.vault.gear.model.armor.layers.ArcadeArmorLayers;
import iskallia.vault.gear.model.armor.layers.AtomaticArmorLayers;
import iskallia.vault.gear.model.armor.layers.BardArmorLayers;
import iskallia.vault.gear.model.armor.layers.BoneDragonArmorLayers;
import iskallia.vault.gear.model.armor.layers.BotaniaArmorLayers;
import iskallia.vault.gear.model.armor.layers.BuilderArmorLayers;
import iskallia.vault.gear.model.armor.layers.BumboCactoniArmorLayers;
import iskallia.vault.gear.model.armor.layers.CakeArmorLayers;
import iskallia.vault.gear.model.armor.layers.ClericArmorLayers;
import iskallia.vault.gear.model.armor.layers.CreateArmorLayers;
import iskallia.vault.gear.model.armor.layers.CrusaderArmorLayers;
import iskallia.vault.gear.model.armor.layers.DankArmorLayers;
import iskallia.vault.gear.model.armor.layers.DeerArmorLayers;
import iskallia.vault.gear.model.armor.layers.DevilArmorLayers;
import iskallia.vault.gear.model.armor.layers.DonkeyArmorLayers;
import iskallia.vault.gear.model.armor.layers.DruidArmorLayers;
import iskallia.vault.gear.model.armor.layers.FairyArmorLayers;
import iskallia.vault.gear.model.armor.layers.FlamingoArmorLayers;
import iskallia.vault.gear.model.armor.layers.FluxArmorLayers;
import iskallia.vault.gear.model.armor.layers.FurnaceArmorLayers;
import iskallia.vault.gear.model.armor.layers.GladiatorArmorLayers;
import iskallia.vault.gear.model.armor.layers.GrizzlyArmorLayers;
import iskallia.vault.gear.model.armor.layers.HellCowArmorLayers;
import iskallia.vault.gear.model.armor.layers.HellDuckArmorLayers;
import iskallia.vault.gear.model.armor.layers.HippopotamusArmorLayers;
import iskallia.vault.gear.model.armor.layers.IskallIbeArmorLayers;
import iskallia.vault.gear.model.armor.layers.JardoonCheeseArmorLayers;
import iskallia.vault.gear.model.armor.layers.JawboneArmorLayers;
import iskallia.vault.gear.model.armor.layers.KitsuneArmorLayers;
import iskallia.vault.gear.model.armor.layers.KnightArmorLayers;
import iskallia.vault.gear.model.armor.layers.LeprechaunArmorLayers;
import iskallia.vault.gear.model.armor.layers.LionguardArmorLayers;
import iskallia.vault.gear.model.armor.layers.MagmaticArmorLayers;
import iskallia.vault.gear.model.armor.layers.MailboxArmorLayers;
import iskallia.vault.gear.model.armor.layers.MekaArmorLayers;
import iskallia.vault.gear.model.armor.layers.MinotaurArmorLayers;
import iskallia.vault.gear.model.armor.layers.MonkArmorLayers;
import iskallia.vault.gear.model.armor.layers.OrcArmorLayers;
import iskallia.vault.gear.model.armor.layers.PaladinArmorLayers;
import iskallia.vault.gear.model.armor.layers.PlatemailArmorLayers;
import iskallia.vault.gear.model.armor.layers.PowahArmorLayers;
import iskallia.vault.gear.model.armor.layers.ReinforcedPlatemailArmorLayers;
import iskallia.vault.gear.model.armor.layers.RhinoArmorLayers;
import iskallia.vault.gear.model.armor.layers.RoboticArmorLayers;
import iskallia.vault.gear.model.armor.layers.RogueArmorLayers;
import iskallia.vault.gear.model.armor.layers.RoyalArmorLayers;
import iskallia.vault.gear.model.armor.layers.RustyKnightArmorLayers;
import iskallia.vault.gear.model.armor.layers.RustyRaiderArmorLayers;
import iskallia.vault.gear.model.armor.layers.RustyScavengerArmorLayers;
import iskallia.vault.gear.model.armor.layers.SamuraiArmorLayers;
import iskallia.vault.gear.model.armor.layers.ScarecrowArmorLayers;
import iskallia.vault.gear.model.armor.layers.ShadowKingArmorLayers;
import iskallia.vault.gear.model.armor.layers.SkallibombaArmorLayers;
import iskallia.vault.gear.model.armor.layers.SoulEaterArmorLayers;
import iskallia.vault.gear.model.armor.layers.SpikyPlatemailArmorLayers;
import iskallia.vault.gear.model.armor.layers.SquireArmorLayers;
import iskallia.vault.gear.model.armor.layers.StressFlowerArmorLayers;
import iskallia.vault.gear.model.armor.layers.ThermalArmorLayers;
import iskallia.vault.gear.model.armor.layers.TrashArmorLayers;
import iskallia.vault.gear.model.armor.layers.VillagerArmorLayers;
import iskallia.vault.gear.model.armor.layers.WarriorArmorLayers;
import iskallia.vault.gear.model.armor.layers.WitchArmorLayers;
import iskallia.vault.gear.model.armor.layers.WitherArmorLayers;
import iskallia.vault.gear.model.armor.layers.WizardArmorLayers;
import iskallia.vault.gear.model.armor.layers.XnetArmorLayers;
import iskallia.vault.gear.model.armor.layers.ZombieArmorLayers;
import iskallia.vault.gear.renderer.VaultArmorRenderProperties;
import iskallia.vault.init.ModItems;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ForgeModelBakery;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModDynamicModels {
    public static final DynamicModelRegistries REGISTRIES = new DynamicModelRegistries();
    public static final ResourceLocation EMPTY_TEXTURE = VaultMod.id("item/empty");

    public static void initItemAssociations() {
        REGISTRIES.associate((Item)ModItems.HELMET, Armor.PIECE_REGISTRY.getPiecesOf(EquipmentSlot.HEAD)).associate((Item)ModItems.CHESTPLATE, Armor.PIECE_REGISTRY.getPiecesOf(EquipmentSlot.CHEST)).associate((Item)ModItems.LEGGINGS, Armor.PIECE_REGISTRY.getPiecesOf(EquipmentSlot.LEGS)).associate((Item)ModItems.BOOTS, Armor.PIECE_REGISTRY.getPiecesOf(EquipmentSlot.FEET)).associate((Item)ModItems.SWORD, Swords.REGISTRY).associate((Item)ModItems.AXE, Axes.REGISTRY).associate(ModItems.IDOL_TIMEKEEPER, Idols.REGISTRY_WENDARR).associate(ModItems.IDOL_MALEVOLENCE, Idols.REGISTRY_IDONA).associate(ModItems.IDOL_BENEVOLENT, Idols.REGISTRY_VELARA).associate(ModItems.IDOL_OMNISCIENT, Idols.REGISTRY_TENOS).associate((Item)ModItems.SHIELD, Shields.REGISTRY).associate((Item)ModItems.RELIC, Relics.RELIC_REGISTRY).associate(ModItems.RELIC_FRAGMENT, Relics.FRAGMENT_REGISTRY);
    }

    public static void initCauldronWashables() {
        CauldronInteraction.f_175607_.put(ModItems.MAGNET_ITEM, CauldronInteraction.f_175615_);
        CauldronInteraction.f_175607_.put(ModItems.HELMET, CauldronInteraction.f_175615_);
        CauldronInteraction.f_175607_.put(ModItems.CHESTPLATE, CauldronInteraction.f_175615_);
        CauldronInteraction.f_175607_.put(ModItems.LEGGINGS, CauldronInteraction.f_175615_);
        CauldronInteraction.f_175607_.put(ModItems.BOOTS, CauldronInteraction.f_175615_);
        CauldronInteraction.f_175607_.put(ModItems.SWORD, CauldronInteraction.f_175615_);
        CauldronInteraction.f_175607_.put(ModItems.AXE, CauldronInteraction.f_175615_);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void registerLayerGeometries(EntityRenderersEvent.RegisterLayerDefinitions event) {
        Armor.PIECE_REGISTRY.forEach((modelName, piece) -> {
            EquipmentSlot equipmentSlot = piece.getEquipmentSlot();
            ModelLayerLocation layerLocation = piece.getLayerLocation();
            ArmorLayers modelLayers = piece.getLayers();
            event.registerLayerDefinition(layerLocation, modelLayers.getGeometrySupplier(equipmentSlot));
        });
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void bakeModelLayers(EntityRenderersEvent.AddLayers event) {
        EntityModelSet entityModelSet = event.getEntityModels();
        Armor.PIECE_REGISTRY.forEach((pieceId, piece) -> {
            ModelPart root = entityModelSet.m_171103_(piece.getLayerLocation());
            EquipmentSlot equipmentSlot = piece.getEquipmentSlot();
            ArmorLayers model = piece.getLayers();
            ArmorLayers.BaseLayer layer = model.getLayerSupplier(equipmentSlot).supply((ArmorPieceModel)piece, root);
            VaultArmorRenderProperties.BAKED_LAYERS.put((ResourceLocation)pieceId, layer);
        });
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void stitchTextures(TextureStitchEvent.Pre event) {
        if (!event.getAtlas().m_118330_().equals((Object)TextureAtlas.f_118259_)) {
            return;
        }
        event.addSprite(EMPTY_TEXTURE);
        ResourceManager resourceManager = Minecraft.m_91087_().m_91098_();
        REGISTRIES.getUniqueRegistries().forEach(registry -> registry.forEach((modelId, dynamicModel) -> {
            ResourceLocation resourceLocation = new ResourceLocation(modelId.m_135827_(), "item/" + modelId.m_135815_());
            dynamicModel.resolveTextures(resourceManager, resourceLocation).values().forEach(arg_0 -> ((TextureStitchEvent.Pre)event).addSprite(arg_0));
        }));
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void bakeModels(ModelBakeEvent event) {
        Map modelRegistry = event.getModelRegistry();
        ForgeModelBakery modelLoader = event.getModelLoader();
        ResourceManager resourceManager = Minecraft.m_91087_().m_91098_();
        REGISTRIES.getUniqueRegistries().forEach(registry -> registry.forEach((modelId, dynamicModel) -> dynamicModel.getAssociatedModelLocations().forEach(modelLocation -> {
            Object bakedIcon;
            BlockModel unbakedModel = (BlockModel)modelLoader.m_119341_((ResourceLocation)modelLocation);
            if (ModDynamicModels.jsonModelExists(resourceManager, DynamicModel.prependToId("item/", modelId))) {
                bakedIcon = unbakedModel.m_111449_((ModelBakery)modelLoader, unbakedModel, ForgeModelBakery.defaultTextureGetter(), (ModelState)SimpleModelState.IDENTITY, (ResourceLocation)modelLocation, false);
                bakedIcon = new JsonFileBakedModel((BakedModel)bakedIcon);
            } else {
                bakedIcon = dynamicModel.bakeModel((ModelResourceLocation)modelLocation, modelLoader, unbakedModel);
            }
            ResourceLocation bakedId = new ResourceLocation(modelLocation.m_135827_(), modelLocation.m_135815_());
            registry.bakeIcon(bakedId, (BakedModel)bakedIcon);
        })));
        REGISTRIES.getUniqueItems().forEach(item -> {
            ResourceLocation itemId = item.getRegistryName();
            if (itemId == null) {
                throw new InternalError("Registry name does not exist for item -> " + item);
            }
            ModelResourceLocation key = new ModelResourceLocation(itemId, "inventory");
            BakedModel oldModel = (BakedModel)modelRegistry.get(key);
            if (oldModel != null) {
                modelRegistry.put(key, new DynamicBakedModel(oldModel, (ModelBakery)modelLoader));
            }
        });
    }

    public static boolean jsonModelExists(ResourceManager manager, ResourceLocation id) {
        ResourceLocation location = new ResourceLocation(id.m_135827_(), "models/" + id.m_135815_() + ".json");
        return manager.m_7165_(location);
    }

    public static boolean textureExists(ResourceManager manager, ResourceLocation id) {
        ResourceLocation location = new ResourceLocation(id.m_135827_(), "textures/" + id.m_135815_() + ".png");
        return manager.m_7165_(location);
    }

    public static boolean hasOverlayTexture(ResourceManager manager, ResourceLocation id) {
        return ModDynamicModels.textureExists(manager, new ResourceLocation(id.m_135827_(), id.m_135815_() + "_overlay"));
    }

    public static class Armor {
        public static final ArmorPieceModelRegistry PIECE_REGISTRY = new ArmorPieceModelRegistry();
        public static final DynamicModelRegistry<ArmorModel> MODEL_REGISTRY = PIECE_REGISTRY.getArmorModels();
        public static final ArmorModel ANGEL = PIECE_REGISTRY.registerAll(((ArmorModel)new ArmorModel(VaultMod.id("gear/armor/angel"), "Angel").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll())).usingLayers(new AngelArmorLayers()).addSlot(EquipmentSlot.HEAD).addSlot(EquipmentSlot.CHEST).addSlot(EquipmentSlot.LEGS).addSlot(EquipmentSlot.FEET));
        public static final ArmorModel BARD = PIECE_REGISTRY.registerAll(((ArmorModel)new ArmorModel(VaultMod.id("gear/armor/bard"), "Bard").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll())).usingLayers(new BardArmorLayers()).addSlot(EquipmentSlot.HEAD).addSlot(EquipmentSlot.CHEST).addSlot(EquipmentSlot.LEGS).addSlot(EquipmentSlot.FEET));
        public static final ArmorModel BONE_DRAGON = PIECE_REGISTRY.registerAll(((ArmorModel)new ArmorModel(VaultMod.id("gear/armor/bone_dragon"), "Bone Dragon").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll())).usingLayers(new BoneDragonArmorLayers()).addSlot(EquipmentSlot.HEAD).addSlot(EquipmentSlot.CHEST).addSlot(EquipmentSlot.LEGS).addSlot(EquipmentSlot.FEET));
        public static final ArmorModel CLERIC = PIECE_REGISTRY.registerAll(((ArmorModel)new ArmorModel(VaultMod.id("gear/armor/cleric"), "Cleric").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll())).usingLayers(new ClericArmorLayers()).addSlot(EquipmentSlot.HEAD).addSlot(EquipmentSlot.CHEST).addSlot(EquipmentSlot.LEGS).addSlot(EquipmentSlot.FEET));
        public static final ArmorModel CRUSADER = PIECE_REGISTRY.registerAll(((ArmorModel)new ArmorModel(VaultMod.id("gear/armor/crusader"), "Crusader").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll())).usingLayers(new CrusaderArmorLayers()).addSlot(EquipmentSlot.HEAD).addSlot(EquipmentSlot.CHEST).addSlot(EquipmentSlot.LEGS).addSlot(EquipmentSlot.FEET));
        public static final ArmorModel DEER = PIECE_REGISTRY.registerAll(((ArmorModel)new ArmorModel(VaultMod.id("gear/armor/deer"), "Deer").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll())).usingLayers(new DeerArmorLayers()).addSlot(EquipmentSlot.HEAD).addSlot(EquipmentSlot.CHEST).addSlot(EquipmentSlot.LEGS).addSlot(EquipmentSlot.FEET));
        public static final ArmorModel DEVIL = PIECE_REGISTRY.registerAll(((ArmorModel)new ArmorModel(VaultMod.id("gear/armor/devil"), "Devil").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll())).usingLayers(new DevilArmorLayers()).addSlot(EquipmentSlot.HEAD).addSlot(EquipmentSlot.CHEST).addSlot(EquipmentSlot.LEGS).addSlot(EquipmentSlot.FEET));
        public static final ArmorModel DONKEY = PIECE_REGISTRY.registerAll(((ArmorModel)new ArmorModel(VaultMod.id("gear/armor/donkey"), "Donkey").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll())).usingLayers(new DonkeyArmorLayers()).addSlot(EquipmentSlot.HEAD).addSlot(EquipmentSlot.CHEST).addSlot(EquipmentSlot.LEGS).addSlot(EquipmentSlot.FEET));
        public static final ArmorModel FURNACE = PIECE_REGISTRY.registerAll(((ArmorModel)new ArmorModel(VaultMod.id("gear/armor/furnace"), "Furnace").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll())).usingLayers(new FurnaceArmorLayers()).addSlot(EquipmentSlot.HEAD).addSlot(EquipmentSlot.CHEST).addSlot(EquipmentSlot.LEGS).addSlot(EquipmentSlot.FEET));
        public static final ArmorModel GLADIATOR = PIECE_REGISTRY.registerAll(((ArmorModel)new ArmorModel(VaultMod.id("gear/armor/gladiator"), "Gladiator").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll())).usingLayers(new GladiatorArmorLayers()).addSlot(EquipmentSlot.HEAD).addSlot(EquipmentSlot.CHEST).addSlot(EquipmentSlot.LEGS).addSlot(EquipmentSlot.FEET));
        public static final ArmorModel GLADIATOR_DARK = PIECE_REGISTRY.registerAll(((ArmorModel)new ArmorModel(VaultMod.id("gear/armor/gladiator_dark"), "Dark Gladiator").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll())).usingLayers(new GladiatorArmorLayers()).addSlot(EquipmentSlot.HEAD).addSlot(EquipmentSlot.CHEST).addSlot(EquipmentSlot.LEGS).addSlot(EquipmentSlot.FEET));
        public static final ArmorModel GRIZZLY = PIECE_REGISTRY.registerAll(((ArmorModel)new ArmorModel(VaultMod.id("gear/armor/grizzly"), "Grizzly").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll())).usingLayers(new GrizzlyArmorLayers()).addSlot(EquipmentSlot.HEAD).addSlot(EquipmentSlot.CHEST).addSlot(EquipmentSlot.LEGS).addSlot(EquipmentSlot.FEET));
        public static final ArmorModel HELL_DUCK = PIECE_REGISTRY.registerAll(((ArmorModel)new ArmorModel(VaultMod.id("gear/armor/hell_duck"), "Hell Duck").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll())).usingLayers(new HellDuckArmorLayers()).addSlot(EquipmentSlot.HEAD).addSlot(EquipmentSlot.CHEST).addSlot(EquipmentSlot.LEGS).addSlot(EquipmentSlot.FEET));
        public static final ArmorModel HIPPOPOTAMUS = PIECE_REGISTRY.registerAll(((ArmorModel)new ArmorModel(VaultMod.id("gear/armor/hippopotamus"), "Hippopotamus").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll())).usingLayers(new HippopotamusArmorLayers()).addSlot(EquipmentSlot.HEAD).addSlot(EquipmentSlot.CHEST).addSlot(EquipmentSlot.LEGS).addSlot(EquipmentSlot.FEET));
        public static final ArmorModel JAWBONE = PIECE_REGISTRY.registerAll(((ArmorModel)new ArmorModel(VaultMod.id("gear/armor/jawbone"), "Jawbone").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll())).usingLayers(new JawboneArmorLayers()).addSlot(EquipmentSlot.HEAD).addSlot(EquipmentSlot.CHEST).addSlot(EquipmentSlot.LEGS).addSlot(EquipmentSlot.FEET));
        public static final ArmorModel KITSUNE = PIECE_REGISTRY.registerAll(((ArmorModel)new ArmorModel(VaultMod.id("gear/armor/kitsune"), "Kitsune").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll())).usingLayers(new KitsuneArmorLayers()).addSlot(EquipmentSlot.HEAD).addSlot(EquipmentSlot.CHEST).addSlot(EquipmentSlot.LEGS).addSlot(EquipmentSlot.FEET));
        public static final ArmorModel KNIGHT = PIECE_REGISTRY.registerAll(((ArmorModel)new ArmorModel(VaultMod.id("gear/armor/knight"), "Knight").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll())).usingLayers(new KnightArmorLayers()).addSlot(EquipmentSlot.HEAD).addSlot(EquipmentSlot.CHEST).addSlot(EquipmentSlot.LEGS).addSlot(EquipmentSlot.FEET));
        public static final ArmorModel LEPRECHAUN = PIECE_REGISTRY.registerAll(((ArmorModel)new ArmorModel(VaultMod.id("gear/armor/leprechaun"), "Leprechaun").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll())).usingLayers(new LeprechaunArmorLayers()).addSlot(EquipmentSlot.HEAD).addSlot(EquipmentSlot.CHEST).addSlot(EquipmentSlot.LEGS).addSlot(EquipmentSlot.FEET));
        public static final ArmorModel MAILBOX = PIECE_REGISTRY.registerAll(((ArmorModel)new ArmorModel(VaultMod.id("gear/armor/mailbox"), "Mailbox").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll())).usingLayers(new MailboxArmorLayers()).addSlot(EquipmentSlot.HEAD).addSlot(EquipmentSlot.CHEST).addSlot(EquipmentSlot.LEGS).addSlot(EquipmentSlot.FEET));
        public static final ArmorModel MAILBOX_DARK = PIECE_REGISTRY.registerAll(((ArmorModel)new ArmorModel(VaultMod.id("gear/armor/mailbox_dark"), "Dark Mailbox").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll())).usingLayers(new MailboxArmorLayers()).addSlot(EquipmentSlot.HEAD).addSlot(EquipmentSlot.CHEST).addSlot(EquipmentSlot.LEGS).addSlot(EquipmentSlot.FEET));
        public static final ArmorModel MINOTAUR = PIECE_REGISTRY.registerAll(((ArmorModel)new ArmorModel(VaultMod.id("gear/armor/minotaur"), "Minotaur").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll())).usingLayers(new MinotaurArmorLayers()).addSlot(EquipmentSlot.HEAD).addSlot(EquipmentSlot.CHEST).addSlot(EquipmentSlot.LEGS).addSlot(EquipmentSlot.FEET));
        public static final ArmorModel MINOTAUR_DARK = PIECE_REGISTRY.registerAll(((ArmorModel)new ArmorModel(VaultMod.id("gear/armor/minotaur_dark"), "Dark Minotaur").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll())).usingLayers(new MinotaurArmorLayers()).addSlot(EquipmentSlot.HEAD).addSlot(EquipmentSlot.CHEST).addSlot(EquipmentSlot.LEGS).addSlot(EquipmentSlot.FEET));
        public static final ArmorModel MONK = PIECE_REGISTRY.registerAll(((ArmorModel)new ArmorModel(VaultMod.id("gear/armor/monk"), "Monk").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll())).usingLayers(new MonkArmorLayers()).addSlot(EquipmentSlot.HEAD).addSlot(EquipmentSlot.CHEST).addSlot(EquipmentSlot.LEGS).addSlot(EquipmentSlot.FEET));
        public static final ArmorModel PALADIN = PIECE_REGISTRY.registerAll(((ArmorModel)new ArmorModel(VaultMod.id("gear/armor/paladin"), "Paladin").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll())).usingLayers(new PaladinArmorLayers()).addSlot(EquipmentSlot.HEAD).addSlot(EquipmentSlot.CHEST).addSlot(EquipmentSlot.LEGS).addSlot(EquipmentSlot.FEET));
        public static final ArmorModel PLATEMAIL = PIECE_REGISTRY.registerAll(((ArmorModel)new ArmorModel(VaultMod.id("gear/armor/platemail"), "Platemail").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll())).usingLayers(new PlatemailArmorLayers()).addSlot(EquipmentSlot.HEAD).addSlot(EquipmentSlot.CHEST).addSlot(EquipmentSlot.LEGS).addSlot(EquipmentSlot.FEET));
        public static final ArmorModel PLATEMAIL_DARK = PIECE_REGISTRY.registerAll(((ArmorModel)new ArmorModel(VaultMod.id("gear/armor/platemail_dark"), "Dark Platemail").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll())).usingLayers(new PlatemailArmorLayers()).addSlot(EquipmentSlot.HEAD).addSlot(EquipmentSlot.CHEST).addSlot(EquipmentSlot.LEGS).addSlot(EquipmentSlot.FEET));
        public static final ArmorModel REINFORCED_PLATEMAIL = PIECE_REGISTRY.registerAll(((ArmorModel)new ArmorModel(VaultMod.id("gear/armor/reinforced_platemail"), "Reinforced Platemail").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll())).usingLayers(new ReinforcedPlatemailArmorLayers()).addSlot(EquipmentSlot.HEAD).addSlot(EquipmentSlot.CHEST).addSlot(EquipmentSlot.LEGS).addSlot(EquipmentSlot.FEET));
        public static final ArmorModel REINFORCED_PLATEMAIL_DARK = PIECE_REGISTRY.registerAll(((ArmorModel)new ArmorModel(VaultMod.id("gear/armor/reinforced_platemail_dark"), "Dark Reinforced Platemail").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll())).usingLayers(new ReinforcedPlatemailArmorLayers()).addSlot(EquipmentSlot.HEAD).addSlot(EquipmentSlot.CHEST).addSlot(EquipmentSlot.LEGS).addSlot(EquipmentSlot.FEET));
        public static final ArmorModel RHINO = PIECE_REGISTRY.registerAll(((ArmorModel)new ArmorModel(VaultMod.id("gear/armor/rhino"), "Rhino").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll())).usingLayers(new RhinoArmorLayers()).addSlot(EquipmentSlot.HEAD).addSlot(EquipmentSlot.CHEST).addSlot(EquipmentSlot.LEGS).addSlot(EquipmentSlot.FEET));
        public static final ArmorModel RHINO_DARK = PIECE_REGISTRY.registerAll(((ArmorModel)new ArmorModel(VaultMod.id("gear/armor/rhino_dark"), "Dark Rhino").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll())).usingLayers(new RhinoArmorLayers()).addSlot(EquipmentSlot.HEAD).addSlot(EquipmentSlot.CHEST).addSlot(EquipmentSlot.LEGS).addSlot(EquipmentSlot.FEET));
        public static final ArmorModel ROGUE = PIECE_REGISTRY.registerAll(((ArmorModel)new ArmorModel(VaultMod.id("gear/armor/rogue"), "Rogue").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll())).usingLayers(new RogueArmorLayers()).addSlot(EquipmentSlot.HEAD).addSlot(EquipmentSlot.CHEST).addSlot(EquipmentSlot.LEGS).addSlot(EquipmentSlot.FEET));
        public static final ArmorModel ROYAL_GOLDEN = PIECE_REGISTRY.registerAll(((ArmorModel)new ArmorModel(VaultMod.id("gear/armor/royal_golden"), "Golden Royal").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll())).usingLayers(new RoyalArmorLayers()).addSlot(EquipmentSlot.HEAD).addSlot(EquipmentSlot.CHEST).addSlot(EquipmentSlot.LEGS).addSlot(EquipmentSlot.FEET));
        public static final ArmorModel ROYAL_SILVER = PIECE_REGISTRY.registerAll(((ArmorModel)new ArmorModel(VaultMod.id("gear/armor/royal_silver"), "Silver Royal").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll())).usingLayers(new RoyalArmorLayers()).addSlot(EquipmentSlot.HEAD).addSlot(EquipmentSlot.CHEST).addSlot(EquipmentSlot.LEGS).addSlot(EquipmentSlot.FEET));
        public static final ArmorModel LIONGUARD = PIECE_REGISTRY.registerAll(((ArmorModel)new ArmorModel(VaultMod.id("gear/armor/lionguard"), "Lionguard").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll())).usingLayers(new LionguardArmorLayers()).addSlot(EquipmentSlot.HEAD).addSlot(EquipmentSlot.CHEST).addSlot(EquipmentSlot.LEGS).addSlot(EquipmentSlot.FEET));
        public static final ArmorModel RUSTY_KNIGHT = PIECE_REGISTRY.registerAll(((ArmorModel)new ArmorModel(VaultMod.id("gear/armor/rusty_knight"), "Rusty Knight").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll())).usingLayers(new RustyKnightArmorLayers()).addSlot(EquipmentSlot.HEAD).addSlot(EquipmentSlot.CHEST).addSlot(EquipmentSlot.LEGS).addSlot(EquipmentSlot.FEET));
        public static final ArmorModel RUSTY_RAIDER = PIECE_REGISTRY.registerAll(((ArmorModel)new ArmorModel(VaultMod.id("gear/armor/rusty_raider"), "Rusty Raider").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll())).usingLayers(new RustyRaiderArmorLayers()).addSlot(EquipmentSlot.HEAD).addSlot(EquipmentSlot.CHEST).addSlot(EquipmentSlot.LEGS).addSlot(EquipmentSlot.FEET));
        public static final ArmorModel RUSTY_SCAVENGER = PIECE_REGISTRY.registerAll(((ArmorModel)new ArmorModel(VaultMod.id("gear/armor/rusty_scavenger"), "Rusty Scavenger").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll())).usingLayers(new RustyScavengerArmorLayers()).addSlot(EquipmentSlot.HEAD).addSlot(EquipmentSlot.CHEST).addSlot(EquipmentSlot.LEGS).addSlot(EquipmentSlot.FEET));
        public static final ArmorModel SAMURAI = PIECE_REGISTRY.registerAll(((ArmorModel)new ArmorModel(VaultMod.id("gear/armor/samurai"), "Samurai").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll())).usingLayers(new SamuraiArmorLayers()).addSlot(EquipmentSlot.HEAD).addSlot(EquipmentSlot.CHEST).addSlot(EquipmentSlot.LEGS).addSlot(EquipmentSlot.FEET));
        public static final ArmorModel FLAMINGO = PIECE_REGISTRY.registerAll(((ArmorModel)new ArmorModel(VaultMod.id("gear/armor/flamingo"), "Flamingo").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll())).usingLayers(new FlamingoArmorLayers()).addSlot(EquipmentSlot.HEAD).addSlot(EquipmentSlot.CHEST).addSlot(EquipmentSlot.LEGS).addSlot(EquipmentSlot.FEET));
        public static final ArmorModel SHADOW_KING = PIECE_REGISTRY.registerAll(((ArmorModel)new ArmorModel(VaultMod.id("gear/armor/shadow_king"), "Shadow King").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll())).usingLayers(new ShadowKingArmorLayers()).addSlot(EquipmentSlot.HEAD).addSlot(EquipmentSlot.CHEST).addSlot(EquipmentSlot.LEGS).addSlot(EquipmentSlot.FEET));
        public static final ArmorModel SPIKY_PLATEMAIL = PIECE_REGISTRY.registerAll(((ArmorModel)new ArmorModel(VaultMod.id("gear/armor/spiky_platemail"), "Spiky Platemail").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll())).usingLayers(new SpikyPlatemailArmorLayers()).addSlot(EquipmentSlot.HEAD).addSlot(EquipmentSlot.CHEST).addSlot(EquipmentSlot.LEGS).addSlot(EquipmentSlot.FEET));
        public static final ArmorModel SPIKY_PLATEMAIL_DARK = PIECE_REGISTRY.registerAll(((ArmorModel)new ArmorModel(VaultMod.id("gear/armor/spiky_platemail_dark"), "Dark Spiky Platemail").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll())).usingLayers(new SpikyPlatemailArmorLayers()).addSlot(EquipmentSlot.HEAD).addSlot(EquipmentSlot.CHEST).addSlot(EquipmentSlot.LEGS).addSlot(EquipmentSlot.FEET));
        public static final ArmorModel SQUIRE = PIECE_REGISTRY.registerAll(((ArmorModel)new ArmorModel(VaultMod.id("gear/armor/squire"), "Squire").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll())).usingLayers(new SquireArmorLayers()).addSlot(EquipmentSlot.HEAD).addSlot(EquipmentSlot.CHEST).addSlot(EquipmentSlot.LEGS).addSlot(EquipmentSlot.FEET));
        public static final ArmorModel WARRIOR = PIECE_REGISTRY.registerAll(((ArmorModel)new ArmorModel(VaultMod.id("gear/armor/warrior"), "Warrior").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll())).usingLayers(new WarriorArmorLayers()).addSlot(EquipmentSlot.HEAD).addSlot(EquipmentSlot.CHEST).addSlot(EquipmentSlot.LEGS).addSlot(EquipmentSlot.FEET));
        public static final ArmorModel WIZARD = PIECE_REGISTRY.registerAll(((ArmorModel)new ArmorModel(VaultMod.id("gear/armor/wizard"), "Wizard").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll())).usingLayers(new WizardArmorLayers()).addSlot(EquipmentSlot.HEAD).addSlot(EquipmentSlot.CHEST).addSlot(EquipmentSlot.LEGS).addSlot(EquipmentSlot.FEET));
        public static final ArmorModel ATOMATIC = PIECE_REGISTRY.registerAll(((ArmorModel)new ArmorModel(VaultMod.id("gear/armor/atomatic"), "Atomatic").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll())).usingLayers(new AtomaticArmorLayers()).addSlot(EquipmentSlot.HEAD).addSlot(EquipmentSlot.CHEST).addSlot(EquipmentSlot.LEGS).addSlot(EquipmentSlot.FEET));
        public static final ArmorModel BOTANIA = PIECE_REGISTRY.registerAll(((ArmorModel)new ArmorModel(VaultMod.id("gear/armor/botania"), "Botania").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll())).usingLayers(new BotaniaArmorLayers()).addSlot(EquipmentSlot.HEAD).addSlot(EquipmentSlot.CHEST).addSlot(EquipmentSlot.LEGS).addSlot(EquipmentSlot.FEET));
        public static final ArmorModel BUILDER = PIECE_REGISTRY.registerAll(((ArmorModel)new ArmorModel(VaultMod.id("gear/armor/builder"), "Builder").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll())).usingLayers(new BuilderArmorLayers()).addSlot(EquipmentSlot.HEAD).addSlot(EquipmentSlot.CHEST).addSlot(EquipmentSlot.LEGS).addSlot(EquipmentSlot.FEET));
        public static final ArmorModel CAKE = PIECE_REGISTRY.registerAll(((ArmorModel)new ArmorModel(VaultMod.id("gear/armor/cake"), "Cake").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll())).usingLayers(new CakeArmorLayers()).addSlot(EquipmentSlot.HEAD).addSlot(EquipmentSlot.CHEST).addSlot(EquipmentSlot.LEGS).addSlot(EquipmentSlot.FEET));
        public static final ArmorModel CREATE = PIECE_REGISTRY.registerAll(((ArmorModel)new ArmorModel(VaultMod.id("gear/armor/create"), "Create").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll())).usingLayers(new CreateArmorLayers()).addSlot(EquipmentSlot.HEAD).addSlot(EquipmentSlot.CHEST).addSlot(EquipmentSlot.LEGS).addSlot(EquipmentSlot.FEET));
        public static final ArmorModel DANK = PIECE_REGISTRY.registerAll(((ArmorModel)new ArmorModel(VaultMod.id("gear/armor/dank"), "Dank").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll())).usingLayers(new DankArmorLayers()).addSlot(EquipmentSlot.HEAD).addSlot(EquipmentSlot.CHEST).addSlot(EquipmentSlot.LEGS).addSlot(EquipmentSlot.FEET));
        public static final ArmorModel FAIRY = PIECE_REGISTRY.registerAll(((ArmorModel)new ArmorModel(VaultMod.id("gear/armor/fairy"), "Fairy").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll())).usingLayers(new FairyArmorLayers()).addSlot(EquipmentSlot.HEAD).addSlot(EquipmentSlot.CHEST).addSlot(EquipmentSlot.LEGS).addSlot(EquipmentSlot.FEET));
        public static final ArmorModel FLUX = PIECE_REGISTRY.registerAll(((ArmorModel)new ArmorModel(VaultMod.id("gear/armor/flux"), "Flux").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll())).usingLayers(new FluxArmorLayers()).addSlot(EquipmentSlot.HEAD).addSlot(EquipmentSlot.CHEST).addSlot(EquipmentSlot.LEGS).addSlot(EquipmentSlot.FEET));
        public static final ArmorModel HELL_COW = PIECE_REGISTRY.registerAll(((ArmorModel)new ArmorModel(VaultMod.id("gear/armor/hell_cow"), "Hell Cow").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll())).usingLayers(new HellCowArmorLayers()).addSlot(EquipmentSlot.HEAD).addSlot(EquipmentSlot.CHEST).addSlot(EquipmentSlot.LEGS).addSlot(EquipmentSlot.FEET));
        public static final ArmorModel ROBOTIC = PIECE_REGISTRY.registerAll(((ArmorModel)new ArmorModel(VaultMod.id("gear/armor/robotic"), "Robotic").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll())).usingLayers(new RoboticArmorLayers()).addSlot(EquipmentSlot.HEAD).addSlot(EquipmentSlot.CHEST).addSlot(EquipmentSlot.LEGS).addSlot(EquipmentSlot.FEET));
        public static final ArmorModel ARCADE = PIECE_REGISTRY.registerAll(((ArmorModel)new ArmorModel(VaultMod.id("gear/armor/arcade"), "Arcade").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll())).usingLayers(new ArcadeArmorLayers()).addSlot(EquipmentSlot.HEAD).addSlot(EquipmentSlot.CHEST).addSlot(EquipmentSlot.LEGS).addSlot(EquipmentSlot.FEET));
        public static final ArmorModel JARDOON_CHEESE = PIECE_REGISTRY.registerAll(((ArmorModel)new ArmorModel(VaultMod.id("gear/armor/jardoon_cheese"), "Jardoon Cheeserson").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll())).usingLayers(new JardoonCheeseArmorLayers()).addSlot(EquipmentSlot.HEAD, "Jardoon Cheeserson"));
        public static final ArmorModel MEKA_LIGHT = PIECE_REGISTRY.registerAll(((ArmorModel)new ArmorModel(VaultMod.id("gear/armor/meka_light"), "Light Meka").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll())).usingLayers(new MekaArmorLayers()).addSlot(EquipmentSlot.HEAD).addSlot(EquipmentSlot.CHEST).addSlot(EquipmentSlot.LEGS).addSlot(EquipmentSlot.FEET));
        public static final ArmorModel MEKA_DARK = PIECE_REGISTRY.registerAll(((ArmorModel)new ArmorModel(VaultMod.id("gear/armor/meka_dark"), "Dark Meka").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll())).usingLayers(new MekaArmorLayers()).addSlot(EquipmentSlot.HEAD).addSlot(EquipmentSlot.CHEST).addSlot(EquipmentSlot.LEGS).addSlot(EquipmentSlot.FEET));
        public static final ArmorModel POWAH = PIECE_REGISTRY.registerAll(((ArmorModel)new ArmorModel(VaultMod.id("gear/armor/powah"), "Powah").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll())).usingLayers(new PowahArmorLayers()).addSlot(EquipmentSlot.HEAD).addSlot(EquipmentSlot.CHEST).addSlot(EquipmentSlot.LEGS).addSlot(EquipmentSlot.FEET));
        public static final ArmorModel SKALLIBOMBA = PIECE_REGISTRY.registerAll(((ArmorModel)new ArmorModel(VaultMod.id("gear/armor/skallibomba"), "Skallibomba").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll())).usingLayers(new SkallibombaArmorLayers()).addSlot(EquipmentSlot.HEAD).addSlot(EquipmentSlot.CHEST).addSlot(EquipmentSlot.LEGS).addSlot(EquipmentSlot.FEET));
        public static final ArmorModel STRESS_FLOWER = PIECE_REGISTRY.registerAll(((ArmorModel)new ArmorModel(VaultMod.id("gear/armor/stress_flower"), "Stress Flower").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll())).usingLayers(new StressFlowerArmorLayers()).addSlot(EquipmentSlot.HEAD));
        public static final ArmorModel SCARECROW = PIECE_REGISTRY.registerAll(((ArmorModel)new ArmorModel(VaultMod.id("gear/armor/scarecrow"), "Scarecrow").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll())).usingLayers(new ScarecrowArmorLayers()).addSlot(EquipmentSlot.HEAD).addSlot(EquipmentSlot.CHEST).addSlot(EquipmentSlot.LEGS).addSlot(EquipmentSlot.FEET));
        public static final ArmorModel THERMAL = PIECE_REGISTRY.registerAll(((ArmorModel)new ArmorModel(VaultMod.id("gear/armor/thermal"), "Thermal").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll())).usingLayers(new ThermalArmorLayers()).addSlot(EquipmentSlot.HEAD).addSlot(EquipmentSlot.CHEST).addSlot(EquipmentSlot.LEGS).addSlot(EquipmentSlot.FEET));
        public static final ArmorModel TRASH = PIECE_REGISTRY.registerAll(((ArmorModel)new ArmorModel(VaultMod.id("gear/armor/trash"), "Trash").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll())).usingLayers(new TrashArmorLayers()).addSlot(EquipmentSlot.HEAD).addSlot(EquipmentSlot.CHEST).addSlot(EquipmentSlot.LEGS).addSlot(EquipmentSlot.FEET));
        public static final ArmorModel VILLAGER = PIECE_REGISTRY.registerAll(((ArmorModel)new ArmorModel(VaultMod.id("gear/armor/villager"), "Villager").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll())).usingLayers(new VillagerArmorLayers()).addSlot(EquipmentSlot.HEAD).addSlot(EquipmentSlot.CHEST).addSlot(EquipmentSlot.LEGS).addSlot(EquipmentSlot.FEET));
        public static final ArmorModel XNET = PIECE_REGISTRY.registerAll(((ArmorModel)new ArmorModel(VaultMod.id("gear/armor/xnet"), "Xnet").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll())).usingLayers(new XnetArmorLayers()).addSlot(EquipmentSlot.HEAD).addSlot(EquipmentSlot.CHEST).addSlot(EquipmentSlot.LEGS).addSlot(EquipmentSlot.FEET));
        public static final ArmorModel ZOMBIE = PIECE_REGISTRY.registerAll(((ArmorModel)new ArmorModel(VaultMod.id("gear/armor/zombie"), "Zombie").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll())).usingLayers(new ZombieArmorLayers()).addSlot(EquipmentSlot.HEAD).addSlot(EquipmentSlot.CHEST).addSlot(EquipmentSlot.LEGS).addSlot(EquipmentSlot.FEET));
        public static final ArmorModel ISKALL_IBE = PIECE_REGISTRY.registerAll(((ArmorModel)new ArmorModel(VaultMod.id("gear/armor/iskall_ibe"), "IBE").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll())).usingLayers(new IskallIbeArmorLayers()).addSlot(EquipmentSlot.HEAD, "Iskall Bionic Eye"));
        public static final ArmorModel DRUID = PIECE_REGISTRY.registerAll(((ArmorModel)new ArmorModel(VaultMod.id("gear/armor/druid"), "Druid").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll())).usingLayers(new DruidArmorLayers()).addSlot(EquipmentSlot.HEAD).addSlot(EquipmentSlot.CHEST).addSlot(EquipmentSlot.LEGS).addSlot(EquipmentSlot.FEET));
        public static final ArmorModel ORC = PIECE_REGISTRY.registerAll(((ArmorModel)new ArmorModel(VaultMod.id("gear/armor/orc"), "Orc").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll())).usingLayers(new OrcArmorLayers()).addSlot(EquipmentSlot.HEAD).addSlot(EquipmentSlot.CHEST).addSlot(EquipmentSlot.LEGS).addSlot(EquipmentSlot.FEET));
        public static final ArmorModel WITCH = PIECE_REGISTRY.registerAll(((ArmorModel)new ArmorModel(VaultMod.id("gear/armor/witch"), "Witch").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll())).usingLayers(new WitchArmorLayers()).addSlot(EquipmentSlot.HEAD).addSlot(EquipmentSlot.CHEST).addSlot(EquipmentSlot.LEGS).addSlot(EquipmentSlot.FEET));
        public static final ArmorModel MAGMATIC = PIECE_REGISTRY.registerAll(((ArmorModel)new ArmorModel(VaultMod.id("gear/armor/magmatic"), "Magmatic").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll())).usingLayers(new MagmaticArmorLayers()).addSlot(EquipmentSlot.HEAD).addSlot(EquipmentSlot.CHEST).addSlot(EquipmentSlot.LEGS).addSlot(EquipmentSlot.FEET));
        public static final ArmorModel BUMBO = PIECE_REGISTRY.registerAll(((ArmorModel)new ArmorModel(VaultMod.id("gear/armor/bumbo"), "Bumbo Cactoni").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll())).usingLayers(new BumboCactoniArmorLayers()).addSlot(EquipmentSlot.HEAD).addSlot(EquipmentSlot.CHEST).addSlot(EquipmentSlot.LEGS).addSlot(EquipmentSlot.FEET));
        public static final ArmorModel WITHER = PIECE_REGISTRY.registerAll(((ArmorModel)new ArmorModel(VaultMod.id("gear/armor/wither"), "Wither").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll())).usingLayers(new WitherArmorLayers()).addSlot(EquipmentSlot.HEAD).addSlot(EquipmentSlot.CHEST).addSlot(EquipmentSlot.LEGS).addSlot(EquipmentSlot.FEET));
        public static final ArmorModel SOUL_EATER = PIECE_REGISTRY.registerAll(((ArmorModel)new ArmorModel(VaultMod.id("gear/armor/soul_eater"), "Soul Eater").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll())).usingLayers(new SoulEaterArmorLayers()).addSlot(EquipmentSlot.HEAD).addSlot(EquipmentSlot.CHEST).addSlot(EquipmentSlot.LEGS).addSlot(EquipmentSlot.FEET));
    }

    public static class Swords {
        public static final DynamicModelRegistry<HandHeldModel> REGISTRY = new DynamicModelRegistry();
        public static final HandHeldModel SWORD_0 = REGISTRY.register((HandHeldModel)new HandHeldModel(VaultMod.id("gear/sword/sword_0"), "Sword_0").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll()));
        public static final HandHeldModel SWORD_1 = REGISTRY.register((HandHeldModel)new HandHeldModel(VaultMod.id("gear/sword/sword_1"), "Sword_1").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll()));
        public static final HandHeldModel SWORD_2 = REGISTRY.register((HandHeldModel)new HandHeldModel(VaultMod.id("gear/sword/sword_2"), "Sword_2").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll()));
        public static final HandHeldModel SWORD_3 = REGISTRY.register((HandHeldModel)new HandHeldModel(VaultMod.id("gear/sword/sword_3"), "Sword_3").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll()));
        public static final HandHeldModel SWORD_4 = REGISTRY.register((HandHeldModel)new HandHeldModel(VaultMod.id("gear/sword/sword_4"), "Sword_4").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll()));
        public static final HandHeldModel SWORD_5 = REGISTRY.register((HandHeldModel)new HandHeldModel(VaultMod.id("gear/sword/sword_5"), "Sword_5").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll()));
        public static final HandHeldModel SWORD_6 = REGISTRY.register((HandHeldModel)new HandHeldModel(VaultMod.id("gear/sword/sword_6"), "Sword_6").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll()));
        public static final HandHeldModel SWORD_7 = REGISTRY.register((HandHeldModel)new HandHeldModel(VaultMod.id("gear/sword/sword_7"), "Sword_7").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll()));
        public static final HandHeldModel ALLIUMBLADE = REGISTRY.register((HandHeldModel)new HandHeldModel(VaultMod.id("gear/sword/alliumblade"), "Alliumblade").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll()));
        public static final HandHeldModel BASEBALL_BAT = REGISTRY.register((HandHeldModel)new HandHeldModel(VaultMod.id("gear/sword/baseball_bat"), "Baseball Bat").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll()));
        public static final HandHeldModel CHAINSWORD = REGISTRY.register((HandHeldModel)new HandHeldModel(VaultMod.id("gear/sword/chainsword"), "Chainsword").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll()));
        public static final HandHeldModel DARK_BLADE = REGISTRY.register((HandHeldModel)new HandHeldModel(VaultMod.id("gear/sword/dark_blade"), "Dark Blade").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll()));
        public static final HandHeldModel SOUL_SWORD = REGISTRY.register((HandHeldModel)new HandHeldModel(VaultMod.id("gear/sword/soul_sword"), "Soul Sword").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll()));
        public static final HandHeldModel SOUL_SWORD_GREEN = REGISTRY.register((HandHeldModel)new HandHeldModel(VaultMod.id("gear/sword/soul_sword_green"), "Soul Sword (Green)").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll()));
        public static final HandHeldModel SOUL_SWORD_BLUE = REGISTRY.register((HandHeldModel)new HandHeldModel(VaultMod.id("gear/sword/soul_sword_blue"), "Soul Sword (Blue)").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll()));
        public static final HandHeldModel RED_KATANA = REGISTRY.register((HandHeldModel)new HandHeldModel(VaultMod.id("gear/sword/red_katana"), "Red Katana").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll()));
        public static final HandHeldModel NIGHTFALL = REGISTRY.register((HandHeldModel)new HandHeldModel(VaultMod.id("gear/sword/nightfall"), "Nightfall").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll()));
        public static final HandHeldModel DEATHS_DOOR = REGISTRY.register((HandHeldModel)new HandHeldModel(VaultMod.id("gear/sword/deaths_door"), "Death's Door").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll()));
    }

    public static class Axes {
        public static final DynamicModelRegistry<HandHeldModel> REGISTRY = new DynamicModelRegistry();
        public static final HandHeldModel AXE_0 = REGISTRY.register((HandHeldModel)new HandHeldModel(VaultMod.id("gear/axe/axe_0"), "Axe_0").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll()));
        public static final HandHeldModel AXE_1 = REGISTRY.register((HandHeldModel)new HandHeldModel(VaultMod.id("gear/axe/axe_1"), "Axe_1").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll()));
        public static final HandHeldModel AXE_2 = REGISTRY.register((HandHeldModel)new HandHeldModel(VaultMod.id("gear/axe/axe_2"), "Axe_2").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll()));
        public static final HandHeldModel AXE_3 = REGISTRY.register((HandHeldModel)new HandHeldModel(VaultMod.id("gear/axe/axe_3"), "Axe_3").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll()));
        public static final HandHeldModel AXE_4 = REGISTRY.register((HandHeldModel)new HandHeldModel(VaultMod.id("gear/axe/axe_4"), "Axe_4").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll()));
        public static final HandHeldModel AXE_5 = REGISTRY.register((HandHeldModel)new HandHeldModel(VaultMod.id("gear/axe/axe_5"), "Axe_5").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll()));
        public static final HandHeldModel AXE_6 = REGISTRY.register((HandHeldModel)new HandHeldModel(VaultMod.id("gear/axe/axe_6"), "Axe_6").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll()));
        public static final HandHeldModel AXE_7 = REGISTRY.register((HandHeldModel)new HandHeldModel(VaultMod.id("gear/axe/axe_7"), "Axe_7").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll()));
        public static final HandHeldModel AXE_8 = REGISTRY.register((HandHeldModel)new HandHeldModel(VaultMod.id("gear/axe/axe_8"), "Axe_8").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll()));
        public static final HandHeldModel AXE_9 = REGISTRY.register((HandHeldModel)new HandHeldModel(VaultMod.id("gear/axe/axe_9"), "Axe_9").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll()));
        public static final HandHeldModel AXE_10 = REGISTRY.register((HandHeldModel)new HandHeldModel(VaultMod.id("gear/axe/axe_10"), "Axe_10").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll()));
        public static final HandHeldModel AXE_11 = REGISTRY.register((HandHeldModel)new HandHeldModel(VaultMod.id("gear/axe/axe_11"), "Axe_11").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll()));
        public static final HandHeldModel AXE_12 = REGISTRY.register((HandHeldModel)new HandHeldModel(VaultMod.id("gear/axe/axe_12"), "Axe_12").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll()));
        public static final HandHeldModel AXE_13 = REGISTRY.register((HandHeldModel)new HandHeldModel(VaultMod.id("gear/axe/axe_13"), "Axe_13").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll()));
        public static final HandHeldModel JANITORS_BROOM = REGISTRY.register((HandHeldModel)new HandHeldModel(VaultMod.id("gear/axe/janitors_broom"), "Janitor's Broomstick").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll()));
        public static final HandHeldModel BIG_CHOPPA = REGISTRY.register((HandHeldModel)new HandHeldModel(VaultMod.id("gear/axe/big_choppa"), "Big Choppa").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll()));
        public static final HandHeldModel EVIL_MACE = REGISTRY.register((HandHeldModel)new HandHeldModel(VaultMod.id("gear/axe/evil_mace"), "Evil Mace").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll()));
        public static final HandHeldModel GREATHAMMER = REGISTRY.register((HandHeldModel)new HandHeldModel(VaultMod.id("gear/axe/greathammer"), "Greathammer").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll()));
        public static final HandHeldModel TINY_HAMMER = REGISTRY.register((HandHeldModel)new HandHeldModel(VaultMod.id("gear/axe/tiny_hammer"), "Tiny Hammer").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll()));
        public static final HandHeldModel BLOOD_CHOPPER = REGISTRY.register((HandHeldModel)new HandHeldModel(VaultMod.id("gear/axe/blood_chopper"), "Blood Chopper").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll()));
        public static final HandHeldModel BLOOD_CLEAVER = REGISTRY.register((HandHeldModel)new HandHeldModel(VaultMod.id("gear/axe/blood_cleaver"), "Blood Cleaver").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll()));
    }

    public static class Idols {
        public static final DynamicModelRegistry<PlainItemModel> REGISTRY_WENDARR = new DynamicModelRegistry();
        public static final DynamicModelRegistry<PlainItemModel> REGISTRY_IDONA = new DynamicModelRegistry();
        public static final DynamicModelRegistry<PlainItemModel> REGISTRY_VELARA = new DynamicModelRegistry();
        public static final DynamicModelRegistry<PlainItemModel> REGISTRY_TENOS = new DynamicModelRegistry();
        public static final PlainItemModel WENDARR = REGISTRY_WENDARR.register((PlainItemModel)new PlainItemModel(VaultMod.id("gear/idol/wendarr"), "Wendarr's Idol").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll()));
        public static final PlainItemModel IDONA = REGISTRY_IDONA.register((PlainItemModel)new PlainItemModel(VaultMod.id("gear/idol/idona"), "Idona's Idol").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll()));
        public static final PlainItemModel VELARA = REGISTRY_VELARA.register((PlainItemModel)new PlainItemModel(VaultMod.id("gear/idol/velara"), "Velara's Idol").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll()));
        public static final PlainItemModel TENOS = REGISTRY_TENOS.register((PlainItemModel)new PlainItemModel(VaultMod.id("gear/idol/tenos"), "Tenos' Idol").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll()));
    }

    public static class Shields {
        public static final DynamicModelRegistry<ShieldModel> REGISTRY = new DynamicModelRegistry();
        public static final ShieldModel VANILLA = REGISTRY.register((ShieldModel)new ShieldModel(VaultMod.id("gear/shield/vanilla"), "Good ol' Vanilla Shield").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll()));
        public static final ShieldModel WOODEN = REGISTRY.register((ShieldModel)new ShieldModel(VaultMod.id("gear/shield/wooden"), "Wooden Shield").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll()));
        public static final ShieldModel ENDER = REGISTRY.register((ShieldModel)new ShieldModel(VaultMod.id("gear/shield/ender"), "Ender Shield").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll()));
        public static final ShieldModel INFERNO = REGISTRY.register((ShieldModel)new ShieldModel(VaultMod.id("gear/shield/inferno"), "Inferno Shield").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll()));
        public static final ShieldModel COCONUT = REGISTRY.register((ShieldModel)new CoconutShieldModel(VaultMod.id("gear/shield/coconut"), VaultMod.id("gear/shield/coconut_orange"), "Coconut Shield").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll()));
        public static final ShieldModel BELL = REGISTRY.register((ShieldModel)new ShieldModel(VaultMod.id("gear/shield/bell"), "Bell Shield").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll()));
        public static final ShieldModel TURTLE = REGISTRY.register((ShieldModel)new ShieldModel(VaultMod.id("gear/shield/turtle"), "Turtle Shell").properties(new DynamicModelProperties().allowTransmogrification().discoverOnRoll()));
    }

    public static class Relics {
        public static final DynamicModelRegistry<PlainItemModel> RELIC_REGISTRY = new DynamicModelRegistry();
        public static final DynamicModelRegistry<PlainItemModel> FRAGMENT_REGISTRY = new DynamicModelRegistry();
        public static final PlainItemModel DRAGON_BREATH = FRAGMENT_REGISTRY.register(new PlainItemModel(VaultMod.id("relic/dragon/frag1"), "Dragon Breath"));
        public static final PlainItemModel DRAGON_CHEST = FRAGMENT_REGISTRY.register(new PlainItemModel(VaultMod.id("relic/dragon/frag2"), "Dragon Chest"));
        public static final PlainItemModel DRAGON_FOOT = FRAGMENT_REGISTRY.register(new PlainItemModel(VaultMod.id("relic/dragon/frag3"), "Dragon Foot"));
        public static final PlainItemModel DRAGON_HEAD = FRAGMENT_REGISTRY.register(new PlainItemModel(VaultMod.id("relic/dragon/frag4"), "Dragon Head"));
        public static final PlainItemModel DRAGON_TAIL = FRAGMENT_REGISTRY.register(new PlainItemModel(VaultMod.id("relic/dragon/frag5"), "Dragon Tail"));
        public static final PlainItemModel DRAGON_RELIC = RELIC_REGISTRY.register(new PlainItemModel(VaultMod.id("relic/dragon/statue"), "Dragon Relic"));
        public static final PlainItemModel MINERS_LIGHT = FRAGMENT_REGISTRY.register(new PlainItemModel(VaultMod.id("relic/miner/frag1"), "Miner's Light"));
        public static final PlainItemModel MINERS_DELIGHT = FRAGMENT_REGISTRY.register(new PlainItemModel(VaultMod.id("relic/miner/frag2"), "Miner's Delight"));
        public static final PlainItemModel PICKAXE_HANDLE = FRAGMENT_REGISTRY.register(new PlainItemModel(VaultMod.id("relic/miner/frag3"), "Pickaxe Handle"));
        public static final PlainItemModel PICKAXE_HEAD = FRAGMENT_REGISTRY.register(new PlainItemModel(VaultMod.id("relic/miner/frag4"), "Pickaxe Head"));
        public static final PlainItemModel PICKAXE_TOOL = FRAGMENT_REGISTRY.register(new PlainItemModel(VaultMod.id("relic/miner/frag5"), "Pickaxe Tool"));
        public static final PlainItemModel MINER_RELIC = RELIC_REGISTRY.register(new PlainItemModel(VaultMod.id("relic/miner/statue"), "Miner Relic"));
        public static final PlainItemModel WARRIORS_ARMOUR = FRAGMENT_REGISTRY.register(new PlainItemModel(VaultMod.id("relic/warrior/frag1"), "Warrior's Armour"));
        public static final PlainItemModel WARRIORS_CHARM = FRAGMENT_REGISTRY.register(new PlainItemModel(VaultMod.id("relic/warrior/frag2"), "Warrior's Charm"));
        public static final PlainItemModel SWORD_BLADE = FRAGMENT_REGISTRY.register(new PlainItemModel(VaultMod.id("relic/warrior/frag3"), "Pickaxe Handle"));
        public static final PlainItemModel SWORD_HANDLE = FRAGMENT_REGISTRY.register(new PlainItemModel(VaultMod.id("relic/warrior/frag4"), "Pickaxe Head"));
        public static final PlainItemModel SWORD_STICK = FRAGMENT_REGISTRY.register(new PlainItemModel(VaultMod.id("relic/warrior/frag5"), "Pickaxe Tool"));
        public static final PlainItemModel WARRIOR_RELIC = RELIC_REGISTRY.register(new PlainItemModel(VaultMod.id("relic/warrior/statue"), "Warrior Relic"));
        public static final PlainItemModel DIAMOND_ESSENCE = FRAGMENT_REGISTRY.register(new PlainItemModel(VaultMod.id("relic/richity/frag1"), "Diamond Essence"));
        public static final PlainItemModel GOLD_ESSENCE = FRAGMENT_REGISTRY.register(new PlainItemModel(VaultMod.id("relic/richity/frag2"), "Gold Essence"));
        public static final PlainItemModel MYSTIC_GEM_ESSENCE = FRAGMENT_REGISTRY.register(new PlainItemModel(VaultMod.id("relic/richity/frag3"), "Mystic Gem Essence"));
        public static final PlainItemModel NETHERITE_ESSENCE = FRAGMENT_REGISTRY.register(new PlainItemModel(VaultMod.id("relic/richity/frag4"), "Netherite Essence"));
        public static final PlainItemModel PLATINUM_ESSENCE = FRAGMENT_REGISTRY.register(new PlainItemModel(VaultMod.id("relic/richity/frag5"), "Platinum Essence"));
        public static final PlainItemModel RICHITY_RELIC = RELIC_REGISTRY.register(new PlainItemModel(VaultMod.id("relic/richity/statue"), "Richity Relic"));
        public static final PlainItemModel TWITCH_EMOTE_1 = FRAGMENT_REGISTRY.register(new PlainItemModel(VaultMod.id("relic/twitch/frag1"), "Twitch Emote #1"));
        public static final PlainItemModel TWITCH_EMOTE_2 = FRAGMENT_REGISTRY.register(new PlainItemModel(VaultMod.id("relic/twitch/frag2"), "Twitch Emote #2"));
        public static final PlainItemModel TWITCH_EMOTE_3 = FRAGMENT_REGISTRY.register(new PlainItemModel(VaultMod.id("relic/twitch/frag3"), "Twitch Emote #3"));
        public static final PlainItemModel TWITCH_EMOTE_4 = FRAGMENT_REGISTRY.register(new PlainItemModel(VaultMod.id("relic/twitch/frag4"), "Twitch Emote #4"));
        public static final PlainItemModel TWITCH_EMOTE_5 = FRAGMENT_REGISTRY.register(new PlainItemModel(VaultMod.id("relic/twitch/frag5"), "Twitch Emote #5"));
        public static final PlainItemModel TWITCH_RELIC = RELIC_REGISTRY.register(new PlainItemModel(VaultMod.id("relic/twitch/statue"), "Twitch Relic"));
        public static final PlainItemModel CUPCAKE_BLUE = FRAGMENT_REGISTRY.register(new PlainItemModel(VaultMod.id("relic/cupcake/frag1"), "Blue Cupcake"));
        public static final PlainItemModel CUPCAKE_LIME = FRAGMENT_REGISTRY.register(new PlainItemModel(VaultMod.id("relic/cupcake/frag2"), "Lime Cupcake"));
        public static final PlainItemModel CUPCAKE_PINK = FRAGMENT_REGISTRY.register(new PlainItemModel(VaultMod.id("relic/cupcake/frag3"), "Pink Cupcake"));
        public static final PlainItemModel CUPCAKE_PURPLE = FRAGMENT_REGISTRY.register(new PlainItemModel(VaultMod.id("relic/cupcake/frag4"), "Purple Cupcake"));
        public static final PlainItemModel CUPCAKE_RED = FRAGMENT_REGISTRY.register(new PlainItemModel(VaultMod.id("relic/cupcake/frag5"), "Red Cupcake"));
        public static final PlainItemModel CUPCAKE_RELIC = RELIC_REGISTRY.register(new PlainItemModel(VaultMod.id("relic/cupcake/statue"), "Cupcake Relic"));
        public static final PlainItemModel ELEMENT_AIR = FRAGMENT_REGISTRY.register(new PlainItemModel(VaultMod.id("relic/elemental/frag1"), "Air Element"));
        public static final PlainItemModel ELEMENT_EARTH = FRAGMENT_REGISTRY.register(new PlainItemModel(VaultMod.id("relic/elemental/frag2"), "Earth Element"));
        public static final PlainItemModel ELEMENT_FIRE = FRAGMENT_REGISTRY.register(new PlainItemModel(VaultMod.id("relic/elemental/frag3"), "Fire Element"));
        public static final PlainItemModel ELEMENT_WATER = FRAGMENT_REGISTRY.register(new PlainItemModel(VaultMod.id("relic/elemental/frag4"), "Water Element"));
        public static final PlainItemModel ELEMENT_SPIRIT = FRAGMENT_REGISTRY.register(new PlainItemModel(VaultMod.id("relic/elemental/frag5"), "Spirit Element"));
        public static final PlainItemModel ELEMENTAL_RELIC = RELIC_REGISTRY.register(new PlainItemModel(VaultMod.id("relic/elemental/statue"), "Elemental Relic"));
        public static final PlainItemModel SER = FRAGMENT_REGISTRY.register(new PlainItemModel(VaultMod.id("relic/nazar/frag1"), "\u015eer"));
        public static final PlainItemModel KEM_GOZ = FRAGMENT_REGISTRY.register(new PlainItemModel(VaultMod.id("relic/nazar/frag2"), "Kem G\u00f6z"));
        public static final PlainItemModel KADER = FRAGMENT_REGISTRY.register(new PlainItemModel(VaultMod.id("relic/nazar/frag3"), "Kader"));
        public static final PlainItemModel KISMET = FRAGMENT_REGISTRY.register(new PlainItemModel(VaultMod.id("relic/nazar/frag4"), "K\u0131smet"));
        public static final PlainItemModel NAZARLIK = FRAGMENT_REGISTRY.register(new PlainItemModel(VaultMod.id("relic/nazar/frag5"), "Nazarl\u0131k"));
        public static final PlainItemModel NAZAR_BONCUGU = RELIC_REGISTRY.register(new PlainItemModel(VaultMod.id("relic/nazar/statue"), "Nazar Boncu\u011fu"));
    }
}

