/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.init;

import iskallia.vault.skill.ability.component.AbilityLabelBindingRegistry;
import iskallia.vault.skill.ability.component.AbilityLabelFormatters;
import iskallia.vault.skill.ability.component.IAbilityLabelBinding;
import iskallia.vault.skill.ability.config.DashConfig;
import iskallia.vault.skill.ability.config.ExecuteConfig;
import iskallia.vault.skill.ability.config.FarmerConfig;
import iskallia.vault.skill.ability.config.GhostWalkConfig;
import iskallia.vault.skill.ability.config.HealConfig;
import iskallia.vault.skill.ability.config.HunterConfig;
import iskallia.vault.skill.ability.config.ManaShieldConfig;
import iskallia.vault.skill.ability.config.MegaJumpConfig;
import iskallia.vault.skill.ability.config.NovaConfig;
import iskallia.vault.skill.ability.config.RampageConfig;
import iskallia.vault.skill.ability.config.StonefallConfig;
import iskallia.vault.skill.ability.config.SummonEternalConfig;
import iskallia.vault.skill.ability.config.TankConfig;
import iskallia.vault.skill.ability.config.TauntConfig;
import iskallia.vault.skill.ability.config.VeinMinerConfig;
import iskallia.vault.skill.ability.config.spi.AbstractAbilityConfig;
import iskallia.vault.skill.ability.config.spi.IInstantManaConfig;
import iskallia.vault.skill.ability.config.spi.IPerSecondManaConfig;
import iskallia.vault.skill.ability.config.sub.DashDamageConfig;
import iskallia.vault.skill.ability.config.sub.FarmerAnimalConfig;
import iskallia.vault.skill.ability.config.sub.FarmerCactusConfig;
import iskallia.vault.skill.ability.config.sub.FarmerMelonConfig;
import iskallia.vault.skill.ability.config.sub.HealEffectConfig;
import iskallia.vault.skill.ability.config.sub.HealGroupConfig;
import iskallia.vault.skill.ability.config.sub.HunterObjectiveConfig;
import iskallia.vault.skill.ability.config.sub.MegaJumpBreakDownConfig;
import iskallia.vault.skill.ability.config.sub.MegaJumpBreakUpConfig;
import iskallia.vault.skill.ability.config.sub.NovaDotConfig;
import iskallia.vault.skill.ability.config.sub.NovaSpeedConfig;
import iskallia.vault.skill.ability.config.sub.RampageChainConfig;
import iskallia.vault.skill.ability.config.sub.RampageLeechConfig;
import iskallia.vault.skill.ability.config.sub.TankProjectileConfig;
import iskallia.vault.skill.ability.config.sub.TankReflectConfig;
import iskallia.vault.skill.ability.config.sub.TauntRepelConfig;
import iskallia.vault.skill.ability.config.sub.VeinMinerDurabilityConfig;
import iskallia.vault.skill.ability.config.sub.VeinMinerFortuneConfig;
import iskallia.vault.skill.ability.config.sub.VeinMinerVoidConfig;
import java.util.Collections;
import java.util.Map;

public class ModAbilityLabelBindings {
    public static void register() {
        AbilityLabelBindingRegistry.clear();
        ModAbilityLabelBindings.register(DashConfig.class, Map.of("distance", config -> AbilityLabelFormatters.integer(config.getExtraDistance())));
        ModAbilityLabelBindings.register(DashDamageConfig.class, Map.of("distance", config -> AbilityLabelFormatters.integer(config.getExtraDistance()), "damage", config -> AbilityLabelFormatters.percent(config.getAttackDamagePercentPerDash())));
        ModAbilityLabelBindings.register(ExecuteConfig.class, Map.of("damage", config -> AbilityLabelFormatters.percent(config.getDamageHealthPercentage()), "duration", config -> AbilityLabelFormatters.ticks(config.getEffectDurationTicks())));
        ModAbilityLabelBindings.register(FarmerConfig.class, Map.of("delay", config -> AbilityLabelFormatters.ticks(config.getTickDelay()), "rangeHorizontal", config -> AbilityLabelFormatters.integer(config.getHorizontalRange()), "rangeVertical", config -> AbilityLabelFormatters.integer(config.getVerticalRange())));
        ModAbilityLabelBindings.register(FarmerCactusConfig.class, Map.of("delay", config -> AbilityLabelFormatters.ticks(config.getTickDelay()), "rangeHorizontal", config -> AbilityLabelFormatters.integer(config.getHorizontalRange()), "rangeVertical", config -> AbilityLabelFormatters.integer(config.getVerticalRange())));
        ModAbilityLabelBindings.register(FarmerMelonConfig.class, Map.of("delay", config -> AbilityLabelFormatters.ticks(config.getTickDelay()), "rangeHorizontal", config -> AbilityLabelFormatters.integer(config.getHorizontalRange()), "rangeVertical", config -> AbilityLabelFormatters.integer(config.getVerticalRange())));
        ModAbilityLabelBindings.register(FarmerAnimalConfig.class, Map.of("delay", config -> AbilityLabelFormatters.ticks(config.getTickDelay()), "rangeHorizontal", config -> AbilityLabelFormatters.integer(config.getHorizontalRange()), "rangeVertical", config -> AbilityLabelFormatters.integer(config.getVerticalRange()), "chance", config -> AbilityLabelFormatters.percent(config.getAdultChance())));
        ModAbilityLabelBindings.register(GhostWalkConfig.class, Map.of("duration", config -> AbilityLabelFormatters.ticks(config.getDurationTicks())));
        ModAbilityLabelBindings.register(HealConfig.class, Map.of("heal", config -> AbilityLabelFormatters.decimal(config.getFlatLifeHealed())));
        ModAbilityLabelBindings.register(HealEffectConfig.class);
        ModAbilityLabelBindings.register(HealGroupConfig.class, Map.of("heal", config -> AbilityLabelFormatters.decimal(config.getFlatLifeHealed()), "radius", config -> AbilityLabelFormatters.decimal(config.getRadius())));
        ModAbilityLabelBindings.register(HunterConfig.class, Map.of("radius", config -> AbilityLabelFormatters.decimal(config.getSearchRadius()), "duration", config -> AbilityLabelFormatters.ticks(config.getDurationTicks())));
        ModAbilityLabelBindings.register(HunterObjectiveConfig.class, Map.of("radius", config -> AbilityLabelFormatters.decimal(config.getSearchRadius()), "duration", config -> AbilityLabelFormatters.ticks(config.getDurationTicks())));
        ModAbilityLabelBindings.register(ManaShieldConfig.class, Map.of("absorb", config -> AbilityLabelFormatters.percent(config.getPercentageDamageAbsorbed())));
        ModAbilityLabelBindings.register(MegaJumpConfig.class, Map.of("rangeVertical", config -> AbilityLabelFormatters.integer(config.getHeight())));
        ModAbilityLabelBindings.register(MegaJumpBreakUpConfig.class, Map.of("rangeVertical", config -> AbilityLabelFormatters.integer(config.getHeight())));
        ModAbilityLabelBindings.register(MegaJumpBreakDownConfig.class, Map.of("rangeVertical", config -> AbilityLabelFormatters.integer(config.getHeight())));
        ModAbilityLabelBindings.register(NovaConfig.class, Map.of("radius", config -> AbilityLabelFormatters.decimal(config.getRadius()), "damage", config -> AbilityLabelFormatters.percent(config.getPercentAttackDamageDealt()), "knockback", config -> AbilityLabelFormatters.percent(config.getKnockbackStrengthMultiplier())));
        ModAbilityLabelBindings.register(NovaDotConfig.class, Map.of("radius", config -> AbilityLabelFormatters.decimal(config.getRadius()), "damage", config -> AbilityLabelFormatters.percent(config.getPercentAttackDamageDealt()), "duration", config -> AbilityLabelFormatters.seconds(config.getDurationSeconds())));
        ModAbilityLabelBindings.register(NovaSpeedConfig.class, Map.of("radius", config -> AbilityLabelFormatters.decimal(config.getRadius()), "duration", config -> AbilityLabelFormatters.ticks(config.getDurationTicks()), "slowness", config -> AbilityLabelFormatters.integer(config.getAmplifier())));
        ModAbilityLabelBindings.register(RampageConfig.class, Map.of("damage", config -> AbilityLabelFormatters.percent(config.getDamageIncrease())));
        ModAbilityLabelBindings.register(RampageChainConfig.class, Map.of("chains", config -> AbilityLabelFormatters.integer(config.getAdditionalChainCount())));
        ModAbilityLabelBindings.register(RampageLeechConfig.class, Map.of("leech", config -> AbilityLabelFormatters.percent(config.getLeechPercent())));
        ModAbilityLabelBindings.register(SummonEternalConfig.class, Map.of("eternals", config -> AbilityLabelFormatters.integer(config.getNumberOfEternals()), "duration", config -> AbilityLabelFormatters.ticks(config.getDespawnTime()), "chance", config -> AbilityLabelFormatters.percent(config.getAncientChance())));
        ModAbilityLabelBindings.register(TankConfig.class, Map.of("duration", config -> AbilityLabelFormatters.ticks(config.getDurationTicksPerHit()), "resistance", config -> AbilityLabelFormatters.percent(config.getResistancePercentAddedPerHit())));
        ModAbilityLabelBindings.register(TankProjectileConfig.class, Map.of("resistance", config -> AbilityLabelFormatters.percent(config.getKnockbackResistance()), "projectileDamageTaken", config -> AbilityLabelFormatters.percent(config.getPercentageReducedProjectileDamage())));
        ModAbilityLabelBindings.register(TankReflectConfig.class, Map.of("chance", config -> AbilityLabelFormatters.percent(config.getAdditionalThornsChance()), "damage", config -> AbilityLabelFormatters.percent(config.getThornsDamageMultiplier())));
        ModAbilityLabelBindings.register(TauntConfig.class, Map.of("radius", config -> AbilityLabelFormatters.decimal(config.getRadius()), "duration", config -> AbilityLabelFormatters.ticks(config.getDurationTicks())));
        ModAbilityLabelBindings.register(TauntRepelConfig.class, Map.of("radius", config -> AbilityLabelFormatters.decimal(config.getRadius()), "duration", config -> AbilityLabelFormatters.ticks(config.getDurationTicks()), "distance", config -> AbilityLabelFormatters.decimal(config.getRepelForce())));
        ModAbilityLabelBindings.register(VeinMinerConfig.class, Map.of("blocks", config -> AbilityLabelFormatters.decimal(config.getBlockLimit())));
        ModAbilityLabelBindings.register(VeinMinerDurabilityConfig.class, Map.of("blocks", config -> AbilityLabelFormatters.decimal(config.getBlockLimit()), "unbreaking", config -> AbilityLabelFormatters.integer(config.getAdditionalUnbreakingLevel())));
        ModAbilityLabelBindings.register(VeinMinerFortuneConfig.class, Map.of("blocks", config -> AbilityLabelFormatters.decimal(config.getBlockLimit()), "fortune", config -> AbilityLabelFormatters.integer(config.getAdditionalFortuneLevel())));
        ModAbilityLabelBindings.register(VeinMinerVoidConfig.class, Map.of("blocks", config -> AbilityLabelFormatters.decimal(config.getBlockLimit())));
        ModAbilityLabelBindings.register(StonefallConfig.class, Map.of("duration", config -> AbilityLabelFormatters.ticks(config.getDurationTicks())));
    }

    public static <C extends AbstractAbilityConfig> void register(Class<C> configClass) {
        ModAbilityLabelBindings.register(configClass, Collections.emptyMap());
    }

    public static <C extends AbstractAbilityConfig> void register(Class<C> configClass, Map<String, IAbilityLabelBinding<C>> bindings) {
        if (AbilityLabelBindingRegistry.containsKey(configClass)) {
            throw new IllegalStateException("Ability label bindings already registered for config class " + configClass);
        }
        AbilityLabelBindingRegistry.register(configClass, "level", config -> String.valueOf(config.getLevelRequirement()));
        AbilityLabelBindingRegistry.register(configClass, "cooldown", config -> (float)config.getCooldownTicks() / 20.0f + "s");
        if (IInstantManaConfig.class.isAssignableFrom(configClass)) {
            AbilityLabelBindingRegistry.register(configClass, "manaCost", config -> String.valueOf(Math.round(((IInstantManaConfig)((Object)config)).getManaCost())));
        } else if (IPerSecondManaConfig.class.isAssignableFrom(configClass)) {
            AbilityLabelBindingRegistry.register(configClass, "manaCost", config -> String.valueOf(Math.round(((IPerSecondManaConfig)((Object)config)).getManaCostPerSecond())));
        }
        for (Map.Entry<String, IAbilityLabelBinding<C>> entry : bindings.entrySet()) {
            AbilityLabelBindingRegistry.register(configClass, entry.getKey(), entry.getValue());
        }
    }
}

