/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.trinket.effects;

import com.google.common.collect.Lists;
import com.google.gson.annotations.Expose;
import iskallia.vault.gear.attribute.VaultGearAttribute;
import iskallia.vault.gear.attribute.VaultGearAttributeInstance;
import iskallia.vault.gear.trinket.GearAttributeTrinket;
import iskallia.vault.gear.trinket.TrinketEffect;
import iskallia.vault.init.ModGearAttributes;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;

public class VanillaAttributeTrinket
extends TrinketEffect<Config>
implements GearAttributeTrinket {
    private final Attribute defaultAttribute;
    private final double value;
    private final AttributeModifier.Operation operation;

    public VanillaAttributeTrinket(ResourceLocation name, Attribute defaultAttribute, double value, AttributeModifier.Operation operation) {
        super(name);
        this.defaultAttribute = defaultAttribute;
        this.value = value;
        this.operation = operation;
    }

    @Override
    public Class<Config> getConfigClass() {
        return Config.class;
    }

    @Override
    public Config getDefaultConfig() {
        return new Config(this.defaultAttribute.getRegistryName().toString(), new Modifier(this.defaultAttribute.m_22087_(), this.value, this.operation));
    }

    @Override
    public void onWornTick(LivingEntity entity, ItemStack stack) {
        super.onWornTick(entity, stack);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.runIfPresent((LivingEntity)player, attributeData -> {
                if (this.isUsable(stack, player)) {
                    if (!attributeData.m_22109_(((Config)this.getConfig()).getModifier().toMCModifier())) {
                        this.addModifier(player);
                    }
                } else {
                    this.removeModifier(player);
                }
            });
        }
    }

    @Override
    public void onEquip(LivingEntity entity, ItemStack stack) {
        Player player;
        super.onEquip(entity, stack);
        if (entity instanceof Player && this.isUsable(stack, player = (Player)entity)) {
            this.runIfPresent((LivingEntity)player, attributeData -> {
                if (!attributeData.m_22109_(((Config)this.getConfig()).getModifier().toMCModifier())) {
                    this.addModifier(player);
                }
            });
        }
    }

    @Override
    public void onUnEquip(LivingEntity entity, ItemStack stack) {
        super.onUnEquip(entity, stack);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.removeModifier(player);
        }
    }

    private void removeModifier(Player player) {
        this.runIfPresent((LivingEntity)player, attributeData -> attributeData.m_22120_(UUID.fromString(((Config)this.getConfig()).getModifier().id)));
    }

    private void addModifier(Player player) {
        this.runIfPresent((LivingEntity)player, attributeData -> attributeData.m_22118_(((Config)this.getConfig()).getModifier().toMCModifier()));
    }

    public boolean runIfPresent(LivingEntity entity, Consumer<AttributeInstance> action) {
        AttributeInstance instance = entity.m_21051_(((Config)this.getConfig()).getAttribute());
        if (instance == null) {
            return false;
        }
        action.accept(instance);
        return true;
    }

    @Override
    public List<VaultGearAttributeInstance<?>> getAttributes() {
        Config cfg = (Config)this.getConfig();
        VaultGearAttribute<?> gearAttribute = ModGearAttributes.getGearAttribute(cfg.getAttribute(), cfg.getModifier().getOperation());
        if (gearAttribute == null) {
            return Collections.emptyList();
        }
        return Lists.newArrayList((Object[])new VaultGearAttributeInstance[]{VaultGearAttributeInstance.cast(gearAttribute, cfg.getModifier().amount)});
    }

    public static class Config
    extends TrinketEffect.Config {
        @Expose
        private final String attribute;
        @Expose
        private final Modifier modifier;

        public Config(String attribute, Modifier modifier) {
            this.attribute = attribute;
            this.modifier = modifier;
        }

        public Attribute getAttribute() {
            return (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation(this.attribute));
        }

        public Modifier getModifier() {
            return this.modifier;
        }
    }

    public static class Modifier {
        @Expose
        public final String id;
        @Expose
        public final String name;
        @Expose
        public final double amount;
        @Expose
        public final int operation;

        public Modifier(String name, double amount, AttributeModifier.Operation operation) {
            this.id = Mth.m_14062_((Random)new Random(name.hashCode())).toString();
            this.name = name;
            this.amount = amount;
            this.operation = operation.m_22235_();
        }

        public AttributeModifier.Operation getOperation() {
            return AttributeModifier.Operation.m_22236_((int)this.operation);
        }

        public AttributeModifier toMCModifier() {
            return new AttributeModifier(UUID.fromString(this.id), this.name, this.amount, this.getOperation());
        }
    }
}

