/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.trinket.effects;

import com.google.common.collect.Lists;
import com.google.gson.annotations.Expose;
import iskallia.vault.gear.attribute.VaultGearAttributeInstance;
import iskallia.vault.gear.attribute.custom.EffectGearAttribute;
import iskallia.vault.gear.trinket.GearAttributeTrinket;
import iskallia.vault.gear.trinket.TrinketEffect;
import iskallia.vault.init.ModGearAttributes;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraftforge.registries.ForgeRegistries;

public class PotionEffectTrinket
extends TrinketEffect<Config>
implements GearAttributeTrinket {
    private final MobEffect effect;
    private final int addedAmplifier;

    public PotionEffectTrinket(ResourceLocation name, MobEffect effect, int addedAmplifier) {
        super(name);
        this.effect = effect;
        this.addedAmplifier = addedAmplifier;
    }

    @Override
    public Class<Config> getConfigClass() {
        return Config.class;
    }

    @Override
    public Config getDefaultConfig() {
        return new Config(this.effect.getRegistryName(), this.addedAmplifier);
    }

    @Override
    public List<VaultGearAttributeInstance<?>> getAttributes() {
        Config cfg = (Config)this.getConfig();
        return Lists.newArrayList((Object[])new VaultGearAttributeInstance[]{new VaultGearAttributeInstance<EffectGearAttribute>(ModGearAttributes.EFFECT, new EffectGearAttribute(cfg.getEffect(), cfg.getAddedAmplifier()))});
    }

    public static class Config
    extends TrinketEffect.Config {
        @Expose
        private ResourceLocation effect;
        @Expose
        private int addedAmplifier;

        public Config(ResourceLocation effect, int addedAmplifier) {
            this.effect = effect;
            this.addedAmplifier = addedAmplifier;
        }

        public MobEffect getEffect() {
            return (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(this.effect);
        }

        public int getAddedAmplifier() {
            return this.addedAmplifier;
        }
    }
}

