/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.trinket;

import iskallia.vault.gear.trinket.TrinketEffect;
import iskallia.vault.integration.IntegrationCurios;
import iskallia.vault.item.gear.TrinketItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class TrinketHelper {
    public static List<TrinketStack<TrinketEffect<?>>> getTrinkets(LivingEntity entity) {
        return TrinketHelper.getTrinkets(IntegrationCurios.getCuriosItemStacks(entity), TrinketEffect.class);
    }

    public static <T extends TrinketEffect<?>> List<TrinketStack<T>> getTrinkets(LivingEntity entity, Class<T> trinketClass) {
        return TrinketHelper.getTrinkets(IntegrationCurios.getCuriosItemStacks(entity), trinketClass);
    }

    public static <T extends TrinketEffect<?>> List<TrinketStack<T>> getTrinkets(Map<String, List<ItemStack>> slotCurios, Class<? super T> trinketClass) {
        ArrayList trinkets = new ArrayList();
        slotCurios.values().forEach(curios -> curios.forEach(curio -> {
            if (!(curio.m_41720_() instanceof TrinketItem)) {
                return;
            }
            TrinketItem.getTrinket(curio).ifPresent(trinket -> {
                if (trinketClass.isInstance(trinket)) {
                    trinkets.add(new TrinketStack<TrinketEffect>((ItemStack)curio, (TrinketEffect)((Object)((Object)((Object)trinket)))));
                }
            });
        }));
        return trinkets;
    }

    public record TrinketStack<T extends TrinketEffect<?>>(ItemStack stack, T trinket) {
        public boolean isUsable(Player player) {
            return ((TrinketEffect)((Object)this.trinket())).isUsable(this.stack(), player);
        }
    }
}

