/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.trinket;

import com.google.gson.annotations.Expose;
import iskallia.vault.config.TrinketConfig;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.item.gear.TrinketItem;
import iskallia.vault.util.MiscUtils;
import iskallia.vault.world.data.ServerVaults;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistryEntry;

public abstract class TrinketEffect<T extends Config>
extends ForgeRegistryEntry<TrinketEffect<?>> {
    public TrinketEffect(ResourceLocation name) {
        this.setRegistryName(name);
    }

    public abstract Class<T> getConfigClass();

    public abstract T getDefaultConfig();

    public TrinketConfig.Trinket getTrinketConfig() {
        return ModConfigs.TRINKET.getTrinketConfig(this);
    }

    public T getConfig() {
        return (T)((Config)this.getTrinketConfig().getConfig());
    }

    public boolean isUsable(ItemStack trinket, Player player) {
        if (!TrinketItem.isIdentified(trinket)) {
            return false;
        }
        int usesLeft = TrinketItem.getUses(trinket);
        if (!ServerVaults.isInVault((Entity)player)) {
            return usesLeft > 0;
        }
        return MiscUtils.getVault(player).map(vault -> TrinketItem.isUsableInVault(trinket, vault.get(Vault.ID))).orElse(false);
    }

    public void onEquip(LivingEntity entity, ItemStack stack) {
    }

    public void onUnEquip(LivingEntity entity, ItemStack stack) {
    }

    public void onWornTick(LivingEntity entity, ItemStack stack) {
    }

    public static class Config {
        @Expose
        private String curiosSlot = "trinket";

        public Config() {
        }

        public Config(String curiosSlot) {
            this.curiosSlot = curiosSlot;
        }

        public boolean hasCuriosSlot() {
            return !this.getCuriosSlot().isEmpty();
        }

        public String getCuriosSlot() {
            return this.curiosSlot;
        }
    }

    public static class Simple
    extends TrinketEffect<NoOpConfig> {
        public Simple(ResourceLocation name) {
            super(name);
        }

        @Override
        public final Class<NoOpConfig> getConfigClass() {
            return NoOpConfig.class;
        }

        @Override
        public final NoOpConfig getDefaultConfig() {
            return new NoOpConfig();
        }

        public static class NoOpConfig
        extends Config {
        }
    }
}

