/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.tooltip;

import iskallia.vault.config.EtchingConfig;
import iskallia.vault.dynamodel.model.armor.ArmorPieceModel;
import iskallia.vault.etching.EtchingSet;
import iskallia.vault.gear.VaultGearRarity;
import iskallia.vault.gear.VaultGearState;
import iskallia.vault.gear.attribute.VaultGearAttribute;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.gear.tooltip.GearTooltip;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModDynamicModels;
import iskallia.vault.init.ModGearAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class VaultGearDataTooltip {
    public static List<Component> createTooltip(ItemStack stack, GearTooltip flag) {
        if (!ModConfigs.isInitialized()) {
            return Collections.emptyList();
        }
        VaultGearData data = VaultGearData.read(stack);
        ArrayList<Component> tooltip = new ArrayList<Component>();
        VaultGearState state = data.getState();
        tooltip.add((Component)new TextComponent("Level: ").m_7220_((Component)new TextComponent("" + data.getItemLevel()).m_6270_(Style.f_131099_.m_178520_(11583738))));
        if (flag.displayCraftingDetail()) {
            VaultGearDataTooltip.addPotentialTooltip(data, stack, tooltip, state);
        }
        if (flag.displayBase()) {
            data.getFirstValue(ModGearAttributes.CRAFTED_BY).ifPresent(crafter -> tooltip.add((Component)new TextComponent("Crafted by: ").m_7220_((Component)new TextComponent(crafter).m_6270_(Style.f_131099_.m_178520_(16770048)))));
        }
        VaultGearDataTooltip.addRarityTooltip(data, stack, tooltip, state);
        if (state == VaultGearState.IDENTIFIED) {
            int suffixes;
            int prefixes;
            if (flag.displayBase()) {
                VaultGearDataTooltip.addModelTooltip(data, stack, tooltip);
            }
            if (flag.displayBase()) {
                VaultGearDataTooltip.addEtchingTooltip(tooltip, data);
            }
            int usedRepairs = data.getUsedRepairSlots();
            int totalRepairs = data.getRepairSlots();
            VaultGearDataTooltip.addRepairTooltip(tooltip, usedRepairs, totalRepairs);
            List<VaultGearModifier<?>> implicits = data.getModifiers(VaultGearModifier.AffixType.IMPLICIT);
            if (!implicits.isEmpty()) {
                VaultGearDataTooltip.addAffixTooltip(data, VaultGearModifier.AffixType.IMPLICIT, stack, tooltip, flag.displayModifierDetail());
                tooltip.add(TextComponent.f_131282_);
            }
            if ((prefixes = data.getFirstValue(ModGearAttributes.PREFIXES).orElse(0).intValue()) > 0) {
                VaultGearDataTooltip.addAffixTooltip(data, VaultGearModifier.AffixType.PREFIX, stack, tooltip, flag.displayModifierDetail());
                if (flag.displayModifierDetail()) {
                    tooltip.add(TextComponent.f_131282_);
                }
            }
            if ((suffixes = data.getFirstValue(ModGearAttributes.SUFFIXES).orElse(0).intValue()) > 0) {
                VaultGearDataTooltip.addAffixTooltip(data, VaultGearModifier.AffixType.SUFFIX, stack, tooltip, flag.displayModifierDetail());
            }
        }
        return tooltip;
    }

    private static void addEtchingTooltip(List<Component> tooltip, VaultGearData data) {
        data.getFirstValue(ModGearAttributes.ETCHING).ifPresent(etchingSet -> {
            EtchingConfig.Etching etchingConfig = ModConfigs.ETCHING.getEtchingConfig((EtchingSet<?>)((Object)etchingSet));
            if (etchingConfig != null) {
                MutableComponent etchingCmp = new TextComponent(etchingConfig.getName()).m_130948_(Style.f_131099_.m_131148_(etchingConfig.getComponentColor()));
                tooltip.add((Component)new TextComponent("Etching: ").m_130940_(ChatFormatting.RED).m_7220_((Component)etchingCmp));
            }
        });
    }

    public static void addRepairTooltip(List<Component> tooltip, int usedRepairs, int totalRepairs) {
        int remaining = totalRepairs - usedRepairs;
        tooltip.add((Component)new TextComponent("Repairs: ").m_7220_(VaultGearDataTooltip.tooltipDots(usedRepairs, ChatFormatting.YELLOW)).m_7220_(VaultGearDataTooltip.tooltipDots(remaining, ChatFormatting.GRAY)));
    }

    private static void addAffixTooltip(VaultGearData data, VaultGearModifier.AffixType type, ItemStack stack, List<Component> tooltip, boolean displayDetails) {
        List<VaultGearModifier<?>> affixes = data.getModifiers(type);
        VaultGearAttribute<Integer> affixAttribute = type == VaultGearModifier.AffixType.PREFIX ? ModGearAttributes.PREFIXES : ModGearAttributes.SUFFIXES;
        int emptyAffixes = data.getFirstValue(affixAttribute).orElse(0);
        if (displayDetails) {
            tooltip.add((Component)new TextComponent(type.getDisplayName() + ":").m_130940_(ChatFormatting.GRAY));
        }
        affixes.forEach(modifier -> modifier.getDisplay(data, type, stack, displayDetails).ifPresent(tooltip::add));
        if (displayDetails && type != VaultGearModifier.AffixType.IMPLICIT) {
            for (int i = 0; i < emptyAffixes - affixes.size(); ++i) {
                tooltip.add(VaultGearDataTooltip.emptyAffix(type));
            }
        }
    }

    private static void addRarityTooltip(VaultGearData data, ItemStack stack, List<Component> tooltip, VaultGearState state) {
        switch (state) {
            case UNIDENTIFIED: {
                data.getFirstValue(ModGearAttributes.GEAR_ROLL_TYPE).flatMap(ModConfigs.VAULT_GEAR_TYPE_CONFIG::getRollPool).ifPresent(pool -> tooltip.add((Component)new TextComponent("Roll: ").m_7220_((Component)new TextComponent(pool.getName()).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)pool.getColor()))))));
                break;
            }
            case IDENTIFIED: {
                MutableComponent rarityText = new TextComponent("Rarity: ").m_7220_((Component)data.getRarity().getDisplayName().m_6881_().m_130948_(Style.f_131099_.m_131148_(data.getRarity().getColor())));
                tooltip.add((Component)rarityText);
            }
        }
    }

    private static void addModelTooltip(VaultGearData data, ItemStack stack, List<Component> tooltip) {
        data.getFirstValue(ModGearAttributes.GEAR_MODEL).flatMap(modelId -> ModDynamicModels.REGISTRIES.getModel(stack.m_41720_(), (ResourceLocation)modelId)).ifPresent(gearModel -> {
            Item patt6792$temp = stack.m_41720_();
            if (patt6792$temp instanceof VaultGearItem) {
                VaultGearItem gearItem = (VaultGearItem)patt6792$temp;
                String name = gearModel.getDisplayName();
                if (gearModel instanceof ArmorPieceModel) {
                    ArmorPieceModel modelPiece = (ArmorPieceModel)gearModel;
                    name = modelPiece.getArmorModel().getDisplayName();
                }
                VaultGearRarity rollRarity = ModConfigs.GEAR_MODEL_ROLL_RARITIES.getRarityOf(gearItem, gearModel.getId());
                MutableComponent modelTooltip = new TextComponent("Model: ").m_130944_(new ChatFormatting[0]).m_7220_((Component)new TextComponent(name).m_130948_(Style.f_131099_.m_178520_(rollRarity.getColor().m_131265_())));
                tooltip.add((Component)modelTooltip);
            }
        });
    }

    private static void addPotentialTooltip(VaultGearData data, ItemStack stack, List<Component> tooltip, VaultGearState state) {
        if (state != VaultGearState.IDENTIFIED) {
            return;
        }
        int craftingPotential = data.getFirstValue(ModGearAttributes.CRAFTING_POTENTIAL).orElse(0);
        TextComponent potential = new TextComponent(String.valueOf(craftingPotential));
        if (craftingPotential > 0) {
            potential.m_130948_(Style.f_131099_.m_178520_(16757593));
        } else {
            potential.m_130940_(ChatFormatting.RED);
        }
        tooltip.add((Component)new TextComponent("Crafting Potential: ").m_7220_((Component)potential));
    }

    private static Component emptyAffix(VaultGearModifier.AffixType type) {
        return new TextComponent("\u25a0 empty %s".formatted(type.name().toLowerCase(Locale.ROOT))).m_130940_(ChatFormatting.GRAY);
    }

    public static Component tooltipDots(int amount, ChatFormatting formatting) {
        return new TextComponent("\u2b22 ".repeat(Math.max(0, amount))).m_130940_(formatting);
    }
}

