/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.modification;

import iskallia.vault.config.gear.VaultGearModificationConfig;
import iskallia.vault.gear.VaultGearRarity;
import iskallia.vault.gear.modification.GearModification;
import iskallia.vault.init.ModConfigs;
import net.minecraft.util.Mth;

public record GearModificationCost(int costPlating, int costBronze) {
    public static GearModificationCost getCost(VaultGearRarity gearRarity, int gearLevel, int gearPotential, GearModification modification) {
        VaultGearModificationConfig.OperationConfig cfg = ModConfigs.VAULT_GEAR_MODIFICATION_CONFIG.getOperationConfig(modification);
        if (cfg == null) {
            return new GearModificationCost(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }
        float incPotential = ModConfigs.VAULT_GEAR_CRAFTING_CONFIG.getPotentialIncreasePerLevel() * (float)gearLevel;
        float maxPotential = (float)ModConfigs.VAULT_GEAR_CRAFTING_CONFIG.getMaxCraftingPotential(gearRarity) * (1.0f + incPotential);
        float maxPotentialMultiplier = Math.max(maxPotential / 120.0f, 1.0f);
        float multiplier = cfg.getBaseCostMultiplier() * maxPotentialMultiplier;
        float basePlating = Math.max(2.0f * multiplier, 1.0f);
        float baseBronze = 35.0f * multiplier;
        if (gearPotential >= 0) {
            float potentialPercent = Mth.m_14036_((float)(1.0f - (float)gearPotential / maxPotential), (float)0.0f, (float)1.0f);
            int offset = 3;
            return new GearModificationCost(Math.max(Math.round(basePlating), 1), Math.max(offset + Math.round((baseBronze - (float)offset) * potentialPercent), 1));
        }
        int absPotential = Math.abs(gearPotential);
        float negativeMultiplier = cfg.getNegativePotentialCostMultiplier();
        float scale = 1.0f + (float)absPotential * negativeMultiplier / 20.0f;
        return new GearModificationCost(Math.max(Math.round(basePlating * scale), 1), Math.max(Math.round(baseBronze * scale), 1));
    }
}

