/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.item;

import com.google.gson.JsonObject;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.dynamodel.DynamicModelItem;
import iskallia.vault.dynamodel.model.armor.ArmorPieceModel;
import iskallia.vault.gear.GearRollHelper;
import iskallia.vault.gear.VaultGearClassification;
import iskallia.vault.gear.VaultGearHelper;
import iskallia.vault.gear.VaultGearRarity;
import iskallia.vault.gear.VaultGearState;
import iskallia.vault.gear.crafting.ProficiencyType;
import iskallia.vault.gear.data.AttributeGearData;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModDynamicModels;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.item.IConditionalDamageable;
import iskallia.vault.item.gear.DataTransferItem;
import iskallia.vault.item.gear.VaultLootItem;
import iskallia.vault.util.SidedHelper;
import iskallia.vault.util.VHSmpUtil;
import iskallia.vault.world.data.ServerVaults;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.extensions.IForgeItem;

public interface VaultGearItem
extends IForgeItem,
DataTransferItem,
VaultLootItem,
DynamicModelItem,
IConditionalDamageable {
    default public Item getItem() {
        return (Item)this;
    }

    public static <T extends VaultGearItem> T of(ItemStack stack) {
        if (!(stack.m_41720_() instanceof VaultGearItem)) {
            throw new IllegalArgumentException("Item is not VaultGear: %s".formatted(stack));
        }
        return (T)((VaultGearItem)stack.m_41720_());
    }

    public static JsonObject serializeGearData(ItemStack stack) {
        return ((AttributeGearData)AttributeGearData.read(stack)).serialize();
    }

    default public ItemStack defaultItem() {
        ItemStack stack = new ItemStack((ItemLike)this.getItem());
        VaultGearData.read(stack).write(stack);
        return stack;
    }

    @Override
    default public boolean isImmuneToDamage(ItemStack stack, @Nullable Player player) {
        if (player == null) {
            return false;
        }
        return !ServerVaults.isVaultWorld(player.m_183503_()) && !VHSmpUtil.isArenaWorld((Entity)player);
    }

    @Override
    @Nullable
    default public Optional<ResourceLocation> getDynamicModelId(ItemStack itemStack) {
        VaultGearData gearData = VaultGearData.read(itemStack);
        if (gearData.getState() == VaultGearState.UNIDENTIFIED) {
            return Optional.empty();
        }
        return gearData.getFirstValue(ModGearAttributes.GEAR_MODEL);
    }

    @Override
    default public void initializeLoot(Vault vault, ItemStack stack) {
        VaultGearData data = VaultGearData.read(stack);
        data.setItemLevel(vault.get(Vault.LEVEL).get());
        data.updateAttribute(ModGearAttributes.IS_LOOT, true);
        data.write(stack);
    }

    @Override
    default public ItemStack convertStack(ItemStack stack, RandomSource random) {
        String modelAttrKey;
        CompoundTag tag;
        EquipmentSlot slot = this.getIntendedSlot(stack);
        if (stack.m_41782_() && slot != null && (tag = stack.m_41784_()).m_128425_(modelAttrKey = ModGearAttributes.GEAR_MODEL.getRegistryName().toString(), 8)) {
            String modelStr = tag.m_128461_(modelAttrKey);
            if (modelStr.equalsIgnoreCase("random")) {
                ArmorPieceModel randomModel;
                HashSet models = new HashSet();
                ModConfigs.GEAR_MODEL_ROLL_RARITIES.getRolls(this).forEach((rarity, modelList) -> {
                    if (rarity == VaultGearRarity.UNIQUE) {
                        return;
                    }
                    models.addAll(modelList);
                });
                List<ArmorPieceModel> armorModelSet = models.stream().map(ResourceLocation::new).map(ModDynamicModels.Armor.MODEL_REGISTRY::get).filter(Optional::isPresent).map(Optional::get).map(model -> model.getPiece(slot)).filter(Optional::isPresent).map(Optional::get).toList();
                ArmorPieceModel armorPieceModel = randomModel = armorModelSet.isEmpty() ? null : armorModelSet.get(random.nextInt(armorModelSet.size()));
                if (randomModel != null) {
                    VaultGearData data = VaultGearData.read(stack);
                    data.updateAttribute(ModGearAttributes.GEAR_MODEL, randomModel.getId());
                    data.write(stack);
                }
            }
            tag.m_128473_(modelAttrKey);
        }
        ItemStack result = DataTransferItem.super.convertStack(stack, random);
        VaultGearHelper.initializeGearRollType(result, VaultGearData.read(result).getItemLevel(), random);
        return result;
    }

    default public void setPlayerLevel(ItemStack stack, Player player) {
        VaultGearData data = VaultGearData.read(stack);
        data.setItemLevel(SidedHelper.getVaultLevel(player));
        data.write(stack);
    }

    default public void setLevel(ItemStack stack, int level) {
        VaultGearData data = VaultGearData.read(stack);
        data.setItemLevel(level);
        data.write(stack);
    }

    @Nonnull
    public VaultGearClassification getClassification(ItemStack var1);

    @Nonnull
    public ProficiencyType getCraftingProficiencyType(ItemStack var1);

    @Nullable
    public EquipmentSlot getIntendedSlot(ItemStack var1);

    @Nullable
    public ResourceLocation getRandomModel(ItemStack var1, Random var2);

    default public int getRandomColor(ItemStack stack, Random random) {
        List<Integer> colors = Arrays.stream(DyeColor.values()).filter(color -> color != DyeColor.BLACK && color != DyeColor.GRAY && color != DyeColor.LIGHT_GRAY).map(DyeColor::m_41071_).toList();
        return colors.get(random.nextInt(colors.size()));
    }

    default public boolean isIntendedForSlot(ItemStack stack, EquipmentSlot slotType) {
        return this.getIntendedSlot(stack) == slotType;
    }

    default public void vaultGearTick(ItemStack stack, ServerPlayer player) {
        VaultGearHelper.initializeGearRollType(stack, player);
        GearRollHelper.tickRollVaultGear(stack, player);
    }
}

