/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import iskallia.vault.core.net.ArrayBitBuffer;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.gear.attribute.VaultGearAttribute;
import iskallia.vault.gear.attribute.VaultGearAttributeInstance;
import iskallia.vault.gear.attribute.VaultGearAttributeRegistry;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.attribute.type.VaultGearAttributeTypeMerger;
import iskallia.vault.gear.data.GearDataVersion;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.VaultGearItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class AttributeGearData {
    private static final String TAG_KEY = "vaultGearData";
    private GearDataVersion version = GearDataVersion.current();
    private UUID identifier = UUID.randomUUID();
    List<VaultGearAttributeInstance<?>> attributes = new ArrayList();

    protected AttributeGearData() {
    }

    protected AttributeGearData(BitBuffer buf) {
        this.read(buf);
    }

    protected AttributeGearData(CompoundTag tag) {
        GearDataVersion version = GearDataVersion.values()[tag.m_128451_("version")];
        this.fromNbt(tag, version);
    }

    public static boolean hasData(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128425_(TAG_KEY, 12);
    }

    @Nonnull
    protected static <T extends AttributeGearData> T read(ItemStack stack, Function<BitBuffer, T> bufferCtor, Supplier<T> ctor) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128425_(TAG_KEY, 12)) {
            return (T)((AttributeGearData)ctor.get());
        }
        return (T)((AttributeGearData)bufferCtor.apply(ArrayBitBuffer.backing(tag.m_128467_(TAG_KEY), 0)));
    }

    @Nonnull
    public static <T extends AttributeGearData> T read(ItemStack stack) {
        if (stack.m_41720_() instanceof VaultGearItem) {
            return (T)AttributeGearData.read(stack, VaultGearData::new, VaultGearData::new);
        }
        return (T)AttributeGearData.read(stack, AttributeGearData::new, AttributeGearData::new);
    }

    public static Optional<UUID> readUUID(ItemStack stack) {
        if (!AttributeGearData.hasData(stack)) {
            return Optional.empty();
        }
        ArrayBitBuffer buf = ArrayBitBuffer.backing(stack.m_41784_().m_128467_(TAG_KEY), 0);
        buf.readEnum(GearDataVersion.class);
        return Optional.of(buf.readUUID());
    }

    @Nonnull
    public static <T extends AttributeGearData> T fromNbt(ItemStack stack, CompoundTag tag) {
        if (stack.m_41720_() instanceof VaultGearItem) {
            return (T)new VaultGearData(tag);
        }
        return (T)new AttributeGearData(tag);
    }

    public void write(ItemStack stack) {
        this.markChanged();
        ArrayBitBuffer buffer = ArrayBitBuffer.empty();
        this.write(buffer);
        stack.m_41784_().m_128388_(TAG_KEY, buffer.toLongArray());
    }

    protected void markChanged() {
        this.identifier = UUID.randomUUID();
    }

    public UUID getIdentifier() {
        return this.identifier;
    }

    public <T> Optional<T> getFirstValue(VaultGearAttribute<T> attribute) {
        return Optional.ofNullable(this.get(attribute, VaultGearAttributeTypeMerger.firstNonNull()));
    }

    public <T, V> V get(VaultGearAttribute<T> attribute, VaultGearAttributeTypeMerger<T, V> merger) {
        V merged = merger.getBaseValue();
        for (VaultGearAttributeInstance<?> instance : this.attributes) {
            if (!((Object)instance.getAttribute()).equals(attribute)) continue;
            merged = merger.merge(merged, instance.getValue());
        }
        return merged;
    }

    public boolean has(VaultGearAttribute<?> attribute) {
        for (VaultGearAttributeInstance<?> instance : this.attributes) {
            if (!((Object)instance.getAttribute()).equals(attribute)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public <T> T updateAttribute(VaultGearAttribute<T> attribute, T value) {
        for (VaultGearAttributeInstance<?> instance : this.attributes) {
            if (!((Object)instance.getAttribute()).equals(attribute)) continue;
            return (T)instance.setValue(value);
        }
        this.attributes.add(new VaultGearAttributeInstance<T>(attribute, value));
        return null;
    }

    public void clear() {
        this.attributes.clear();
    }

    protected void write(BitBuffer buf) {
        buf.writeEnum(GearDataVersion.current());
        buf.writeUUID(this.identifier);
        buf.writeCollection(this.attributes, VaultGearAttributeRegistry::writeAttributeInstance);
    }

    protected void read(BitBuffer buf) {
        this.version = buf.readEnum(GearDataVersion.class);
        this.identifier = buf.readUUID();
        this.attributes = buf.readCollection(ArrayList::new, this.versioned(VaultGearAttributeRegistry::readAttributeInstance));
    }

    public CompoundTag toNbt() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("version", this.version.ordinal());
        ListTag attributes = new ListTag();
        this.attributes.stream().map(VaultGearAttributeRegistry::serializeAttributeInstance).forEach(arg_0 -> attributes.add(arg_0));
        tag.m_128365_("attributes", (Tag)attributes);
        return tag;
    }

    protected void fromNbt(CompoundTag tag, GearDataVersion version) {
        this.clear();
        this.version = GearDataVersion.current();
        ListTag attributes = tag.m_128437_("attributes", 10);
        for (int i = 0; i < attributes.size(); ++i) {
            CompoundTag attrData = attributes.m_128728_(i);
            VaultGearAttributeInstance<?> inst = VaultGearAttributeRegistry.deserializeAttributeInstance(attrData, version);
            if (inst == null) continue;
            this.attributes.add(inst);
        }
        this.markChanged();
    }

    public JsonObject serialize() {
        JsonObject obj = new JsonObject();
        obj.addProperty("id", this.getIdentifier().toString());
        JsonArray attributes = new JsonArray();
        this.attributes.forEach(attr -> attributes.add((JsonElement)attr.serialize(VaultGearModifier.AffixType.IMPLICIT)));
        obj.add("attributes", (JsonElement)attributes);
        return obj;
    }

    public <T> Function<BitBuffer, T> versioned(BiFunction<BitBuffer, GearDataVersion, T> fn) {
        return buf -> fn.apply((BitBuffer)buf, this.version);
    }
}

