/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.crafting;

import iskallia.vault.block.entity.VaultForgeTileEntity;
import iskallia.vault.container.oversized.OverSizedItemStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;

public class VaultForgeHelper {
    public static List<ItemStack> getMissingInputs(List<ItemStack> recipeInputs, Inventory playerInventory, VaultForgeTileEntity tile) {
        ArrayList<ItemStack> missing = new ArrayList<ItemStack>();
        for (ItemStack input : recipeInputs) {
            int neededCount = input.m_41613_();
            for (OverSizedItemStack overSized : tile.getInventory().getOverSizedContents()) {
                if (!VaultForgeHelper.isEqualCrafting(input, overSized.stack())) continue;
                neededCount -= overSized.amount();
            }
            for (ItemStack plStack : playerInventory.f_35974_) {
                if (!VaultForgeHelper.isEqualCrafting(input, plStack)) continue;
                neededCount -= plStack.m_41613_();
            }
            if (neededCount <= 0) continue;
            missing.add(input);
        }
        return missing;
    }

    public static boolean consumeInputs(List<ItemStack> recipeInputs, Inventory playerInventory, VaultForgeTileEntity tile, boolean simulate) {
        boolean missingInput = true;
        for (ItemStack input : recipeInputs) {
            int neededCount = input.m_41613_();
            NonNullList<OverSizedItemStack> overSizedContents = tile.getInventory().getOverSizedContents();
            for (int slot = 0; slot < overSizedContents.size(); ++slot) {
                OverSizedItemStack overSized = (OverSizedItemStack)overSizedContents.get(slot);
                if (neededCount <= 0) break;
                if (!VaultForgeHelper.isEqualCrafting(input, overSized.stack())) continue;
                int deductedAmount = Math.min(neededCount, overSized.amount());
                if (!simulate) {
                    tile.getInventory().setOverSizedStack(slot, overSized.addCopy(-deductedAmount));
                }
                neededCount -= overSized.amount();
            }
            NonNullList items = playerInventory.f_35974_;
            for (ItemStack plStack : items) {
                if (neededCount <= 0) break;
                if (!VaultForgeHelper.isEqualCrafting(input, plStack)) continue;
                int deductedAmount = Math.min(neededCount, plStack.m_41613_());
                if (!simulate) {
                    plStack.m_41774_(deductedAmount);
                }
                neededCount -= deductedAmount;
            }
            if (neededCount <= 0) continue;
            missingInput = false;
        }
        return missingInput;
    }

    private static boolean isEqualCrafting(ItemStack thisStack, ItemStack thatStack) {
        return thisStack.m_41720_() == thatStack.m_41720_() && thisStack.m_41773_() == thatStack.m_41773_() && thisStack.areShareTagsEqual(thatStack);
    }
}

