/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.attribute.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.apache.commons.lang3.ObjectUtils;

public abstract class VaultGearAttributeTypeMerger<T, C> {
    public abstract C merge(C var1, T var2);

    public abstract C getBaseValue();

    public static <T, C> VaultGearAttributeTypeMerger<T, C> of(final Supplier<C> baseValueSupplier, final BiFunction<C, T, C> mergeFunction) {
        return new VaultGearAttributeTypeMerger<T, C>(){

            @Override
            public C merge(C merged, T other) {
                return mergeFunction.apply(merged, other);
            }

            @Override
            public C getBaseValue() {
                return baseValueSupplier.get();
            }
        };
    }

    public static VaultGearAttributeTypeMerger<Integer, Integer> intSum() {
        return VaultGearAttributeTypeMerger.of(() -> 0, Integer::sum);
    }

    public static VaultGearAttributeTypeMerger<Integer, Integer> intMax() {
        return VaultGearAttributeTypeMerger.of(() -> 0, Integer::max);
    }

    public static VaultGearAttributeTypeMerger<Float, Float> floatSum() {
        return VaultGearAttributeTypeMerger.of(() -> Float.valueOf(0.0f), Float::sum);
    }

    public static VaultGearAttributeTypeMerger<Float, Float> floatMax() {
        return VaultGearAttributeTypeMerger.of(() -> Float.valueOf(0.0f), Float::max);
    }

    public static VaultGearAttributeTypeMerger<Double, Double> doubleSum() {
        return VaultGearAttributeTypeMerger.of(() -> 0.0, Double::sum);
    }

    public static VaultGearAttributeTypeMerger<Double, Double> doubleMax() {
        return VaultGearAttributeTypeMerger.of(() -> 0.0, Double::max);
    }

    public static VaultGearAttributeTypeMerger<Boolean, Boolean> anyTrue() {
        return VaultGearAttributeTypeMerger.of(() -> false, (flag, element) -> flag != false || element != false);
    }

    public static VaultGearAttributeTypeMerger<Boolean, Boolean> anyFalse() {
        return VaultGearAttributeTypeMerger.of(() -> false, (flag, element) -> flag != false || element == false);
    }

    public static VaultGearAttributeTypeMerger<String, String> concat() {
        return VaultGearAttributeTypeMerger.of(() -> "", String::concat);
    }

    public static VaultGearAttributeTypeMerger<String, String> joining(CharSequence delimiter) {
        return VaultGearAttributeTypeMerger.of(() -> "", (str, element) -> {
            if (!((String)str).isEmpty()) {
                str = (String)str + delimiter;
            }
            return (String)str + element;
        });
    }

    public static <T> VaultGearAttributeTypeMerger<T, T> firstNonNull() {
        return VaultGearAttributeTypeMerger.of(() -> null, (xva$0, xva$1) -> ObjectUtils.firstNonNull((Object[])new Object[]{xva$0, xva$1}));
    }

    public static <T> VaultGearAttributeTypeMerger<T, Set<T>> asSet() {
        return VaultGearAttributeTypeMerger.asCollection(HashSet::new);
    }

    public static <T> VaultGearAttributeTypeMerger<T, List<T>> asList() {
        return VaultGearAttributeTypeMerger.asCollection(ArrayList::new);
    }

    public static <T, C extends Collection<T>> VaultGearAttributeTypeMerger<T, C> asCollection(Supplier<C> listSupplier) {
        return VaultGearAttributeTypeMerger.of(listSupplier, (list, element) -> {
            list.add(element);
            return list;
        });
    }
}

