/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.attribute.config;

import com.google.gson.annotations.Expose;
import iskallia.vault.gear.attribute.config.NumberRangeGenerator;
import iskallia.vault.gear.reader.VaultGearModifierReader;
import java.util.Random;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class IntegerAttributeGenerator
extends NumberRangeGenerator<Integer, Range> {
    @Override
    @Nullable
    public Class<Range> getConfigurationObjectClass() {
        return Range.class;
    }

    @Override
    public MutableComponent getConfigDisplay(VaultGearModifierReader<Integer> reader, Range object) {
        MutableComponent minDisplay = reader.getValueDisplay(object.min);
        MutableComponent maxDisplay = reader.getValueDisplay(object.max);
        if (minDisplay == null || maxDisplay == null) {
            return new TextComponent("");
        }
        return minDisplay.m_130946_("-").m_7220_((Component)maxDisplay);
    }

    public static class Range
    extends NumberRangeGenerator.NumberRange<Integer> {
        @Expose
        private int min;
        @Expose
        private int max;
        @Expose
        private int step;

        public Range(int min, int max, int step) {
            this.min = min;
            this.max = max;
            this.step = step;
        }

        @Override
        public Integer generateNumber(Random random) {
            int steps = Mth.m_14143_((float)(Math.max(this.max - this.min, 0) / this.step)) + 1;
            return this.min + random.nextInt(steps) * this.step;
        }
    }
}

