/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.attribute.config;

import com.google.gson.annotations.Expose;
import iskallia.vault.gear.attribute.config.NumberRangeGenerator;
import iskallia.vault.gear.reader.VaultGearModifierReader;
import java.text.DecimalFormat;
import java.util.Random;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class FloatAttributeGenerator
extends NumberRangeGenerator<Float, Range> {
    private static final DecimalFormat FORMAT = new DecimalFormat("0.##");

    @Override
    @Nullable
    public Class<Range> getConfigurationObjectClass() {
        return Range.class;
    }

    @Override
    public MutableComponent getConfigDisplay(VaultGearModifierReader<Float> reader, Range object) {
        MutableComponent minDisplay = reader.getValueDisplay(Float.valueOf(object.min));
        MutableComponent maxDisplay = reader.getValueDisplay(Float.valueOf(object.max));
        if (minDisplay == null || maxDisplay == null) {
            return new TextComponent("");
        }
        return minDisplay.m_130946_("-").m_7220_((Component)maxDisplay);
    }

    public static class Range
    extends NumberRangeGenerator.NumberRange<Float> {
        @Expose
        private float min;
        @Expose
        private float max;
        @Expose
        private float step;

        public Range(float min, float max) {
            this(min, max, 0.1f);
        }

        public Range(float min, float max, float step) {
            this.min = min;
            this.max = max;
            this.step = step;
        }

        @Override
        public Float generateNumber(Random random) {
            int steps = Mth.m_14143_((float)(Math.max(this.max - this.min, 0.0f) / this.step)) + 1;
            return Float.valueOf(this.min + (float)random.nextInt(steps) * this.step);
        }
    }
}

