/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.attribute;

import com.google.gson.JsonObject;
import iskallia.vault.config.gear.VaultGearTierConfig;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.gear.attribute.VaultGearAttribute;
import iskallia.vault.gear.attribute.VaultGearAttributeInstance;
import iskallia.vault.gear.attribute.config.ConfigurableAttributeGenerator;
import iskallia.vault.gear.data.GearDataVersion;
import iskallia.vault.gear.data.VaultGearData;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class VaultGearModifier<T>
extends VaultGearAttributeInstance<T> {
    private int rolledTier = -1;
    private boolean legendary = false;
    private String modifierGroup = "";
    private ResourceLocation modifierIdentifier = null;
    private long gameTimeAdded = Long.MIN_VALUE;

    VaultGearModifier(VaultGearAttribute<T> attribute) {
        super(attribute);
    }

    public VaultGearModifier(VaultGearAttribute<T> attribute, T value) {
        super(attribute, value);
    }

    public void setRolledTier(int rolledTier) {
        this.rolledTier = rolledTier;
    }

    public int getRolledTier() {
        return this.rolledTier;
    }

    public void setLegendary(boolean legendary) {
        this.legendary = legendary;
    }

    public boolean isLegendary() {
        return this.legendary;
    }

    public void setModifierGroup(String modifierGroup) {
        this.modifierGroup = modifierGroup;
    }

    public String getModifierGroup() {
        return this.modifierGroup;
    }

    public void setModifierIdentifier(ResourceLocation modifierIdentifier) {
        this.modifierIdentifier = modifierIdentifier;
    }

    public ResourceLocation getModifierIdentifier() {
        return this.modifierIdentifier;
    }

    public void setGameTimeAdded(long gameTimeAdded) {
        this.gameTimeAdded = gameTimeAdded;
    }

    public long getGameTimeAdded() {
        return this.gameTimeAdded;
    }

    public boolean hasGameTimeAdded() {
        return this.getGameTimeAdded() != Long.MIN_VALUE;
    }

    public void resetGameTimeAdded() {
        this.setGameTimeAdded(Long.MIN_VALUE);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Optional<MutableComponent> getDisplay(VaultGearData data, AffixType type, ItemStack stack, boolean displayDetail) {
        return super.getDisplay(data, type, stack, displayDetail).map(displayText -> {
            if (!this.isLegendary()) {
                return displayText;
            }
            Style style = displayText.m_7383_();
            String rawString = displayText.getString();
            MutableComponent legendaryCt = new TextComponent("\u2726 ").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)15853364)));
            int time = rawString.length();
            time = (int)((double)time * 1.4);
            int step = (int)(System.currentTimeMillis() / 90L % (long)time);
            if (step >= rawString.length()) {
                return legendaryCt.m_7220_((Component)new TextComponent(rawString).m_6270_(style));
            }
            int stepCap = Math.min(step + 1, rawString.length());
            String start = rawString.substring(0, step);
            String highlight = rawString.substring(step, stepCap);
            String end = rawString.substring(stepCap);
            return legendaryCt.m_7220_((Component)new TextComponent(start).m_6270_(style)).m_7220_((Component)new TextComponent(highlight).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.WHITE))).m_7220_((Component)new TextComponent(end).m_6270_(style));
        }).map(displayText -> {
            if (!this.hasGameTimeAdded()) {
                return displayText;
            }
            int showDuration = 600;
            long added = this.getGameTimeAdded();
            ClientLevel currentWorld = Minecraft.m_91087_().f_91073_;
            if (currentWorld == null || currentWorld.m_46467_() - added > (long)showDuration) {
                return displayText;
            }
            displayText.m_7220_((Component)new TextComponent(" [new]").m_130940_(ChatFormatting.GOLD));
            return displayText;
        }).map(displayText -> {
            if (!displayDetail) {
                return displayText;
            }
            MutableComponent tierDisplay = VaultGearTierConfig.getConfig(stack.m_41720_()).map(tierConfig -> {
                Object config = tierConfig.getTierConfig(this);
                if (config != null) {
                    ConfigurableAttributeGenerator configGen = this.getAttribute().getGenerator();
                    return configGen.getConfigDisplay(this.getAttribute().getReader(), config);
                }
                return null;
            }).orElse(null);
            if (tierDisplay != null) {
                String legendaryInfo;
                Style txtStyle = Style.f_131099_.m_131140_(ChatFormatting.GRAY).m_131155_(Boolean.valueOf(false)).m_131162_(Boolean.valueOf(false)).m_131136_(Boolean.valueOf(false));
                String string = legendaryInfo = this.isLegendary() ? "Legendary " : "";
                if (tierDisplay.getString().isEmpty()) {
                    displayText.m_7220_((Component)new TextComponent(" (%sT%s)".formatted(legendaryInfo, this.getRolledTier() + 1)).m_6270_(txtStyle));
                } else {
                    displayText.m_7220_((Component)new TextComponent(" (%sT%s: ".formatted(legendaryInfo, this.getRolledTier() + 1)).m_6270_(txtStyle));
                    displayText.m_7220_((Component)tierDisplay.m_6270_(txtStyle));
                    displayText.m_7220_((Component)new TextComponent(")").m_6270_(txtStyle));
                }
            }
            return displayText;
        });
    }

    @Override
    public void write(BitBuffer buf) {
        super.write(buf);
        buf.writeInt(this.rolledTier);
        buf.writeBoolean(this.legendary);
        buf.writeString(this.modifierGroup);
        buf.writeNullable(this.modifierIdentifier, BitBuffer::writeIdentifier);
        buf.writeLong(this.gameTimeAdded);
    }

    @Override
    public void read(BitBuffer buf, GearDataVersion version) {
        super.read(buf, version);
        this.rolledTier = buf.readInt();
        this.legendary = buf.readBoolean();
        this.modifierGroup = buf.readString();
        this.modifierIdentifier = buf.readNullable(BitBuffer::readIdentifier);
        this.gameTimeAdded = buf.readLong();
    }

    @Override
    public void toNbt(CompoundTag tag) {
        super.toNbt(tag);
        tag.m_128405_("rolledTier", this.rolledTier);
        tag.m_128379_("legendary", this.legendary);
        tag.m_128359_("modifierGroup", this.modifierGroup);
        if (this.modifierIdentifier != null) {
            tag.m_128359_("modifierIdentifier", this.modifierIdentifier.toString());
        }
        tag.m_128356_("gameTimeAdded", this.gameTimeAdded);
    }

    @Override
    protected void fromNbt(CompoundTag tag, GearDataVersion version) {
        super.fromNbt(tag, version);
        this.rolledTier = tag.m_128451_("rolledTier");
        this.legendary = tag.m_128471_("legendary");
        this.modifierGroup = tag.m_128461_("modifierGroup");
        if (tag.m_128425_("modifierIdentifier", 8)) {
            this.modifierIdentifier = new ResourceLocation(tag.m_128461_("modifierIdentifier"));
        }
        this.gameTimeAdded = tag.m_128454_("gameTimeAdded");
    }

    @Override
    public JsonObject serialize(AffixType type) {
        JsonObject obj = super.serialize(type);
        obj.addProperty("legendary", Boolean.valueOf(this.legendary));
        return obj;
    }

    public static enum AffixType {
        IMPLICIT("Implicits", isPositive -> ""),
        PREFIX("Prefixes", isPositive -> isPositive != false ? "+" : "-"),
        SUFFIX("Suffixes", isPositive -> isPositive != false ? "+" : "-");

        private final String displayName;
        private final Function<Boolean, String> affixPrefix;

        private AffixType(String displayName, Function<Boolean, String> affixPrefix) {
            this.displayName = displayName;
            this.affixPrefix = affixPrefix;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getAffixPrefix(boolean isPositive) {
            return this.affixPrefix.apply(isPositive);
        }
    }
}

