/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear;

import iskallia.vault.VaultMod;
import iskallia.vault.config.gear.VaultGearTagConfig;
import iskallia.vault.config.gear.VaultGearTierConfig;
import iskallia.vault.core.util.WeightedList;
import iskallia.vault.gear.VaultGearClassification;
import iskallia.vault.gear.VaultGearRarity;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.util.MiscUtils;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Random;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;

public class VaultGearModifierHelper {
    public static void reForgeAllModifiers(ItemStack stack, Random random) {
        VaultGearModifierHelper.removeAllModifiers(stack);
        VaultGearModifierHelper.generateModifiers(stack, random);
    }

    public static void reForgeAllImplicits(ItemStack stack, Random random) {
        VaultGearModifierHelper.removeAllImplicits(stack);
        VaultGearModifierHelper.generateImplicits(stack, random);
    }

    public static boolean reForgeAllWithTag(VaultGearTagConfig.ModGroupTag modGroupTag, ItemStack stack, Random random) {
        ItemStack emptyCopy = stack.m_41777_();
        VaultGearModifierHelper.removeAllModifiers(emptyCopy);
        if (VaultGearModifierHelper.getAvailableModGroupOutcomes(modGroupTag, emptyCopy).isEmpty()) {
            return false;
        }
        VaultGearModifierHelper.removeAllModifiers(stack);
        if (!VaultGearModifierHelper.addNewModifierOfGroup(modGroupTag, stack, random)) {
            return false;
        }
        VaultGearModifierHelper.generateModifiers(stack, random);
        return true;
    }

    public static boolean addNewModifierOfGroup(VaultGearTagConfig.ModGroupTag modGroupTag, ItemStack stack, Random random) {
        WeightedList<TierGroupOutcome> outcomes = VaultGearModifierHelper.getAvailableModGroupOutcomes(modGroupTag, stack);
        TierGroupOutcome outcome = outcomes.getRandom(random).orElse(null);
        if (outcome == null) {
            return false;
        }
        VaultGearData data = VaultGearData.read(stack);
        data.addModifier(outcome.type(), outcome.tier().makeModifier(outcome.tierGroup(), random));
        data.write(stack);
        return true;
    }

    private static WeightedList<TierGroupOutcome> getAvailableModGroupOutcomes(VaultGearTagConfig.ModGroupTag modGroupTag, ItemStack stack) {
        boolean generateSuffixes;
        WeightedList<TierGroupOutcome> groupOutcomes = new WeightedList<TierGroupOutcome>();
        VaultGearTierConfig cfg = VaultGearTierConfig.getConfig(stack.m_41720_()).orElse(null);
        if (cfg == null) {
            return groupOutcomes;
        }
        VaultGearData data = VaultGearData.read(stack);
        int itemLevel = data.getItemLevel();
        Set<String> existingGroups = data.getExistingModifierGroups();
        boolean generatePrefixes = data.getFirstValue(ModGearAttributes.PREFIXES).orElse(0) > data.getModifiers(VaultGearModifier.AffixType.PREFIX).size();
        boolean bl = generateSuffixes = data.getFirstValue(ModGearAttributes.SUFFIXES).orElse(0) > data.getModifiers(VaultGearModifier.AffixType.SUFFIX).size();
        if (!generatePrefixes && !generateSuffixes) {
            return groupOutcomes;
        }
        modGroupTag.getGroups().forEach(group -> {
            if (existingGroups.contains(group)) {
                return;
            }
            cfg.getModifierGroupConfigurations((String)group).forEach(tpl -> {
                VaultGearModifier.AffixType type = (VaultGearModifier.AffixType)((Object)((Object)((Object)tpl.m_14418_())));
                if (type == VaultGearModifier.AffixType.PREFIX && !generatePrefixes) {
                    return;
                }
                if (type == VaultGearModifier.AffixType.SUFFIX && !generateSuffixes) {
                    return;
                }
                ((VaultGearTierConfig.ModifierTierGroup)tpl.m_14419_()).getModifiersForLevel(itemLevel).forEach(tier -> groupOutcomes.add(new TierGroupOutcome(type, (VaultGearTierConfig.ModifierTierGroup)tpl.m_14419_(), (VaultGearTierConfig.ModifierTier<?>)tier), tier.getWeight()));
            });
        });
        return groupOutcomes;
    }

    public static boolean reForgeTierOfRandomModifier(ItemStack stack, long worldGameTime, Random random) {
        VaultGearData data = VaultGearData.read(stack);
        VaultGearTierConfig cfg = VaultGearTierConfig.getConfig(stack.m_41720_()).orElse(null);
        if (cfg == null) {
            VaultMod.LOGGER.error("Unknown VaultGear: " + stack);
            return false;
        }
        int itemLevel = data.getItemLevel();
        ArrayList modifierReplacements = new ArrayList();
        data.getModifiers(VaultGearModifier.AffixType.PREFIX).forEach(modifier -> {
            VaultGearModifier<?> randomNew = cfg.generateModifier(modifier.getModifierIdentifier(), itemLevel, random);
            if (randomNew != null && modifier.getModifierIdentifier().equals((Object)randomNew.getModifierIdentifier())) {
                modifierReplacements.add(new Tuple(modifier, randomNew));
            }
        });
        data.getModifiers(VaultGearModifier.AffixType.SUFFIX).forEach(modifier -> {
            VaultGearModifier<?> randomNew = cfg.generateModifier(modifier.getModifierIdentifier(), itemLevel, random);
            if (randomNew != null && modifier.getModifierIdentifier().equals((Object)randomNew.getModifierIdentifier())) {
                modifierReplacements.add(new Tuple(modifier, randomNew));
            }
        });
        Tuple replacement = (Tuple)MiscUtils.getRandomEntry(modifierReplacements, random);
        if (replacement == null) {
            return false;
        }
        VaultGearModifier existing = (VaultGearModifier)replacement.m_14418_();
        VaultGearModifier newModifier = (VaultGearModifier)replacement.m_14419_();
        existing.setValue(newModifier.getValue());
        existing.setRolledTier(newModifier.getRolledTier());
        existing.setGameTimeAdded(worldGameTime);
        existing.setLegendary(false);
        return true;
    }

    public static boolean addNewModifier(ItemStack stack, long worldGameTime, Random random) {
        VaultGearData data = VaultGearData.read(stack);
        VaultGearTierConfig cfg = VaultGearTierConfig.getConfig(stack.m_41720_()).orElse(null);
        if (cfg == null) {
            VaultMod.LOGGER.error("Unknown VaultGear: " + stack);
            return false;
        }
        int itemLevel = data.getItemLevel();
        int prefixes = data.getFirstValue(ModGearAttributes.PREFIXES).orElse(0);
        int suffixes = data.getFirstValue(ModGearAttributes.SUFFIXES).orElse(0);
        if ((prefixes -= data.getModifiers(VaultGearModifier.AffixType.PREFIX).size()) <= 0 && (suffixes -= data.getModifiers(VaultGearModifier.AffixType.SUFFIX).size()) <= 0) {
            return false;
        }
        ArrayList<VaultGearModifier.AffixType> types = new ArrayList<VaultGearModifier.AffixType>();
        if (prefixes > 0) {
            types.add(VaultGearModifier.AffixType.PREFIX);
        }
        if (suffixes > 0) {
            types.add(VaultGearModifier.AffixType.SUFFIX);
        }
        VaultGearModifier.AffixType type = (VaultGearModifier.AffixType)((Object)MiscUtils.getRandomEntry(types, random));
        cfg.getRandomModifier(type, itemLevel, random, data.getExistingModifierGroups()).ifPresent(modifier -> {
            data.getAllModifierAffixes().forEach(VaultGearModifier::resetGameTimeAdded);
            modifier.setGameTimeAdded(worldGameTime);
            data.addModifier(type, (VaultGearModifier<?>)modifier);
        });
        data.write(stack);
        return true;
    }

    public static boolean removeRandomModifier(ItemStack stack, Random random) {
        VaultGearData data = VaultGearData.read(stack);
        int prefixes = data.getModifiers(VaultGearModifier.AffixType.PREFIX).size();
        int suffixes = data.getModifiers(VaultGearModifier.AffixType.SUFFIX).size();
        if (prefixes <= 0 && suffixes <= 0) {
            return false;
        }
        ArrayList<VaultGearModifier.AffixType> types = new ArrayList<VaultGearModifier.AffixType>();
        if (prefixes > 0) {
            types.add(VaultGearModifier.AffixType.PREFIX);
        }
        if (suffixes > 0) {
            types.add(VaultGearModifier.AffixType.SUFFIX);
        }
        VaultGearModifier.AffixType type = (VaultGearModifier.AffixType)((Object)MiscUtils.getRandomEntry(types, random));
        VaultGearModifier<?> randomMod = MiscUtils.getRandomEntry(data.getModifiers(type), random);
        data.removeModifier(randomMod);
        data.write(stack);
        return true;
    }

    public static void removeAllModifiers(ItemStack stack) {
        VaultGearData data = VaultGearData.read(stack);
        new ArrayList(data.getModifiers(VaultGearModifier.AffixType.PREFIX)).forEach((Consumer<VaultGearModifier<?>>)((Consumer<VaultGearModifier>)data::removeModifier));
        new ArrayList(data.getModifiers(VaultGearModifier.AffixType.SUFFIX)).forEach((Consumer<VaultGearModifier<?>>)((Consumer<VaultGearModifier>)data::removeModifier));
        data.write(stack);
    }

    public static void removeAllImplicits(ItemStack stack) {
        VaultGearData data = VaultGearData.read(stack);
        new ArrayList(data.getModifiers(VaultGearModifier.AffixType.IMPLICIT)).forEach((Consumer<VaultGearModifier<?>>)((Consumer<VaultGearModifier>)data::removeModifier));
        data.write(stack);
    }

    public static boolean generateLegendaryModifier(ItemStack stack, Random random) {
        VaultGearData data = VaultGearData.read(stack);
        VaultGearTierConfig cfg = VaultGearTierConfig.getConfig(stack.m_41720_()).orElse(null);
        if (cfg == null) {
            VaultMod.LOGGER.error("Unknown VaultGear: " + stack);
            return false;
        }
        ArrayList<Tuple> modifiers = new ArrayList<Tuple>();
        data.getModifiers(VaultGearModifier.AffixType.PREFIX).forEach(modifier -> modifiers.add(new Tuple((Object)VaultGearModifier.AffixType.PREFIX, modifier)));
        data.getModifiers(VaultGearModifier.AffixType.SUFFIX).forEach(modifier -> modifiers.add(new Tuple((Object)VaultGearModifier.AffixType.SUFFIX, modifier)));
        modifiers.removeIf(tpl -> cfg.getAllTiers(((VaultGearModifier)tpl.m_14419_()).getModifierIdentifier()).size() <= 1);
        Tuple randomMod = (Tuple)MiscUtils.getRandomEntry(modifiers, random);
        if (randomMod == null) {
            return false;
        }
        VaultGearModifier<?> newMod = cfg.maxAndIncreaseTier((VaultGearModifier.AffixType)((Object)randomMod.m_14418_()), (VaultGearModifier)randomMod.m_14419_(), data.getItemLevel(), 2, random);
        if (newMod == null) {
            return false;
        }
        newMod.setLegendary(true);
        if (data.removeModifier((VaultGearModifier)randomMod.m_14419_())) {
            data.addModifier((VaultGearModifier.AffixType)((Object)randomMod.m_14418_()), newMod, Deque::addFirst);
        }
        data.write(stack);
        return true;
    }

    public static void generateAffixSlots(ItemStack stack, Random random) {
        VaultGearData data = VaultGearData.read(stack);
        Object item = VaultGearItem.of(stack);
        VaultGearRarity rarity = data.getRarity();
        VaultGearClassification classification = item.getClassification(stack);
        int modifierCount = classification.getModifierCount(rarity);
        int prefixes = modifierCount / 2;
        int suffixes = modifierCount / 2;
        if (rarity.getArmorModifierCount() - prefixes - suffixes > 0) {
            if (random.nextBoolean()) {
                ++prefixes;
            } else {
                ++suffixes;
            }
        }
        if (classification == VaultGearClassification.IDOL) {
            prefixes = 0;
            suffixes = classification.getModifierCount(rarity);
        }
        data.updateAttribute(ModGearAttributes.PREFIXES, prefixes);
        data.updateAttribute(ModGearAttributes.SUFFIXES, suffixes);
        data.write(stack);
    }

    public static void generateImplicits(ItemStack stack, Random random) {
        VaultGearData data = VaultGearData.read(stack);
        VaultGearTierConfig cfg = VaultGearTierConfig.getConfig(stack.m_41720_()).orElse(null);
        if (cfg == null) {
            VaultMod.LOGGER.error("Unknown VaultGear: " + stack);
            return;
        }
        int itemLevel = data.getItemLevel();
        cfg.generateImplicits(itemLevel, random).forEach(modifier -> data.addModifier(VaultGearModifier.AffixType.IMPLICIT, (VaultGearModifier<?>)modifier));
        data.write(stack);
    }

    public static void reRollRepairSlots(ItemStack stack, Random random) {
        VaultGearData data = VaultGearData.read(stack);
        int repairs = 2 + random.nextInt(4);
        data.setRepairSlots(repairs);
        data.write(stack);
    }

    public static void generateModifiers(ItemStack stack, Random random) {
        VaultGearData data = VaultGearData.read(stack);
        VaultGearTierConfig cfg = VaultGearTierConfig.getConfig(stack.m_41720_()).orElse(null);
        if (cfg == null) {
            VaultMod.LOGGER.error("Unknown VaultGear: " + stack);
            return;
        }
        int itemLevel = data.getItemLevel();
        int maxPrefixes = data.getFirstValue(ModGearAttributes.PREFIXES).orElse(0) - data.getModifiers(VaultGearModifier.AffixType.PREFIX).size();
        int maxSuffixes = data.getFirstValue(ModGearAttributes.SUFFIXES).orElse(0) - data.getModifiers(VaultGearModifier.AffixType.SUFFIX).size();
        int generatedModifiers = VaultGearModifierHelper.getGeneratedModifierCount(maxPrefixes + maxSuffixes, random);
        int rolledPrefixes = 0;
        int rolledSuffixes = 0;
        for (int i = 0; i < generatedModifiers; ++i) {
            VaultGearModifier modifier;
            VaultGearModifier.AffixType type;
            ArrayList<VaultGearModifier.AffixType> types = new ArrayList<VaultGearModifier.AffixType>();
            if (rolledPrefixes < maxPrefixes) {
                types.add(VaultGearModifier.AffixType.PREFIX);
            }
            if (rolledSuffixes < maxSuffixes) {
                types.add(VaultGearModifier.AffixType.SUFFIX);
            }
            if ((type = (VaultGearModifier.AffixType)((Object)MiscUtils.getRandomEntry(types, random))) == null || (modifier = (VaultGearModifier)cfg.getRandomModifier(type, itemLevel, random, data.getExistingModifierGroups()).orElse(null)) == null) continue;
            data.addModifier(type, modifier);
            if (type == VaultGearModifier.AffixType.PREFIX) {
                ++rolledPrefixes;
                continue;
            }
            ++rolledSuffixes;
        }
        data.write(stack);
    }

    private static int getGeneratedModifierCount(int modifierCount, Random random) {
        return Math.round((float)modifierCount * 0.6f + (float)modifierCount * 0.4f * random.nextFloat());
    }

    private record TierGroupOutcome(VaultGearModifier.AffixType type, VaultGearTierConfig.ModifierTierGroup tierGroup, VaultGearTierConfig.ModifierTier<?> tier) {
    }
}

