/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear;

import iskallia.vault.gear.VaultGearModifierHelper;
import iskallia.vault.gear.VaultGearRarity;
import iskallia.vault.gear.VaultGearState;
import iskallia.vault.gear.crafting.VaultGearCraftingHelper;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModItems;
import iskallia.vault.init.ModSounds;
import iskallia.vault.world.data.DiscoveredModelsData;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class GearRollHelper {
    private static final Random rand = new Random();
    private static final int ROLL_TIME = 120;
    private static final int ENTRIES_PER_ROLL = 50;

    public static void tickRollVaultGear(ItemStack stack, ServerPlayer player) {
        if (VaultGearData.read(stack).getState() != VaultGearState.ROLLING) {
            return;
        }
        GearRollHelper.tickToll(stack, player, inStack -> {
            VaultGearData data = VaultGearData.read(inStack);
            Object item = VaultGearItem.of(inStack);
            VaultGearRarity rarity = data.getFirstValue(ModGearAttributes.GEAR_ROLL_TYPE).flatMap(rollTypeStr -> ModConfigs.VAULT_GEAR_TYPE_CONFIG.getRollPool((String)rollTypeStr)).orElse(ModConfigs.VAULT_GEAR_TYPE_CONFIG.getDefaultRoll()).getRandom(rand);
            data.setRarity(rarity);
            data.write((ItemStack)inStack);
            ResourceLocation modelKey = item.getRandomModel((ItemStack)inStack, rand);
            if (modelKey != null) {
                data.updateAttribute(ModGearAttributes.GEAR_MODEL, modelKey);
            }
            data.write((ItemStack)inStack);
        }, inStack -> {
            VaultGearData data = VaultGearData.read(inStack);
            data.setState(VaultGearState.IDENTIFIED);
            data.write((ItemStack)inStack);
            VaultGearModifierHelper.reRollRepairSlots(inStack, rand);
            VaultGearCraftingHelper.reRollCraftingPotential(inStack);
            VaultGearModifierHelper.generateAffixSlots(inStack, rand);
            VaultGearModifierHelper.generateImplicits(inStack, rand);
            VaultGearModifierHelper.generateModifiers(inStack, rand);
            if (data.getFirstValue(ModGearAttributes.IS_LOOT).orElse(false).booleanValue() && rand.nextFloat() < ModConfigs.VAULT_GEAR_CRAFTING_CONFIG.getLegendaryModifierChance()) {
                VaultGearModifierHelper.generateLegendaryModifier(inStack, rand);
            }
            DiscoveredModelsData worldData = DiscoveredModelsData.get(player.m_183503_().m_142572_());
            worldData.discoverModelAndBroadcast((ItemStack)inStack, (Player)player);
        });
    }

    public static void tickToll(ItemStack stack, ServerPlayer player, Consumer<ItemStack> onRollTick, Consumer<ItemStack> onFinish) {
        ServerLevel world = player.m_183503_();
        CompoundTag rollTag = stack.m_41698_("RollHelper");
        int ticks = rollTag.m_128451_("RollTicks");
        int lastHit = rollTag.m_128451_("LastHit");
        double displacement = GearRollHelper.getDisplacement(ticks);
        if (ticks >= 120 || player.m_21120_(InteractionHand.OFF_HAND).m_41720_() == ModItems.IDENTIFICATION_TOME) {
            if (ticks == 0) {
                onRollTick.accept(stack);
            }
            onFinish.accept(stack);
            stack.m_41749_("RollHelper");
            world.m_5594_(null, player.m_142538_(), ModSounds.CONFETTI_SFX, SoundSource.PLAYERS, 0.3f, 1.0f);
            return;
        }
        if ((int)displacement != lastHit || ticks == 0) {
            onRollTick.accept(stack);
            rollTag.m_128405_("LastHit", (int)displacement);
            world.m_5594_(null, player.m_142538_(), ModSounds.RAFFLE_SFX, SoundSource.PLAYERS, 0.4f, 1.0f);
        }
        rollTag.m_128405_("RollTicks", ticks + 1);
    }

    private static double getDisplacement(int tick) {
        double c = 7200.0;
        return ((double)(-tick * tick * tick) / 6.0 + c * (double)tick) * 50.0 / (-288000.0 + c * 120.0);
    }
}

