/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.event;

import iskallia.vault.etching.EtchingRegistry;
import iskallia.vault.etching.EtchingSet;
import iskallia.vault.gear.attribute.VaultGearAttribute;
import iskallia.vault.gear.attribute.VaultGearAttributeRegistry;
import iskallia.vault.gear.modification.GearModification;
import iskallia.vault.gear.modification.GearModificationRegistry;
import iskallia.vault.gear.trinket.TrinketEffect;
import iskallia.vault.gear.trinket.TrinketEffectRegistry;
import iskallia.vault.init.ModAbilities;
import iskallia.vault.init.ModArchetypes;
import iskallia.vault.init.ModAttributes;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModContainers;
import iskallia.vault.init.ModDynamicModels;
import iskallia.vault.init.ModEffects;
import iskallia.vault.init.ModEntities;
import iskallia.vault.init.ModEtchings;
import iskallia.vault.init.ModFeatures;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModGearModifications;
import iskallia.vault.init.ModItems;
import iskallia.vault.init.ModModels;
import iskallia.vault.init.ModRecipes;
import iskallia.vault.init.ModShaders;
import iskallia.vault.init.ModSounds;
import iskallia.vault.init.ModStructures;
import iskallia.vault.init.ModTrinkets;
import iskallia.vault.skill.archetype.AbstractArchetype;
import iskallia.vault.skill.archetype.ArchetypeRegistry;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.RegisterShadersEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.NewRegistryEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class RegistryEvents {
    @SubscribeEvent
    public static void onNewRegistryRegister(NewRegistryEvent event) {
        VaultGearAttributeRegistry.buildRegistry(event);
        EtchingRegistry.buildRegistry(event);
        TrinketEffectRegistry.buildRegistry(event);
        GearModificationRegistry.buildRegistry(event);
        ArchetypeRegistry.buildRegistry(event);
    }

    @SubscribeEvent
    public static void onBlockRegister(RegistryEvent.Register<Block> event) {
        ModConfigs.registerCompressionConfigs();
        ModBlocks.registerBlocks(event);
    }

    @SubscribeEvent
    public static void onItemRegister(RegistryEvent.Register<Item> event) {
        ModConfigs.registerCompressionConfigs();
        ModItems.registerItems(event);
        ModDynamicModels.initItemAssociations();
        ModDynamicModels.initCauldronWashables();
        ModBlocks.registerBlockItems(event);
        ModAbilities.init();
    }

    @SubscribeEvent
    public static void onModelRegister(ModelRegistryEvent event) {
        ModModels.setupRenderLayers();
        ModModels.ItemProperty.register();
        ModModels.ItemProperty.registerOverrides();
    }

    @SubscribeEvent
    public static void ohRegisterRenderers(EntityRenderersEvent.RegisterRenderers event) {
        ModBlocks.registerTileEntityRenderers(event);
    }

    @SubscribeEvent
    public static void onRegisterShaders(RegisterShadersEvent event) {
        ModShaders.register(event);
    }

    @SubscribeEvent
    public static void onSoundRegister(RegistryEvent.Register<SoundEvent> event) {
        ModSounds.registerSounds(event);
    }

    @SubscribeEvent
    public static void onStructureRegister(RegistryEvent.Register<StructureFeature<?>> event) {
        ModStructures.register(event);
        ModFeatures.registerStructureFeatures();
    }

    @SubscribeEvent
    public static void onFeatureRegister(RegistryEvent.Register<Feature<?>> event) {
        ModFeatures.registerFeatures(event);
    }

    @SubscribeEvent
    public static void onContainerRegister(RegistryEvent.Register<MenuType<?>> event) {
        ModContainers.register(event);
    }

    @SubscribeEvent
    public static void onEntityRegister(RegistryEvent.Register<EntityType<?>> event) {
        ModEntities.register(event);
    }

    @SubscribeEvent
    public static void onTileEntityRegister(RegistryEvent.Register<BlockEntityType<?>> event) {
        ModBlocks.registerTileEntities(event);
    }

    @SubscribeEvent
    public static void onRecipeRegister(RegistryEvent.Register<RecipeSerializer<?>> event) {
        ModRecipes.Serializer.register(event);
    }

    @SubscribeEvent
    public static void onEffectRegister(RegistryEvent.Register<MobEffect> event) {
        ModEffects.register(event);
        MobEffects.f_19598_.m_19485_().clear();
    }

    @SubscribeEvent
    public static void onAttributeRegister(RegistryEvent.Register<Attribute> event) {
        RangedAttribute attr;
        Attribute attribute = Attributes.f_22276_;
        if (attribute instanceof RangedAttribute) {
            attr = (RangedAttribute)attribute;
            attr.f_22308_ = Double.MAX_VALUE;
        }
        if ((attribute = Attributes.f_22284_) instanceof RangedAttribute) {
            attr = (RangedAttribute)attribute;
            attr.f_22308_ = Double.MAX_VALUE;
        }
        ModAttributes.register(event);
    }

    @SubscribeEvent
    public static void onGearAttributeRegistry(RegistryEvent.Register<VaultGearAttribute<?>> event) {
        ModGearAttributes.init(event);
        ModGearAttributes.registerVanillaAssociations();
    }

    @SubscribeEvent
    public static void onEtchingRegistry(RegistryEvent.Register<EtchingSet<?>> event) {
        ModEtchings.init(event);
    }

    @SubscribeEvent
    public static void onTrinketRegistry(RegistryEvent.Register<TrinketEffect<?>> event) {
        ModTrinkets.init(event);
    }

    @SubscribeEvent
    public static void onModificationRegistry(RegistryEvent.Register<GearModification> event) {
        ModGearModifications.init(event);
    }

    @SubscribeEvent
    public static void onArchetypesRegistry(RegistryEvent.Register<AbstractArchetype<?>> event) {
        ModArchetypes.init(event);
    }
}

