/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.event;

import iskallia.vault.VaultMod;
import iskallia.vault.block.entity.VaultChestTileEntity;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.entity.entity.EternalEntity;
import iskallia.vault.entity.entity.FighterEntity;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.gear.trinket.TrinketHelper;
import iskallia.vault.gear.trinket.effects.DamageImmunityTrinket;
import iskallia.vault.init.ModAttributes;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModItems;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.init.ModSounds;
import iskallia.vault.item.AnimalJarItem;
import iskallia.vault.item.gear.TrinketItem;
import iskallia.vault.mana.Mana;
import iskallia.vault.network.message.FighterSizeMessage;
import iskallia.vault.network.message.InvalidConfigsMessage;
import iskallia.vault.util.AdvancementHelper;
import iskallia.vault.util.EntityHelper;
import iskallia.vault.util.VHSmpUtil;
import iskallia.vault.util.VaultRarity;
import iskallia.vault.world.data.PlayerVaultStatsData;
import iskallia.vault.world.data.ServerVaults;
import iskallia.vault.world.data.VaultCharmData;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkDirection;
import top.theillusivec4.curios.api.event.CurioEquipEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PlayerEvents {
    @SubscribeEvent
    public static void onStartTracking(PlayerEvent.StartTracking event) {
        Entity target = event.getTarget();
        if (target.f_19853_.f_46443_) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.getPlayer();
        if (target instanceof FighterEntity) {
            ModNetwork.CHANNEL.sendTo((Object)new FighterSizeMessage(target, ((FighterEntity)target).sizeMultiplier), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
        if (target instanceof EternalEntity) {
            ModNetwork.CHANNEL.sendTo((Object)new FighterSizeMessage(target, ((EternalEntity)target).sizeMultiplier), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    @SubscribeEvent
    public static void onAttack(AttackEntityEvent event) {
        VaultGearData data;
        Player attacker = event.getPlayer();
        if (attacker.f_19853_.m_5776_()) {
            return;
        }
        int playerLevel = PlayerVaultStatsData.get((ServerLevel)attacker.f_19853_).getVaultStats(attacker).getVaultLevel();
        ItemStack stack = attacker.m_21205_();
        if (stack.m_41720_() instanceof VaultGearItem && playerLevel < (data = VaultGearData.read(stack)).getItemLevel()) {
            event.setCanceled(true);
            return;
        }
        Entity entity = event.getTarget();
        if (entity instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            EntityHelper.getNearby((LevelAccessor)attacker.f_19853_, (Vec3i)attacker.m_142538_(), 9.0f, EternalEntity.class).forEach(eternal -> eternal.m_6710_(target));
        }
    }

    @SubscribeEvent
    public static void customTrinketCurioEquip(CurioEquipEvent event) {
        ItemStack stack = event.getStack();
        Item item = stack.m_41720_();
        if (!(item instanceof TrinketItem)) {
            return;
        }
        TrinketItem trinketItem = (TrinketItem)item;
        if (trinketItem.canEquip(event.getSlotContext(), stack)) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public static void playerImmuneInFinishedVault(LivingHurtEvent event) {
        Entity target = event.getEntity();
        if (!(target instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)target;
        ServerVaults.get((Level)player.m_183503_()).ifPresent(vault -> {
            if (vault.has(Vault.FINISHED)) {
                event.setCanceled(true);
            }
        });
    }

    @SubscribeEvent
    public static void onPlayerTick2(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (player.m_6060_()) {
            if (player.m_21023_(MobEffects.f_19607_)) {
                player.m_20095_();
            }
            if (TrinketHelper.getTrinkets((LivingEntity)player, DamageImmunityTrinket.class).stream().map(TrinketHelper.TrinketStack::trinket).anyMatch(DamageImmunityTrinket::isFireDamage)) {
                player.m_20095_();
            }
        }
        if (player.m_21223_() > player.m_21233_()) {
            player.m_21153_(player.m_21233_());
            if (player instanceof ServerPlayer) {
                ServerPlayer sPlayer = (ServerPlayer)player;
                sPlayer.f_8917_ = player.m_21223_();
            }
        }
    }

    @SubscribeEvent
    public static void itemInteractionForEntity(PlayerInteractEvent.EntityInteract event) {
        Entity entity;
        Player player;
        if (!event.getWorld().m_5776_() && event.getTarget() instanceof Animal && !(event.getTarget() instanceof Player) && (player = event.getPlayer()).m_6047_() && player.m_21120_(event.getHand()).m_41720_() == ModItems.ANIMAL_JAR && (entity = event.getTarget()) instanceof Animal) {
            Horse horse;
            TamableAnimal tamableAnimal;
            Animal animal = (Animal)entity;
            if (!AnimalJarItem.canAddEntity(event.getItemStack(), (LivingEntity)animal)) {
                player.m_5661_((Component)new TextComponent("Cannot add to jar."), true);
                return;
            }
            if (animal.m_6162_()) {
                player.m_5661_((Component)new TextComponent("This animal is too small to fit in this jar.."), true);
                return;
            }
            Entity entity2 = event.getTarget();
            if (entity2 instanceof TamableAnimal && (tamableAnimal = (TamableAnimal)entity2).m_142480_() != null) {
                player.m_5661_((Component)new TextComponent("Cannot jar up tamed animals"), true);
                return;
            }
            entity2 = event.getTarget();
            if (entity2 instanceof Horse && (horse = (Horse)entity2).m_30614_()) {
                player.m_5661_((Component)new TextComponent("Cannot jar up tamed animals"), true);
                return;
            }
            if (player.m_21120_(event.getHand()).m_41613_() > 1) {
                ItemStack jar = event.getItemStack().m_41777_();
                event.getItemStack().m_41774_(1);
                jar.m_41764_(1);
                ItemStack output = AnimalJarItem.AddEntity(jar, (LivingEntity)animal);
                player.m_150109_().m_36054_(output);
            } else {
                AnimalJarItem.AddEntity(event.getItemStack(), (LivingEntity)animal);
            }
        }
    }

    @SubscribeEvent
    public static void fillLootOnBreak(BlockEvent.BreakEvent event) {
        if (event.getWorld().m_5776_() || !(event.getWorld() instanceof ServerLevel)) {
            return;
        }
        BlockEntity tile = event.getWorld().m_7702_(event.getPos());
        if (tile instanceof RandomizableContainerBlockEntity) {
            if (tile instanceof VaultChestTileEntity) {
                ((VaultChestTileEntity)tile).generateChestLoot(event.getPlayer(), true);
            } else {
                ((RandomizableContainerBlockEntity)tile).m_59640_(event.getPlayer());
            }
        }
        if (tile instanceof VaultChestTileEntity) {
            Random rand = event.getWorld().m_5822_();
            VaultRarity rarity = ((VaultChestTileEntity)tile).getRarity();
            if (rarity == VaultRarity.EPIC) {
                event.getWorld().m_5594_(null, event.getPos(), ModSounds.VAULT_CHEST_EPIC_OPEN, SoundSource.BLOCKS, 0.5f, rand.nextFloat() * 0.1f + 0.9f);
            } else if (rarity == VaultRarity.OMEGA) {
                event.getWorld().m_5594_(null, event.getPos(), ModSounds.VAULT_CHEST_OMEGA_OPEN, SoundSource.BLOCKS, 0.5f, rand.nextFloat() * 0.1f + 0.9f);
            } else if (rarity == VaultRarity.RARE) {
                event.getWorld().m_5594_(null, event.getPos(), ModSounds.VAULT_CHEST_RARE_OPEN, SoundSource.BLOCKS, 0.5f, rand.nextFloat() * 0.1f + 0.9f);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void hideIdolRegistryName(ItemTooltipEvent event) {
        if (Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91074_.m_7500_()) {
            return;
        }
        for (int i = 0; i < event.getToolTip().size(); ++i) {
            Component txt = (Component)event.getToolTip().get(i);
            if (!txt.getString().contains("the_vault:idol")) continue;
            event.getToolTip().set(i, new TextComponent("the_vault:idol").m_6270_(txt.m_7383_()));
        }
    }

    @SubscribeEvent
    public static void onPlayerEnterVault(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getPlayer();
        if (ServerVaults.isVaultWorld((ResourceKey<Level>)event.getTo()) && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            AdvancementHelper.grantCriterion(serverPlayer, VaultMod.id("main/root"), "entered_vault");
            AdvancementHelper.grantCriterion(serverPlayer, VaultMod.id("armors/root"), "entered_vault");
        }
    }

    @SubscribeEvent
    public static void onVaultCharmUse(EntityItemPickupEvent event) {
        Player player = event.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        ItemEntity itemEntity = event.getItem();
        ItemStack stack = itemEntity.m_32055_();
        if (stack.m_41619_()) {
            return;
        }
        ServerLevel world = player2.m_183503_();
        if (!ServerVaults.isVaultWorld((Level)world)) {
            return;
        }
        if (!PlayerEvents.hasVaultCharm(player2.m_150109_())) {
            return;
        }
        List<ResourceLocation> whitelist = VaultCharmData.get(world).getWhitelistedItems(player2);
        if (whitelist.contains(stack.m_41720_().getRegistryName())) {
            event.setCanceled(true);
            itemEntity.m_142687_(Entity.RemovalReason.DISCARDED);
            world.m_5594_(null, player2.m_142538_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, (world.f_46441_.nextFloat() - world.f_46441_.nextFloat()) * 1.4f + 2.0f);
        }
    }

    private static boolean hasVaultCharm(Inventory inventory) {
        for (int slot = 0; slot < inventory.m_6643_(); ++slot) {
            ItemStack stack = inventory.m_8020_(slot);
            if (stack.m_41619_() || stack.m_41720_() != ModItems.VAULT_CHARM) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public static void onManaRegen(TickEvent.PlayerTickEvent event) {
        if (event.side != LogicalSide.SERVER || event.phase != TickEvent.Phase.START) {
            return;
        }
        event.player.m_21051_(ModAttributes.MANA_MAX).m_22100_((double)ModConfigs.MANA.getManaMax());
        event.player.m_21051_(ModAttributes.MANA_REGEN).m_22100_((double)ModConfigs.MANA.getManaRegenPerSecond());
        if (VHSmpUtil.isArenaWorld((Entity)event.player)) {
            return;
        }
        Mana.increase(event.player, Mana.getRegenPerSecond(event.player) * 0.05f);
    }

    @SubscribeEvent
    public static void onInvalidConfigs(PlayerEvent.PlayerLoggedInEvent event) {
        if (ModConfigs.INVALID_CONFIGS.isEmpty()) {
            return;
        }
        Player player = event.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ModNetwork.CHANNEL.sendTo((Object)new InvalidConfigsMessage(ModConfigs.INVALID_CONFIGS), serverPlayer.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPlayerDrops(LivingDropsEvent event) {
        Player player;
        Entity entity = event.getEntity();
        if (entity instanceof Player && ServerVaults.isInVault((Entity)(player = (Player)entity))) {
            event.setCanceled(true);
        }
    }
}

