/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class PlayerActiveFlags {
    private static final Map<UUID, List<FlagTimeout>> timeouts = new HashMap<UUID, List<FlagTimeout>>();

    @SubscribeEvent
    public static void onTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        timeouts.forEach((playerId, flagTimeouts) -> {
            flagTimeouts.forEach(FlagTimeout::tick);
            flagTimeouts.removeIf(FlagTimeout::isFinished);
        });
    }

    public static void set(Player player, Flag flag, int timeout) {
        PlayerActiveFlags.set(player.m_142081_(), flag, timeout);
    }

    public static void set(UUID playerId, Flag flag, int timeout) {
        List flags = timeouts.computeIfAbsent(playerId, id -> new ArrayList());
        for (FlagTimeout flagTimeout : flags) {
            if (flagTimeout.flag != flag) continue;
            flagTimeout.tickTimeout = timeout;
            return;
        }
        flags.add(new FlagTimeout(flag, timeout));
    }

    public static boolean isSet(Player player, Flag flag) {
        return PlayerActiveFlags.isSet(player.m_142081_(), flag);
    }

    public static boolean isSet(UUID playerId, Flag flag) {
        List flags = timeouts.getOrDefault(playerId, Collections.emptyList());
        for (FlagTimeout timeout : flags) {
            if (timeout.flag != flag || timeout.isFinished()) continue;
            return true;
        }
        return false;
    }

    public static enum Flag {
        ATTACK_AOE,
        CHAINING_AOE;

    }

    private static class FlagTimeout {
        private final Flag flag;
        private int tickTimeout;

        private FlagTimeout(Flag flag, int tickTimeout) {
            this.flag = flag;
            this.tickTimeout = tickTimeout;
        }

        private void tick() {
            --this.tickTimeout;
        }

        private boolean isFinished() {
            return this.tickTimeout <= 0;
        }
    }
}

