/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.event;

import iskallia.vault.client.gui.screen.AbilitySelectionScreen;
import iskallia.vault.init.ModKeybinds;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.AbilityQuickselectMessage;
import iskallia.vault.network.message.ServerboundAbilityKeyMessage;
import iskallia.vault.network.message.ServerboundOpenStatisticsMessage;
import iskallia.vault.network.message.bounty.ServerboundBountyProgressMessage;
import java.util.Map;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class InputEvents {
    private static boolean isShiftDown;

    public static boolean isShiftDown() {
        return isShiftDown;
    }

    @SubscribeEvent
    public static void onShiftKey(InputEvent.KeyInputEvent event) {
        if (event.getKey() == 340) {
            if (event.getAction() == 1) {
                isShiftDown = true;
            } else if (event.getAction() == 0) {
                isShiftDown = false;
            }
        }
    }

    @SubscribeEvent
    public static void onKey(InputEvent.KeyInputEvent event) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91073_ == null) {
            return;
        }
        InputEvents.onInput(minecraft, event.getKey(), event.getAction());
    }

    @SubscribeEvent
    public static void onMouse(InputEvent.MouseInputEvent event) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91073_ == null) {
            return;
        }
        InputEvents.onInput(minecraft, event.getButton(), event.getAction());
    }

    private static void onInput(Minecraft minecraft, int key, int action) {
        if (minecraft.f_91080_ != null || key == -1) {
            return;
        }
        for (Map.Entry<String, KeyMapping> quickSelectKeybind : ModKeybinds.abilityQuickfireKey.entrySet()) {
            if (quickSelectKeybind.getValue().getKey().m_84873_() != key) continue;
            if (action != 1) {
                return;
            }
            ModNetwork.CHANNEL.sendToServer((Object)new AbilityQuickselectMessage(quickSelectKeybind.getKey()));
        }
        if (ModKeybinds.abilityWheelKey.getKey().m_84873_() == key) {
            if (action != 1) {
                return;
            }
            minecraft.m_91152_((Screen)new AbilitySelectionScreen());
            ServerboundAbilityKeyMessage.send(ServerboundAbilityKeyMessage.Opcode.CancelKeyDown);
        } else if (ModKeybinds.openAbilityTree.m_90859_()) {
            ModNetwork.CHANNEL.sendToServer((Object)ServerboundOpenStatisticsMessage.INSTANCE);
        } else if (ModKeybinds.abilityKey.getKey().m_84873_() == key) {
            if (action == 0) {
                ServerboundAbilityKeyMessage.send(ServerboundAbilityKeyMessage.Opcode.KeyUp);
            } else if (action == 1) {
                ServerboundAbilityKeyMessage.send(ServerboundAbilityKeyMessage.Opcode.KeyDown);
            }
        } else if (ModKeybinds.bountyStatusKey.getKey().m_84873_() == key) {
            if (action != 1) {
                return;
            }
            ModNetwork.CHANNEL.sendToServer((Object)new ServerboundBountyProgressMessage());
        }
    }

    @SubscribeEvent
    public static void onMouseScroll(InputEvent.MouseScrollEvent event) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91073_ == null) {
            return;
        }
        double scrollDelta = event.getScrollDelta();
        if (ModKeybinds.abilityKey.m_90857_()) {
            if (minecraft.f_91080_ == null) {
                if (scrollDelta < 0.0) {
                    ServerboundAbilityKeyMessage.send(ServerboundAbilityKeyMessage.Opcode.ScrollDown);
                } else {
                    ServerboundAbilityKeyMessage.send(ServerboundAbilityKeyMessage.Opcode.ScrollUp);
                }
            }
            event.setCanceled(true);
        }
    }
}

