/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.event;

import iskallia.vault.entity.entity.EffectCloudEntity;
import iskallia.vault.entity.entity.EternalEntity;
import iskallia.vault.event.ActiveFlags;
import iskallia.vault.event.PlayerActiveFlags;
import iskallia.vault.gear.attribute.type.VaultGearAttributeTypeMerger;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.init.ModDynamicModels;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.snapshot.AttributeSnapshot;
import iskallia.vault.snapshot.AttributeSnapshotHelper;
import iskallia.vault.util.EntityHelper;
import iskallia.vault.util.calc.BlockChanceHelper;
import iskallia.vault.util.calc.ChainHelper;
import iskallia.vault.util.calc.FatalStrikeHelper;
import iskallia.vault.util.calc.GrantedEffectHelper;
import iskallia.vault.util.calc.ThornsHelper;
import iskallia.vault.util.damage.ThornsReflectDamageSource;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class GearAttributeEvents {
    private static final Random rand = new Random();

    @SubscribeEvent
    public static void fireImmunePreventFireDamage(LivingAttackEvent event) {
        if (!event.getSource().m_19384_()) {
            return;
        }
        GearAttributeEvents.withSnapshot((LivingEvent)event, false, (LivingEntity entity, AttributeSnapshot snapshot) -> {
            if (snapshot.getAttributeValue(ModGearAttributes.IS_FIRE_IMMUNE, VaultGearAttributeTypeMerger.anyTrue()).booleanValue()) {
                event.setCanceled(true);
            }
        });
    }

    @SubscribeEvent
    public static void triggerAoEAttack(LivingHurtEvent event) {
        Player player;
        Entity source = event.getSource().m_7639_();
        if (!(source instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)source;
        if (attacker.m_183503_().m_5776_() || !AttributeSnapshotHelper.canHaveSnapshot(attacker)) {
            return;
        }
        if (attacker instanceof Player && PlayerActiveFlags.isSet(player = (Player)attacker, PlayerActiveFlags.Flag.ATTACK_AOE)) {
            return;
        }
        LivingEntity attacked = event.getEntityLiving();
        Level world = attacker.m_183503_();
        AttributeSnapshot snapshot = AttributeSnapshotHelper.getInstance().getSnapshot(attacker);
        int aoeSize = snapshot.getAttributeValue(ModGearAttributes.ON_HIT_AOE, VaultGearAttributeTypeMerger.intSum());
        if (aoeSize <= 0) {
            return;
        }
        ActiveFlags.IS_AOE_ATTACKING.runIfNotSet(() -> {
            List<Mob> nearby = EntityHelper.getNearby((LevelAccessor)world, (Vec3i)attacked.m_142538_(), aoeSize, Mob.class);
            nearby.remove(attacked);
            nearby.remove(attacker);
            nearby.removeIf(mob -> (attacker instanceof EternalEntity || attacker instanceof Player) && mob instanceof EternalEntity);
            nearby.forEach(mob -> mob.m_6469_(event.getSource(), event.getAmount() * 0.6f));
            if (attacker instanceof Player) {
                Player player = (Player)attacker;
                PlayerActiveFlags.set(player, PlayerActiveFlags.Flag.ATTACK_AOE, 2);
            }
        });
    }

    @SubscribeEvent
    public static void triggerChainAttack(LivingHurtEvent event) {
        Player player;
        Entity source = event.getSource().m_7639_();
        if (!(source instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)source;
        if (attacker.m_183503_().m_5776_() || !AttributeSnapshotHelper.canHaveSnapshot(attacker)) {
            return;
        }
        if (attacker instanceof Player && PlayerActiveFlags.isSet(player = (Player)attacker, PlayerActiveFlags.Flag.CHAINING_AOE)) {
            return;
        }
        LivingEntity attacked = event.getEntityLiving();
        Level world = attacker.m_183503_();
        int chainCount = ChainHelper.getChainCount(attacker);
        if (chainCount <= 0) {
            return;
        }
        ActiveFlags.IS_AOE_ATTACKING.runIfNotSet(() -> {
            List<Mob> nearby = EntityHelper.getNearby((LevelAccessor)world, (Vec3i)attacked.m_142538_(), 5.0f, Mob.class);
            nearby.remove(attacked);
            nearby.remove(attacker);
            nearby.removeIf(mob -> (attacker instanceof EternalEntity || attacker instanceof Player) && mob instanceof EternalEntity);
            if (!nearby.isEmpty()) {
                nearby.sort(Comparator.comparing(e -> Float.valueOf(e.m_20270_((Entity)attacked))));
                nearby = nearby.subList(0, Math.min(chainCount, nearby.size()));
                float multiplier = 0.5f;
                for (Mob mob2 : nearby) {
                    mob2.m_6469_(event.getSource(), event.getAmount() * multiplier);
                    multiplier *= 0.5f;
                }
            }
            if (attacker instanceof Player) {
                Player player = (Player)attacker;
                PlayerActiveFlags.set(player, PlayerActiveFlags.Flag.CHAINING_AOE, 2);
            }
        });
    }

    @SubscribeEvent
    public static void triggerStunAttack(LivingHurtEvent event) {
        Player player;
        Entity source = event.getSource().m_7639_();
        if (!(source instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)source;
        if (attacker.m_183503_().m_5776_() || !AttributeSnapshotHelper.canHaveSnapshot(attacker)) {
            return;
        }
        if (attacker instanceof Player && PlayerActiveFlags.isSet(player = (Player)attacker, PlayerActiveFlags.Flag.ATTACK_AOE)) {
            return;
        }
        AttributeSnapshot snapshot = AttributeSnapshotHelper.getInstance().getSnapshot(attacker);
        float stunChance = snapshot.getAttributeValue(ModGearAttributes.ON_HIT_STUN, VaultGearAttributeTypeMerger.floatSum()).floatValue();
        if (stunChance <= 0.0f || rand.nextFloat() >= stunChance) {
            return;
        }
        LivingEntity attacked = event.getEntityLiving();
        attacked.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 30, 9));
        attacked.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 30, 9));
    }

    @SubscribeEvent
    public static void blockAttack(LivingAttackEvent event) {
        VaultGearData gearData;
        Boolean isBellModel;
        ItemStack shieldStack;
        LivingEntity attacked = event.getEntityLiving();
        if (attacked.m_183503_().m_5776_() || event.getSource().m_19378_()) {
            return;
        }
        ItemStack mainHandStack = attacked.m_21120_(InteractionHand.MAIN_HAND);
        ItemStack offHandStack = attacked.m_21120_(InteractionHand.OFF_HAND);
        Object object = mainHandStack.m_41720_() instanceof ShieldItem ? mainHandStack : (shieldStack = offHandStack.m_41720_() instanceof ShieldItem ? offHandStack : null);
        if (shieldStack == null) {
            return;
        }
        if (!AttributeSnapshotHelper.canHaveSnapshot(attacked)) {
            return;
        }
        float blockChance = BlockChanceHelper.getBlockChance(attacked);
        if (rand.nextFloat() >= blockChance) {
            return;
        }
        event.setCanceled(true);
        if (shieldStack.m_41720_() instanceof VaultGearItem && (isBellModel = (gearData = VaultGearData.read(shieldStack)).getFirstValue(ModGearAttributes.GEAR_MODEL).map(modelId -> modelId.equals((Object)ModDynamicModels.Shields.BELL.getId())).orElse(false)).booleanValue()) {
            attacked.m_183503_().m_5594_(null, attacked.m_20097_(), SoundEvents.f_11699_, SoundSource.BLOCKS, 2.0f, 1.0f);
        }
        attacked.m_183503_().m_7605_((Entity)attacked, (byte)29);
        if (attacked instanceof Player) {
            Player player = (Player)attacked;
            BlockChanceHelper.setPlayerBlocking(player);
        }
    }

    @SubscribeEvent
    public static void increaseDamageDealt(LivingHurtEvent event) {
        Entity source = event.getSource().m_7639_();
        if (!(source instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)source;
        if (attacker.m_183503_().m_5776_() || !AttributeSnapshotHelper.canHaveSnapshot(attacker)) {
            return;
        }
        LivingEntity attacked = event.getEntityLiving();
        MobType type = attacked.m_6336_();
        AttributeSnapshot snapshot = AttributeSnapshotHelper.getInstance().getSnapshot(attacker);
        float increasedDamage = 0.0f;
        increasedDamage += snapshot.getAttributeValue(ModGearAttributes.DAMAGE_INCREASE, VaultGearAttributeTypeMerger.floatSum()).floatValue();
        if (type == MobType.f_21641_) {
            increasedDamage += snapshot.getAttributeValue(ModGearAttributes.DAMAGE_UNDEAD, VaultGearAttributeTypeMerger.floatSum()).floatValue();
        }
        if (type == MobType.f_21642_) {
            increasedDamage += snapshot.getAttributeValue(ModGearAttributes.DAMAGE_SPIDERS, VaultGearAttributeTypeMerger.floatSum()).floatValue();
        }
        if (type == MobType.f_21643_) {
            increasedDamage += snapshot.getAttributeValue(ModGearAttributes.DAMAGE_ILLAGERS, VaultGearAttributeTypeMerger.floatSum()).floatValue();
        }
        event.setAmount(event.getAmount() * (1.0f + increasedDamage));
    }

    @SubscribeEvent
    public static void triggerEffectCloudsActive(LivingHurtEvent event) {
        boolean doEffectClouds;
        Entity source = event.getSource().m_7639_();
        if (!(source instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)source;
        if (attacker.m_183503_().m_5776_() || !AttributeSnapshotHelper.canHaveSnapshot(attacker)) {
            return;
        }
        boolean bl = doEffectClouds = !ActiveFlags.IS_AOE_ATTACKING.isSet() && !ActiveFlags.IS_DOT_ATTACKING.isSet() && !ActiveFlags.IS_REFLECT_ATTACKING.isSet();
        if (doEffectClouds) {
            LivingEntity attacked = event.getEntityLiving();
            AttributeSnapshot snapshot = AttributeSnapshotHelper.getInstance().getSnapshot(attacker);
            snapshot.getAttributeValue(ModGearAttributes.EFFECT_CLOUD, VaultGearAttributeTypeMerger.asList()).forEach(cloud -> {
                if (rand.nextFloat() >= cloud.getTriggerChance()) {
                    return;
                }
                EffectCloudEntity cloudEntity = new EffectCloudEntity(attacker.m_183503_(), attacked.m_20185_(), attacked.m_20186_(), attacked.m_20189_());
                cloud.apply(cloudEntity);
                cloudEntity.setOwner(attacker);
                attacker.m_183503_().m_7967_((Entity)cloudEntity);
            });
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void triggerEffectCloudsPassive(LivingHurtEvent event) {
        boolean doEffectClouds;
        boolean bl = doEffectClouds = !ActiveFlags.IS_AOE_ATTACKING.isSet() && !ActiveFlags.IS_DOT_ATTACKING.isSet() && !ActiveFlags.IS_REFLECT_ATTACKING.isSet();
        if (!doEffectClouds) {
            return;
        }
        if (event.getSource().m_7639_() == null) {
            return;
        }
        GearAttributeEvents.withSnapshot((LivingEvent)event, true, (LivingEntity attacked, AttributeSnapshot snapshot) -> snapshot.getAttributeValue(ModGearAttributes.EFFECT_CLOUD_WHEN_HIT, VaultGearAttributeTypeMerger.asList()).forEach(cloud -> {
            if (rand.nextFloat() >= cloud.getTriggerChance()) {
                return;
            }
            EffectCloudEntity cloudEntity = new EffectCloudEntity(attacked.m_183503_(), attacked.m_20185_(), attacked.m_20186_(), attacked.m_20189_());
            cloud.apply(cloudEntity);
            cloudEntity.setOwner((LivingEntity)attacked);
            attacked.m_183503_().m_7967_((Entity)cloudEntity);
        }));
    }

    @SubscribeEvent
    public static void removeImmuneEffects(LivingEvent.LivingUpdateEvent event) {
        GearAttributeEvents.withSnapshot((LivingEvent)event, true, (LivingEntity entity, AttributeSnapshot snapshot) -> GrantedEffectHelper.getImmunities(entity).forEach(arg_0 -> ((LivingEntity)entity).m_21195_(arg_0)));
    }

    @SubscribeEvent
    public static void avoidPotionEffect(PotionEvent.PotionApplicableEvent event) {
        GearAttributeEvents.withSnapshot((LivingEvent)event, true, (LivingEntity entity, AttributeSnapshot snapshot) -> {
            if (GrantedEffectHelper.canAvoidEffect(event.getPotionEffect().m_19544_(), entity, rand)) {
                event.setResult(Event.Result.DENY);
            }
        });
    }

    @SubscribeEvent
    public static void forceVanillaCrit(CriticalHitEvent event) {
        GearAttributeEvents.withSnapshot((LivingEvent)event, true, (LivingEntity entity, AttributeSnapshot snapshot) -> {
            float criticalChance = snapshot.getAttributeValue(ModGearAttributes.VANILLA_CRITICAL_HIT_CHANCE, VaultGearAttributeTypeMerger.floatSum()).floatValue();
            if (rand.nextFloat() < criticalChance) {
                if (event.getDamageModifier() < 1.5f) {
                    event.setDamageModifier(1.5f);
                }
                event.setResult(Event.Result.ALLOW);
            }
        });
    }

    @SubscribeEvent
    public static void doFatalStrikeAttack(LivingHurtEvent event) {
        Entity source = event.getSource().m_7639_();
        if (!(source instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)source;
        if (source.m_183503_().m_5776_()) {
            return;
        }
        float fatalStrikeChance = FatalStrikeHelper.getFatalStrikeChance(attacker);
        if (rand.nextFloat() >= fatalStrikeChance) {
            return;
        }
        float fatalPercentDamage = FatalStrikeHelper.getFatalStrikeDamage(attacker);
        float damage = event.getAmount() * (1.0f + fatalPercentDamage);
        event.setAmount(damage);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void thornsReflectDamage(LivingAttackEvent event) {
        if (event.getSource() instanceof ThornsReflectDamageSource) {
            return;
        }
        Entity source = event.getSource().m_7639_();
        if (!(source instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)source;
        GearAttributeEvents.withSnapshot((LivingEvent)event, true, (LivingEntity attacked, AttributeSnapshot snapshot) -> {
            float thornsChance = ThornsHelper.getThornsChance(attacked);
            if (rand.nextFloat() >= thornsChance) {
                return;
            }
            float thornsMultiplier = ThornsHelper.getThornsDamage(attacked);
            if (thornsMultiplier <= 0.0f) {
                return;
            }
            float dmg = (float)attacked.m_21133_(Attributes.f_22281_);
            ThornsReflectDamageSource src = ThornsReflectDamageSource.of((Entity)attacked);
            attacker.m_6469_((DamageSource)src, dmg * thornsMultiplier);
        });
    }

    private static void withSnapshot(LivingEvent event, boolean serverOnly, BiConsumer<LivingEntity, AttributeSnapshot> fn) {
        GearAttributeEvents.withSnapshot(event.getEntityLiving(), serverOnly, fn);
    }

    private static void withSnapshot(LivingEntity entity, boolean serverOnly, BiConsumer<LivingEntity, AttributeSnapshot> fn) {
        if (!AttributeSnapshotHelper.canHaveSnapshot(entity)) {
            return;
        }
        if (serverOnly && entity.m_20193_().m_5776_()) {
            return;
        }
        fn.accept(entity, AttributeSnapshotHelper.getInstance().getSnapshot(entity));
    }
}

