/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.event;

import iskallia.vault.VaultMod;
import iskallia.vault.block.TreasureDoorBlock;
import iskallia.vault.block.VaultChestBlock;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultLevel;
import iskallia.vault.entity.entity.EffectCloudEntity;
import iskallia.vault.entity.entity.EternalEntity;
import iskallia.vault.entity.entity.FighterEntity;
import iskallia.vault.entity.entity.MonsterEyeEntity;
import iskallia.vault.entity.entity.TreasureGoblinEntity;
import iskallia.vault.entity.entity.VaultGuardianEntity;
import iskallia.vault.gear.attribute.custom.EffectCloudAttribute;
import iskallia.vault.gear.attribute.type.VaultGearAttributeTypeMerger;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.init.ModAttributes;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModItems;
import iskallia.vault.init.ModSounds;
import iskallia.vault.item.ItemShardPouch;
import iskallia.vault.item.gear.IdolItem;
import iskallia.vault.item.gear.VaultShieldItem;
import iskallia.vault.snapshot.AttributeSnapshot;
import iskallia.vault.snapshot.AttributeSnapshotHelper;
import iskallia.vault.util.MiscUtils;
import iskallia.vault.util.calc.PlayerStat;
import iskallia.vault.world.data.ServerVaults;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.TippedArrowItem;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDestroyBlockEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.event.entity.living.ZombieEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EntityEvents {
    private static final Random rand = new Random();

    @SubscribeEvent
    public static void onTradesLoad(VillagerTradesEvent event) {
        for (List trades : event.getTrades().values()) {
            trades.removeIf(trade -> {
                try {
                    MerchantOffer offer = trade.m_5670_(null, rand);
                    ItemStack output = offer.m_45370_();
                    if (output.m_41619_()) {
                        return true;
                    }
                    Item outItem = output.m_41720_();
                    if (outItem == Items.f_41852_) {
                        return true;
                    }
                    if (outItem instanceof ShieldItem) {
                        return true;
                    }
                    if (outItem instanceof TippedArrowItem) {
                        return true;
                    }
                    if (!outItem.getRegistryName().m_135827_().equals("minecraft")) {
                        return true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return false;
            });
        }
    }

    @SubscribeEvent
    public static void preventLongDistanceChestBreak(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        AttributeInstance reachAttr = player.m_21051_((Attribute)ForgeMod.REACH_DISTANCE.get());
        if (reachAttr == null) {
            return;
        }
        BlockPos pos = event.getPos();
        BlockState state = player.m_20193_().m_8055_(pos);
        if (!(state.m_60734_() instanceof VaultChestBlock)) {
            return;
        }
        double reach = reachAttr.m_22135_();
        if (player.m_20275_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5) >= reach * reach) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onDamageTotem(LivingHurtEvent event) {
        Level world = event.getEntity().m_20193_();
        if (world.m_5776_() || !(world instanceof ServerLevel)) {
            return;
        }
        LivingEntity livingEntity = event.getEntityLiving();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (event.getSource().m_19376_()) {
            return;
        }
        ItemStack offHand = event.getEntityLiving().m_21206_();
        if (!ServerVaults.isVaultWorld(world) && offHand.m_41720_() instanceof VaultGearItem) {
            return;
        }
        if (!(offHand.m_41720_() instanceof IdolItem) && !(offHand.m_41720_() instanceof VaultShieldItem)) {
            return;
        }
        int damage = (int)CommonEvents.PLAYER_STAT.invoke(PlayerStat.DURABILITY_DAMAGE, (LivingEntity)player, Math.max(1.0f, event.getAmount() / 6.0f)).getValue();
        if (damage <= 1) {
            damage = 1;
        }
        offHand.m_41622_(damage, event.getEntityLiving(), entity -> entity.m_21166_(EquipmentSlot.OFFHAND));
    }

    @SubscribeEvent
    public static void onEntityTick2(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntity().f_19853_.f_46443_ || !(event.getEntity() instanceof FighterEntity) || event.getEntity().f_19853_.m_46472_() != VaultMod.ARENA_KEY) {
            return;
        }
        ((FighterEntity)event.getEntity()).m_21530_();
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onEntityDrops(LivingDropsEvent event) {
        ServerPlayer killer;
        Level world = event.getEntity().f_19853_;
        if (world.m_5776_() || !(world instanceof ServerLevel)) {
            return;
        }
        ServerLevel sWorld = (ServerLevel)world;
        if (!ServerVaults.isVaultWorld(world)) {
            return;
        }
        Entity entity = event.getEntity();
        if (EntityEvents.shouldDropDefaultInVault(entity)) {
            return;
        }
        Vault vault = ServerVaults.get((Level)sWorld).orElse(null);
        if (vault == null) {
            return;
        }
        DamageSource killingSrc = event.getSource();
        event.getDrops().clear();
        boolean addedDrops = false;
        Entity killerEntity = killingSrc.m_7639_();
        if (killerEntity instanceof EternalEntity) {
            killerEntity = ((EternalEntity)killerEntity).getOwner().right().orElse(null);
        }
        if (killerEntity instanceof ServerPlayer && MiscUtils.inventoryContains((Container)(killer = (ServerPlayer)killerEntity).m_150109_(), stack -> stack.m_41720_() instanceof ItemShardPouch)) {
            addedDrops |= EntityEvents.addShardDrops(world, entity, killer, event.getDrops());
        }
        if (!addedDrops) {
            // empty if block
        }
    }

    private static boolean shouldDropDefaultInVault(Entity entity) {
        return entity instanceof VaultGuardianEntity || entity instanceof TreasureGoblinEntity || entity instanceof Player;
    }

    private static boolean addShardDrops(Level world, Entity killed, ServerPlayer killer, Collection<ItemEntity> drops) {
        AttributeSnapshot snapshot = AttributeSnapshotHelper.getInstance().getSnapshot((LivingEntity)killer);
        float chanceMultiplier = snapshot.getAttributeValue(ModGearAttributes.SOUL_CHANCE, VaultGearAttributeTypeMerger.floatSum()).floatValue();
        chanceMultiplier = CommonEvents.SOUL_SHARD_CHANCE.invoke(killer, chanceMultiplier).getChance();
        int shardCount = ModConfigs.SOUL_SHARD.getRandomShards(killed.m_6095_(), 1.0f + chanceMultiplier);
        if (shardCount <= 0) {
            return false;
        }
        ItemStack shards = new ItemStack((ItemLike)ModItems.SOUL_SHARD, shardCount);
        ItemEntity itemEntity = new ItemEntity(world, killed.m_20185_(), killed.m_20186_(), killed.m_20189_(), shards);
        itemEntity.m_32060_();
        drops.add(itemEntity);
        return true;
    }

    @SubscribeEvent
    public static void preventNormalMobSpawningInVaultAndArena(LivingSpawnEvent.CheckSpawn event) {
        if (ServerVaults.isVaultWorld(event.getEntity().m_20193_()) && !event.isSpawner()) {
            event.setResult(Event.Result.DENY);
        } else if (event.getEntity().m_20193_().m_46472_() == VaultMod.ARENA_KEY) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void onPlayerDeathInVaults(LivingDeathEvent event) {
        Slime slimeEntity;
        LivingEntity livingEntity = event.getEntityLiving();
        if (!(livingEntity instanceof Slime) || (slimeEntity = (Slime)livingEntity).m_183503_().m_5776_()) {
            return;
        }
        if (slimeEntity instanceof MonsterEyeEntity) {
            return;
        }
        ServerVaults.get(slimeEntity.m_183503_()).ifPresent(vault -> {
            int level = vault.getOptional(Vault.LEVEL).map(VaultLevel::get).orElse(0);
            ModConfigs.VAULT_ENTITIES.getSlimeEffectConfig(level).map(EffectCloudAttribute.EffectCloud::fromConfig).ifPresent(cloud -> {
                if (rand.nextFloat() >= cloud.getTriggerChance()) {
                    return;
                }
                EffectCloudEntity cloudEntity = new EffectCloudEntity(slimeEntity.m_183503_(), slimeEntity.m_20185_(), slimeEntity.m_20186_(), slimeEntity.m_20189_());
                cloud.apply(cloudEntity);
                slimeEntity.m_183503_().m_7967_((Entity)cloudEntity);
            });
        });
    }

    @SubscribeEvent
    public static void onWitchThrowPotion(EntityJoinWorldEvent event) {
        Entity entity;
        if (event.loadedFromDisk() || !((entity = event.getEntity()) instanceof ThrownPotion)) {
            return;
        }
        ThrownPotion thrownPotion = (ThrownPotion)entity;
        Entity thrower = thrownPotion.m_37282_();
        if (!(thrower instanceof Witch)) {
            return;
        }
        ServerVaults.get(thrower.m_183503_()).ifPresent(vault -> {
            int level = vault.getOptional(Vault.LEVEL).map(VaultLevel::get).orElse(0);
            List<MobEffectInstance> configuredEffects = ModConfigs.VAULT_ENTITIES.getWitchAdditionalThrownEffects(level);
            ItemStack thrown = thrownPotion.m_7846_();
            ArrayList<MobEffectInstance> effects = new ArrayList<MobEffectInstance>(configuredEffects);
            PotionUtils.m_43552_((ItemStack)thrown, effects);
            thrownPotion.m_37446_(thrown);
        });
    }

    @SubscribeEvent
    public static void onDamageArmorHit(LivingDamageEvent event) {
        Player player;
        block6: {
            block5: {
                LivingEntity damaged = event.getEntityLiving();
                if (!(damaged instanceof Player)) break block5;
                player = (Player)damaged;
                if (!damaged.m_20193_().m_5776_()) break block6;
            }
            return;
        }
        Entity trueSrc = event.getSource().m_7639_();
        if (trueSrc instanceof LivingEntity) {
            for (double chance = ((LivingEntity)trueSrc).m_21133_(ModAttributes.BREAK_ARMOR_CHANCE); chance > 0.0 && !((double)rand.nextFloat() > chance); chance -= 1.0) {
                player.m_150109_().m_150072_(event.getSource(), 4.0f, Inventory.f_150068_);
            }
        }
    }

    @SubscribeEvent
    public static void vaultGuardianReflectDamage(LivingDamageEvent event) {
        Entity trueSource;
        LivingEntity entityLiving = event.getEntityLiving();
        if (entityLiving.f_19853_.f_46443_) {
            return;
        }
        if (entityLiving instanceof VaultGuardianEntity && (trueSource = event.getSource().m_7639_()) instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)trueSource;
            attacker.m_6469_(DamageSource.m_19335_((Entity)entityLiving), event.getAmount() * 0.2f);
        }
    }

    @SubscribeEvent
    public static void applyPoison(PotionEvent.PotionApplicableEvent event) {
        if (event.getPotionEffect().m_19544_() == MobEffects.f_19614_ && ServerVaults.isInVault((Entity)event.getEntityLiving()) && (event.getEntityLiving().m_6336_() == MobType.f_21641_ || event.getEntityLiving() instanceof Spider)) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public static void entityDealCrit(LivingHurtEvent event) {
        LivingEntity attacked = event.getEntityLiving();
        if (attacked.f_19853_.f_46443_) {
            return;
        }
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)entity;
        AttributeMap attributes = attacker.m_21204_();
        if (!attributes.m_22171_(ModAttributes.CRIT_CHANCE)) {
            return;
        }
        if (!attributes.m_22171_(ModAttributes.CRIT_MULTIPLIER)) {
            return;
        }
        double chance = attacker.m_21133_(ModAttributes.CRIT_CHANCE);
        if ((double)rand.nextFloat() >= chance) {
            return;
        }
        float multiplier = (float)attacker.m_21133_(ModAttributes.CRIT_MULTIPLIER);
        if (AttributeSnapshotHelper.canHaveSnapshot(attacked) && multiplier > 1.0f) {
            AttributeSnapshot snapshot = AttributeSnapshotHelper.getInstance().getSnapshot(attacked);
            float mitigation = snapshot.getAttributeValue(ModGearAttributes.CRITICAL_HIT_TAKEN_REDUCTION, VaultGearAttributeTypeMerger.floatSum()).floatValue();
            float multiplierPart = multiplier - 1.0f;
            multiplierPart = Math.max(multiplierPart - multiplierPart * mitigation, 0.0f);
            multiplier = multiplierPart + 1.0f;
        }
        attacker.f_19853_.m_6263_(null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), SoundEvents.f_12313_, attacker.m_5720_(), 1.0f, 1.0f);
        event.setAmount(event.getAmount() * multiplier);
    }

    @SubscribeEvent
    public static void onLivingHurtTp(LivingHurtEvent event) {
        block8: {
            boolean direct;
            block7: {
                if (event.getEntityLiving().f_19853_.f_46443_) {
                    return;
                }
                boolean bl = direct = event.getSource().m_7640_() == event.getSource().m_7639_();
                if (!direct || !event.getEntityLiving().m_21204_().m_22171_(ModAttributes.TP_CHANCE)) break block7;
                double chance = event.getEntityLiving().m_21133_(ModAttributes.TP_CHANCE);
                if (!event.getEntityLiving().m_21204_().m_22171_(ModAttributes.TP_RANGE)) break block8;
                double range = event.getEntityLiving().m_21133_(ModAttributes.TP_RANGE);
                if (event.getEntityLiving().f_19853_.f_46441_.nextDouble() < chance) {
                    for (int i = 0; i < 64; ++i) {
                        if (!EntityEvents.teleportRandomly(event.getEntityLiving(), range)) continue;
                        event.getEntityLiving().f_19853_.m_6263_(null, event.getEntityLiving().f_19854_, event.getEntityLiving().f_19855_, event.getEntityLiving().f_19856_, ModSounds.BOSS_TP_SFX, event.getEntityLiving().m_5720_(), 1.0f, 1.0f);
                        event.setCanceled(true);
                        return;
                    }
                }
                break block8;
            }
            if (!direct && event.getEntityLiving().m_21204_().m_22171_(ModAttributes.TP_INDIRECT_CHANCE)) {
                double chance = event.getEntityLiving().m_21133_(ModAttributes.TP_INDIRECT_CHANCE);
                if (event.getEntityLiving().m_21204_().m_22171_(ModAttributes.TP_RANGE)) {
                    double range = event.getEntityLiving().m_21133_(ModAttributes.TP_RANGE);
                    if (event.getEntityLiving().f_19853_.f_46441_.nextDouble() < chance) {
                        for (int i = 0; i < 64; ++i) {
                            if (!EntityEvents.teleportRandomly(event.getEntityLiving(), range)) continue;
                            event.getEntityLiving().f_19853_.m_6263_(null, event.getEntityLiving().f_19854_, event.getEntityLiving().f_19855_, event.getEntityLiving().f_19856_, ModSounds.BOSS_TP_SFX, event.getEntityLiving().m_5720_(), 1.0f, 1.0f);
                            event.setCanceled(true);
                            return;
                        }
                    }
                }
            }
        }
    }

    private static boolean teleportRandomly(LivingEntity entity, double range) {
        if (!entity.f_19853_.m_5776_() && entity.m_6084_()) {
            double d0 = entity.m_20185_() + (entity.f_19853_.f_46441_.nextDouble() - 0.5) * (range * 2.0);
            double d1 = entity.m_20186_() + ((double)entity.f_19853_.f_46441_.nextInt((int)(range * 2.0)) - range);
            double d2 = entity.m_20189_() + (entity.f_19853_.f_46441_.nextDouble() - 0.5) * (range * 2.0);
            return entity.m_20984_(d0, d1, d2, true);
        }
        return false;
    }

    @SubscribeEvent
    public static void onEntityDestroy(LivingDestroyBlockEvent event) {
        if (event.getState().m_60734_() instanceof TreasureDoorBlock) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onReinforcementsSpawn(ZombieEvent.SummonAidEvent event) {
        Entity entity = event.getEntity();
        if (ServerVaults.isInVault(entity)) {
            event.setResult(Event.Result.DENY);
        }
    }
}

