/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.event;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import iskallia.vault.VaultMod;
import iskallia.vault.client.ClientActiveEternalData;
import iskallia.vault.client.ClientDamageData;
import iskallia.vault.init.ModConfigs;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ClientEvents {
    private static final ResourceLocation OVERLAY_ICONS = VaultMod.id("textures/gui/overlay_icons.png");

    public static void setupHealthTexture(RenderGameOverlayEvent.Pre event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
    }

    @SubscribeEvent
    public static void cleanupHealthTexture(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)GuiComponent.f_93098_);
    }

    @SubscribeEvent
    public static void onDisconnect(ClientPlayerNetworkEvent.LoggedOutEvent event) {
        ClientActiveEternalData.clearClientCache();
        ClientDamageData.clearClientCache();
    }

    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        int value;
        ModConfigs.TOOLTIP.getTooltipString(event.getItemStack().m_41720_()).ifPresent(str -> {
            List tooltip = event.getToolTip();
            List added = Lists.reverse((List)Lists.newArrayList((Object[])str.split("\n")));
            if (added.isEmpty()) {
                return;
            }
            tooltip.add(1, TextComponent.f_131282_);
            for (String newStr : added) {
                tooltip.add(1, new TextComponent(newStr).m_130940_(ChatFormatting.GRAY));
            }
        });
        ItemStack current = event.getItemStack();
        if (!current.m_41619_() && ModConfigs.VAULT_DIFFUSER.getDiffuserOutputMap().containsKey(current.m_41720_().getRegistryName()) && (value = ModConfigs.VAULT_DIFFUSER.getDiffuserOutputMap().get(current.m_41720_().getRegistryName()).intValue()) > 0) {
            if (Screen.m_96638_()) {
                event.getToolTip().add(1, new TextComponent("Soul Value: ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent(value + " [" + current.m_41613_() * value + "]").m_130940_(ChatFormatting.DARK_PURPLE)));
            } else {
                event.getToolTip().add(1, new TextComponent("Soul Value: ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent("" + value).m_130940_(ChatFormatting.DARK_PURPLE)));
            }
        }
    }
}

