/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.event;

import iskallia.vault.VaultMod;
import iskallia.vault.config.entry.EnchantedBookEntry;
import iskallia.vault.core.world.generator.layout.DIYRoomEntry;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.ItemVaultCrystalSeal;
import iskallia.vault.item.MagnetItem;
import iskallia.vault.item.PaxelJewelItem;
import iskallia.vault.item.VaultCatalystInfusedItem;
import iskallia.vault.item.VaultRuneItem;
import iskallia.vault.item.crystal.CrystalData;
import iskallia.vault.item.crystal.VaultCrystalItem;
import iskallia.vault.item.crystal.layout.CrystalLayout;
import iskallia.vault.item.crystal.layout.DIYCrystalLayout;
import iskallia.vault.item.crystal.theme.PoolCrystalTheme;
import iskallia.vault.item.paxel.PaxelItem;
import iskallia.vault.util.EnchantmentUtil;
import iskallia.vault.util.MathUtilities;
import iskallia.vault.util.OverlevelEnchantHelper;
import iskallia.vault.world.data.ServerVaults;
import iskallia.vault.world.vault.modifier.VaultModifierStack;
import iskallia.vault.world.vault.modifier.registry.VaultModifierRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class AnvilEvents {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onVaultAnvil(AnvilUpdateEvent event) {
        Level world = event.getPlayer().m_20193_();
        Item repairItem = event.getRight().m_41720_();
        if (repairItem == ModItems.REPAIR_CORE) {
            return;
        }
        if (repairItem instanceof PaxelJewelItem) {
            return;
        }
        if (ServerVaults.isVaultWorld(world)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void repairVaultGear(AnvilUpdateEvent event) {
        ItemStack equipment = event.getLeft();
        ItemStack core = event.getRight();
        if (equipment.m_41619_() || !(equipment.m_41720_() instanceof VaultGearItem)) {
            return;
        }
        if (!core.m_150930_((Item)ModItems.REPAIR_CORE)) {
            return;
        }
        VaultGearData data = VaultGearData.read(equipment);
        if (data.getUsedRepairSlots() >= data.getRepairSlots()) {
            return;
        }
        ItemStack repairedGear = equipment.m_41777_();
        repairedGear.m_41721_(0);
        data.setUsedRepairSlots(data.getUsedRepairSlots() + 1);
        data.write(repairedGear);
        event.setOutput(repairedGear);
        event.setMaterialCost(1);
        event.setCost(1);
    }

    @SubscribeEvent
    public static void onPreventEnchantmentApply(AnvilUpdateEvent event) {
        Map enchantmentsToApply = EnchantmentHelper.m_44831_((ItemStack)event.getRight());
        for (Enchantment ench : enchantmentsToApply.keySet()) {
            if (!EnchantmentUtil.isEnchantmentBlocked(ench, event.getLeft())) continue;
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public static void onAnvilUpdate(AnvilUpdateEvent event) {
        ItemStack equipment = event.getLeft();
        ItemStack enchantedBook = event.getRight();
        if (equipment.m_41720_() == Items.f_42690_) {
            return;
        }
        if (enchantedBook.m_41720_() != Items.f_42690_) {
            return;
        }
        ItemStack upgradedEquipment = equipment.m_41777_();
        Map<Enchantment, Integer> equipmentEnchantments = OverlevelEnchantHelper.getEnchantments(equipment);
        Map<Enchantment, Integer> bookEnchantments = OverlevelEnchantHelper.getEnchantments(enchantedBook);
        int overlevels = OverlevelEnchantHelper.getOverlevels(enchantedBook);
        if (overlevels == -1) {
            return;
        }
        HashMap<Enchantment, Integer> enchantmentsToApply = new HashMap<Enchantment, Integer>(equipmentEnchantments);
        for (Enchantment bookEnchantment : bookEnchantments.keySet()) {
            int bookLevel;
            if (!equipmentEnchantments.containsKey(bookEnchantment)) continue;
            int currentLevel = equipmentEnchantments.getOrDefault(bookEnchantment, 0);
            int nextLevel = currentLevel == (bookLevel = bookEnchantments.get(bookEnchantment).intValue()) ? currentLevel + 1 : Math.max(currentLevel, bookLevel);
            enchantmentsToApply.put(bookEnchantment, nextLevel);
        }
        EnchantmentHelper.m_44865_(enchantmentsToApply, (ItemStack)upgradedEquipment);
        if (upgradedEquipment.equals(equipment, true)) {
            event.setCanceled(true);
        } else {
            EnchantedBookEntry bookTier = ModConfigs.OVERLEVEL_ENCHANT.getTier(overlevels);
            event.setOutput(upgradedEquipment);
            event.setCost(bookTier == null ? 1 : bookTier.getLevelNeeded());
        }
    }

    @SubscribeEvent
    public static void onApplySeal(AnvilUpdateEvent event) {
        ItemStack input = event.getLeft();
        ItemStack seal = event.getRight();
        if (!(seal.m_41720_() instanceof ItemVaultCrystalSeal)) {
            return;
        }
        ItemStack copy = input.m_41720_() == ModItems.VAULT_CRYSTAL ? input.m_41777_() : new ItemStack((ItemLike)ModItems.VAULT_CRYSTAL);
        CrystalData crystal = new CrystalData(copy);
        if (!crystal.getModifiers().isEmpty()) {
            return;
        }
        if (!ModConfigs.VAULT_CRYSTAL.applySeal(seal.m_41720_(), input.m_41720_(), crystal)) {
            return;
        }
        VaultCrystalItem.setRandomSeed(copy);
        event.setOutput(copy);
        event.setMaterialCost(1);
        event.setCost(8);
    }

    @SubscribeEvent
    public static void onApplyCatalyst(AnvilUpdateEvent event) {
        List<VaultModifierStack> modifierStackList;
        ItemStack output;
        CrystalData data;
        if (event.getLeft().m_41720_() instanceof VaultCrystalItem && event.getRight().m_41720_() instanceof VaultCatalystInfusedItem && (data = VaultCrystalItem.getData(output = event.getLeft().m_41777_())).addModifiersByCrafting(modifierStackList = VaultCatalystInfusedItem.getModifiers(event.getRight()).stream().map(VaultModifierRegistry::getOpt).flatMap(Optional::stream).map(VaultModifierStack::of).toList(), CrystalData.Simulate.FALSE)) {
            VaultCrystalItem.scheduleTask(VaultCrystalItem.AddRandomCurseTask.INSTANCE, output);
            VaultCrystalItem.scheduleTask(VaultCrystalItem.ExhaustTask.INSTANCE, output);
            event.setOutput(output);
            event.setCost(modifierStackList.size() * 4);
            event.setMaterialCost(1);
        }
    }

    @SubscribeEvent
    public static void onApplyWitherSkull(AnvilUpdateEvent event) {
        if (event.getLeft().m_41720_() instanceof VaultCrystalItem && event.getRight().m_41720_() == Items.f_42679_) {
            ItemStack output = event.getLeft().m_41777_();
            VaultCrystalItem.scheduleTask(new VaultCrystalItem.AddRandomCursesTask(1, 1), output);
            event.setOutput(output);
            event.setCost(1);
            event.setMaterialCost(1);
        }
    }

    @SubscribeEvent
    public static void onApplyMote(AnvilUpdateEvent event) {
        if (event.getLeft().m_41720_() instanceof VaultCrystalItem) {
            Item item = event.getRight().m_41720_();
            ItemStack output = event.getLeft().m_41777_();
            CrystalData data = VaultCrystalItem.getData(output);
            if (item == ModItems.MOTE_CLARITY && !data.hasClarity()) {
                VaultCrystalItem.scheduleTask(VaultCrystalItem.AddClarityTask.INSTANCE, output);
                event.setOutput(output);
                event.setCost(ModConfigs.VAULT_CRYSTAL.MOTES.clarityLevelCost);
                event.setMaterialCost(1);
            } else if (item == ModItems.MOTE_PURITY && data.isCursed()) {
                VaultCrystalItem.scheduleTask(VaultCrystalItem.RemoveRandomCurseTask.INSTANCE, output);
                event.setOutput(output);
                event.setCost(ModConfigs.VAULT_CRYSTAL.MOTES.purityLevelCost);
                event.setMaterialCost(1);
            } else if (item == ModItems.MOTE_SANCTITY && data.isCursed()) {
                VaultCrystalItem.getData(output).removeAllCurses();
                event.setOutput(output);
                event.setCost(ModConfigs.VAULT_CRYSTAL.MOTES.sanctityLevelCost);
                event.setMaterialCost(1);
            }
        }
    }

    @SubscribeEvent
    public static void onApplyRune(AnvilUpdateEvent event) {
        if (event.getLeft().m_41720_() instanceof VaultCrystalItem && event.getRight().m_41720_() instanceof VaultRuneItem) {
            ItemStack output = event.getLeft().m_41777_();
            CrystalData data = VaultCrystalItem.getData(output);
            if (!data.canModifyWithCrafting()) {
                return;
            }
            data.setTheme(new PoolCrystalTheme(VaultMod.id("diy")));
            CrystalLayout layout = data.getLayout();
            ArrayList<DIYRoomEntry> entries = new ArrayList<DIYRoomEntry>();
            for (int i = 0; i < event.getRight().m_41613_(); ++i) {
                entries.addAll(VaultRuneItem.getEntries(event.getRight()));
            }
            if (!(layout instanceof DIYCrystalLayout)) {
                layout = new DIYCrystalLayout(1, new ArrayList<DIYRoomEntry>());
            }
            entries.forEach(((DIYCrystalLayout)layout)::add);
            data.setLayout(layout);
            int amount = event.getRight().m_41613_();
            event.setOutput(output);
            event.setCost(amount * 4);
            event.setMaterialCost(amount);
        }
    }

    @SubscribeEvent
    public static void onApplyDiamondToCrystal(AnvilUpdateEvent event) {
        if (event.getLeft().m_41720_() instanceof VaultCrystalItem && event.getRight().m_41720_() == Items.f_42415_) {
            ItemStack output = event.getLeft().m_41777_();
            CrystalData data = VaultCrystalItem.getData(output);
            int crystalLevel = data.getLevel();
            if (data.isCursed()) {
                return;
            }
            if (!data.canBeModified()) {
                return;
            }
            if (data.getLevel() > 1) {
                int count = event.getRight().m_41613_();
                int diff = crystalLevel - count;
                event.setMaterialCost(count);
                data.setLevel(Math.max(0, diff));
                if (diff < 0) {
                    event.setMaterialCost(count + diff);
                }
                event.setCost(1);
                event.setOutput(output);
            }
        }
    }

    @SubscribeEvent
    public static void onApplyEchoGemToCrystal(AnvilUpdateEvent event) {
        if (event.getLeft().m_41720_() instanceof VaultCrystalItem && event.getRight().m_41720_() == ModItems.ECHO_GEM) {
            ItemStack output = event.getLeft().m_41777_();
            CrystalData data = VaultCrystalItem.getData(output);
            if (data.getEchoData().getEchoCount() == 0) {
                data.addEchoGems(1);
                data.setModifiable(false);
                event.setMaterialCost(1);
            } else {
                int count = event.getRight().m_41613_();
                VaultCrystalItem.scheduleTask(new VaultCrystalItem.EchoTask(count), output);
                event.setMaterialCost(count);
            }
            event.setCost(1);
            event.setOutput(output);
        }
    }

    @SubscribeEvent
    public static void onApplyEchoCrystal(AnvilUpdateEvent event) {
        if (!(event.getLeft().m_41720_() instanceof VaultCrystalItem)) {
            return;
        }
        if (!(event.getRight().m_41720_() instanceof VaultCrystalItem)) {
            return;
        }
        ItemStack output = event.getLeft().m_41777_();
        if (output.m_41784_().m_128471_("Cloned")) {
            return;
        }
        CrystalData crystalData = VaultCrystalItem.getData(output);
        if (crystalData.getEchoData().getEchoCount() != 0) {
            return;
        }
        if (!crystalData.canBeModified()) {
            return;
        }
        ItemStack echoCrystal = event.getRight().m_41777_();
        CrystalData echoCrystalData = VaultCrystalItem.getData(echoCrystal);
        if (echoCrystalData.getEchoData().getEchoCount() <= 0) {
            return;
        }
        boolean success = MathUtilities.randomFloat(0.0f, 1.0f) < echoCrystalData.getEchoData().getCloneSuccessRate();
        VaultCrystalItem.scheduleTask(new VaultCrystalItem.CloneTask(success), output);
        event.setCost(1);
        event.setMaterialCost(1);
        event.setOutput(output);
    }

    @SubscribeEvent
    public static void onRepairDeny(AnvilUpdateEvent event) {
        if (event.getLeft().m_41720_() instanceof MagnetItem && event.getRight().m_41720_() instanceof MagnetItem) {
            event.setCanceled(true);
        } else if (event.getLeft().m_41720_() instanceof PaxelItem && event.getRight().m_41720_() instanceof PaxelItem) {
            event.setCanceled(true);
        }
        if (event.getLeft().m_41720_() instanceof VaultGearItem && event.getRight().m_41720_() instanceof VaultGearItem) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onApplySoulFlame(AnvilUpdateEvent event) {
        if (event.getLeft().m_41720_() instanceof VaultCrystalItem && event.getRight().m_41720_() == ModItems.SOUL_FLAME) {
            ItemStack output = event.getLeft().m_41777_();
            CrystalData data = VaultCrystalItem.getData(output);
            if (!data.getModifiers().isEmpty()) {
                return;
            }
            VaultModifierRegistry.getOpt(VaultMod.id("afterlife")).ifPresent(vaultModifier -> {
                VaultModifierStack modifierStack = VaultModifierStack.of(vaultModifier);
                if (data.addModifierByCrafting(modifierStack, false, CrystalData.Simulate.TRUE)) {
                    data.addModifierByCrafting(modifierStack, false, CrystalData.Simulate.FALSE);
                    VaultCrystalItem.scheduleTask(new VaultCrystalItem.AddRandomCursesTask(0, 2), output);
                    data.setModifiable(false);
                    event.setOutput(output);
                    event.setMaterialCost(1);
                    event.setCost(10);
                }
            });
        }
    }

    @SubscribeEvent
    public static void onApplyPhoenix(AnvilUpdateEvent event) {
        if (event.getLeft().m_41720_() instanceof VaultCrystalItem && event.getRight().m_41720_() == ModItems.PHOENIX_FEATHER) {
            ItemStack output = event.getLeft().m_41777_();
            CrystalData data = VaultCrystalItem.getData(output);
            VaultModifierRegistry.getOpt(VaultMod.id("phoenix")).ifPresent(modifier -> {
                VaultModifierStack modifierStack = VaultModifierStack.of(modifier);
                if (data.addModifierByCrafting(modifierStack, false, CrystalData.Simulate.TRUE)) {
                    data.addModifierByCrafting(modifierStack, false, CrystalData.Simulate.FALSE);
                    data.setModifiable(false);
                    event.setOutput(output);
                    event.setMaterialCost(1);
                    event.setCost(10);
                }
            });
        }
    }

    @SubscribeEvent
    public static void onApplyLootersDream(AnvilUpdateEvent event) {
        if (event.getLeft().m_41720_() instanceof VaultCrystalItem && event.getRight().m_41720_() == ModItems.EYE_OF_AVARICE) {
            ItemStack output = event.getLeft().m_41777_();
            CrystalData data = VaultCrystalItem.getData(output);
            VaultModifierRegistry.getOpt(VaultMod.id("looters_dream")).ifPresent(modifier -> {
                VaultModifierStack modifierStack = VaultModifierStack.of(modifier);
                if (data.addModifierByCrafting(modifierStack, false, CrystalData.Simulate.TRUE)) {
                    data.addModifierByCrafting(modifierStack, false, CrystalData.Simulate.FALSE);
                    data.setModifiable(false);
                    event.setOutput(output);
                    event.setMaterialCost(1);
                    event.setCost(10);
                }
            });
        }
    }

    @SubscribeEvent
    public static void onApplyPog(AnvilUpdateEvent event) {
        if (event.getRight().m_41720_() != ModItems.OMEGA_POG) {
            return;
        }
        ResourceLocation name = event.getLeft().m_41720_().getRegistryName();
        if (name.equals((Object)ModBlocks.VAULT_ARTIFACT.getRegistryName())) {
            event.setOutput(new ItemStack((ItemLike)ModItems.UNIDENTIFIED_ARTIFACT));
            event.setMaterialCost(1);
            event.setCost(1);
        }
    }

    @SubscribeEvent
    public static void onApplyMending(AnvilUpdateEvent event) {
        ItemStack out = event.getOutput();
        if (!(out.m_41720_() instanceof ShieldItem)) {
            return;
        }
        if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44962_, (ItemStack)out) > 0) {
            event.setCanceled(true);
        }
        if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44972_, (ItemStack)out) > 0) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onAddPerkToPaxel(AnvilUpdateEvent event) {
        Item item;
        ItemStack paxel = event.getLeft();
        ItemStack jewel = event.getRight();
        if (paxel.m_41720_() instanceof PaxelItem && (item = jewel.m_41720_()) instanceof PaxelJewelItem) {
            PaxelJewelItem ji = (PaxelJewelItem)item;
            int sockets = PaxelItem.getSockets(paxel);
            if (sockets != 0) {
                PaxelItem.Perk perk = ji.getPerk();
                if (!PaxelItem.getPerks(paxel).contains((Object)perk)) {
                    event.setMaterialCost(1);
                    event.setCost(1);
                    ItemStack output = paxel.m_41777_();
                    PaxelItem.setSockets(output, sockets - 1);
                    PaxelItem.addPerk(output, perk);
                    event.setOutput(output);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onRepairMagnetOrPaxel(AnvilUpdateEvent event) {
        int max;
        int used;
        ItemStack magnet = event.getLeft();
        ItemStack magnetite = event.getRight();
        if (!magnetite.m_150930_((Item)ModItems.REPAIR_CORE)) {
            return;
        }
        ItemStack output = magnet.m_41777_();
        if (magnet.m_41720_() instanceof MagnetItem) {
            used = MagnetItem.getUsedRepairSlots(magnet);
            max = MagnetItem.getMaxRepairSlots(magnet);
        } else if (magnet.m_41720_() instanceof PaxelItem) {
            used = PaxelItem.getUsedRepairSlots(magnet);
            max = PaxelItem.getMaxRepairSlots(magnet);
        } else {
            return;
        }
        int left = max - used;
        if (event.getLeft().m_41773_() == 0 || left == 0) {
            event.setCanceled(true);
            return;
        }
        event.setMaterialCost(1);
        event.setCost(1);
        MagnetItem.useRepairSlot(output);
        output.m_41721_(0);
        event.setOutput(output);
    }
}

