/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.etching.set;

import com.google.common.collect.Lists;
import com.google.gson.annotations.Expose;
import iskallia.vault.etching.EtchingSet;
import iskallia.vault.etching.set.EffectSet;
import iskallia.vault.etching.set.GearAttributeSet;
import iskallia.vault.gear.attribute.VaultGearAttributeInstance;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.util.damage.PlayerDamageHelper;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffects;

public class DreamSet
extends EtchingSet<Config>
implements GearAttributeSet,
EffectSet {
    private static final UUID DAMAGE_MULTIPLIER_ID = UUID.fromString("6abda41d-0564-4666-ac0d-0a24230a8b90");

    public DreamSet(ResourceLocation name) {
        super(name);
    }

    @Override
    public Class<Config> getConfigClass() {
        return Config.class;
    }

    @Override
    public Config getDefaultConfig() {
        return new Config(MobEffects.f_19598_.getRegistryName(), 2, 0.5f, 0.1f, 0.25f, 0.1f);
    }

    @Override
    public List<EffectSet.GrantedEffect> getGrantedEffects() {
        EffectSet.GrantedEffect effect = ((Config)this.getConfig()).createGrantedEffect();
        if (effect != null) {
            return Lists.newArrayList((Object[])new EffectSet.GrantedEffect[]{effect});
        }
        return Collections.emptyList();
    }

    @Override
    public List<VaultGearAttributeInstance<?>> getAttributes() {
        Config cfg = (Config)this.getConfig();
        return Lists.newArrayList((Object[])new VaultGearAttributeInstance[]{new VaultGearAttributeInstance<Float>(ModGearAttributes.RESISTANCE, Float.valueOf(cfg.getIncreasedResistance())), new VaultGearAttributeInstance<Float>(ModGearAttributes.ITEM_RARITY, Float.valueOf(cfg.getIncreasedItemRarity())), new VaultGearAttributeInstance<Float>(ModGearAttributes.BLOCK, Float.valueOf(cfg.getIncreasedBlockChance()))});
    }

    @Override
    public void tick(ServerPlayer player) {
        super.tick(player);
        if (PlayerDamageHelper.getMultiplier(player, DAMAGE_MULTIPLIER_ID) == null) {
            float dmgMultiplier = ((Config)this.getConfig()).getIncreasedDamage();
            PlayerDamageHelper.applyMultiplier(DAMAGE_MULTIPLIER_ID, player, dmgMultiplier, PlayerDamageHelper.Operation.ADDITIVE_MULTIPLY);
        }
    }

    @Override
    public void remove(ServerPlayer player) {
        super.remove(player);
        PlayerDamageHelper.removeMultiplier(player, DAMAGE_MULTIPLIER_ID);
    }

    public static class Config
    extends EffectSet.EffectConfig {
        @Expose
        private float increasedDamage;
        @Expose
        private float increasedResistance;
        @Expose
        private float increasedItemRarity;
        @Expose
        private float increasedBlockChance;

        public Config(ResourceLocation effect, int addedAmplifier, float increasedDamage, float increasedResistance, float increasedItemRarity, float increasedBlockChance) {
            super(effect, addedAmplifier);
            this.increasedDamage = increasedDamage;
            this.increasedResistance = increasedResistance;
            this.increasedItemRarity = increasedItemRarity;
            this.increasedBlockChance = increasedBlockChance;
        }

        public float getIncreasedDamage() {
            return this.increasedDamage;
        }

        public float getIncreasedResistance() {
            return this.increasedResistance;
        }

        public float getIncreasedItemRarity() {
            return this.increasedItemRarity;
        }

        public float getIncreasedBlockChance() {
            return this.increasedBlockChance;
        }
    }
}

