/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.renderer.eyesore;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import iskallia.vault.VaultMod;
import iskallia.vault.entity.entity.eyesore.EyesoreEntity;
import iskallia.vault.entity.model.ModModelLayers;
import iskallia.vault.entity.model.eyesore.EyesoreModel;
import javax.annotation.Nonnull;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class EyesoreRenderer
extends MobRenderer<EyesoreEntity, EyesoreModel> {
    public static final ResourceLocation DEFAULT_TEXTURE = VaultMod.id("textures/entity/eyesore/default.png");
    public static final ResourceLocation SORE_EYE_TEXTURE = VaultMod.id("textures/entity/eyesore/sore_eye.png");
    private static final ResourceLocation GUARDIAN_BEAM_TEXTURE = VaultMod.id("textures/entity/eyesore/laser_beam.png");
    private static final RenderType BEAM_RENDER_TYPE = RenderType.m_110458_((ResourceLocation)GUARDIAN_BEAM_TEXTURE);

    public EyesoreRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new EyesoreModel(context.m_174023_(ModModelLayers.EYESORE)), 0.5f);
    }

    protected void scale(@Nonnull EyesoreEntity entity, @Nonnull PoseStack matrixStack, float partialTickTime) {
        float f = 4.5f;
        matrixStack.m_85841_(f, f, f);
    }

    protected void renderNameTag(EyesoreEntity entityIn, Component displayNameIn, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
    }

    protected boolean shouldShowName(EyesoreEntity entity) {
        return false;
    }

    @Nonnull
    public ResourceLocation getTextureLocation(@Nonnull EyesoreEntity entity) {
        int targetId = (Integer)entity.m_20088_().m_135370_(EyesoreEntity.LASER_TARGET);
        if (entity.f_19853_.m_6815_(targetId) != null) {
            return SORE_EYE_TEXTURE;
        }
        if (entity.getState() == EyesoreEntity.State.GIVING_BIRTH) {
            return SORE_EYE_TEXTURE;
        }
        return DEFAULT_TEXTURE;
    }

    public void render(EyesoreEntity entity, float entityYaw, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int packedLightIn) {
        LivingEntity livingentity;
        super.m_7392_((Mob)entity, entityYaw, partialTicks, matrixStack, buffer, packedLightIn);
        int targetId = (Integer)entity.m_20088_().m_135370_(EyesoreEntity.LASER_TARGET);
        Entity target = entity.m_20193_().m_6815_(targetId);
        LivingEntity livingEntity = livingentity = target instanceof LivingEntity ? (LivingEntity)target : null;
        if (livingentity != null) {
            float f = this.getAttackAnimationScale(entity, partialTicks);
            float f1 = (float)entity.f_19853_.m_46467_() + partialTicks;
            float f2 = f1 * 0.5f % 1.0f;
            float f3 = entity.m_20192_();
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.0, (double)f3, 0.0);
            Vec3 vector3d = this.getPosition(livingentity, (double)livingentity.m_20206_() * 0.5, partialTicks);
            Vec3 vector3d1 = this.getPosition((LivingEntity)entity, f3, partialTicks);
            Vec3 eyePos1 = entity.m_20299_(1.0f);
            ClipContext context = new ClipContext(eyePos1, vector3d, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)entity);
            BlockHitResult result = entity.f_19853_.m_45547_(context);
            vector3d1 = eyePos1;
            if (result.m_6662_() != HitResult.Type.MISS) {
                vector3d = result.m_82450_();
            }
            Vec3 vector3d2 = vector3d.m_82546_(vector3d1);
            float f4 = (float)(vector3d2.m_82553_() + 1.0);
            vector3d2 = vector3d2.m_82541_();
            float f5 = (float)Math.acos(vector3d2.f_82480_);
            float f6 = (float)Math.atan2(vector3d2.f_82481_, vector3d2.f_82479_);
            matrixStack.m_85845_(Vector3f.f_122225_.m_122240_((1.5707964f - f6) * 57.295776f));
            matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(f5 * 57.295776f));
            boolean i = true;
            float f7 = f1 * 0.05f * -1.5f;
            float f8 = f * f;
            int j = 190;
            int k = 0;
            int l = 0;
            float f9 = 0.2f;
            float f10 = 0.282f;
            float f11 = Mth.m_14089_((float)(f7 + 2.3561945f)) * 0.282f;
            float f12 = Mth.m_14031_((float)(f7 + 2.3561945f)) * 0.282f;
            float f13 = Mth.m_14089_((float)(f7 + 0.7853982f)) * 0.282f;
            float f14 = Mth.m_14031_((float)(f7 + 0.7853982f)) * 0.282f;
            float f15 = Mth.m_14089_((float)(f7 + 3.926991f)) * 0.282f;
            float f16 = Mth.m_14031_((float)(f7 + 3.926991f)) * 0.282f;
            float f17 = Mth.m_14089_((float)(f7 + 5.4977875f)) * 0.282f;
            float f18 = Mth.m_14031_((float)(f7 + 5.4977875f)) * 0.282f;
            float f19 = Mth.m_14089_((float)(f7 + (float)Math.PI)) * 0.2f;
            float f20 = Mth.m_14031_((float)(f7 + (float)Math.PI)) * 0.2f;
            float f21 = Mth.m_14089_((float)(f7 + 0.0f)) * 0.2f;
            float f22 = Mth.m_14031_((float)(f7 + 0.0f)) * 0.2f;
            float f23 = Mth.m_14089_((float)(f7 + 1.5707964f)) * 0.2f;
            float f24 = Mth.m_14031_((float)(f7 + 1.5707964f)) * 0.2f;
            float f25 = Mth.m_14089_((float)(f7 + 4.712389f)) * 0.2f;
            float f26 = Mth.m_14031_((float)(f7 + 4.712389f)) * 0.2f;
            float f27 = 0.0f;
            float f28 = 0.4999f;
            float f29 = -1.0f + f2;
            float f30 = f4 * 2.5f + f29;
            VertexConsumer ivertexbuilder = buffer.m_6299_(BEAM_RENDER_TYPE);
            PoseStack.Pose matrixstack$entry = matrixStack.m_85850_();
            Matrix4f matrix4f = matrixstack$entry.m_85861_();
            Matrix3f matrix3f = matrixstack$entry.m_85864_();
            EyesoreRenderer.vertex(ivertexbuilder, matrix4f, matrix3f, f19, f4, f20, j, k, l, 0.4999f, f30);
            EyesoreRenderer.vertex(ivertexbuilder, matrix4f, matrix3f, f19, 0.0f, f20, j, k, l, 0.4999f, f29);
            EyesoreRenderer.vertex(ivertexbuilder, matrix4f, matrix3f, f21, 0.0f, f22, j, k, l, 0.0f, f29);
            EyesoreRenderer.vertex(ivertexbuilder, matrix4f, matrix3f, f21, f4, f22, j, k, l, 0.0f, f30);
            EyesoreRenderer.vertex(ivertexbuilder, matrix4f, matrix3f, f23, f4, f24, j, k, l, 0.4999f, f30);
            EyesoreRenderer.vertex(ivertexbuilder, matrix4f, matrix3f, f23, 0.0f, f24, j, k, l, 0.4999f, f29);
            EyesoreRenderer.vertex(ivertexbuilder, matrix4f, matrix3f, f25, 0.0f, f26, j, k, l, 0.0f, f29);
            EyesoreRenderer.vertex(ivertexbuilder, matrix4f, matrix3f, f25, f4, f26, j, k, l, 0.0f, f30);
            float f31 = 0.0f;
            if (entity.f_19797_ % 2 == 0) {
                f31 = 0.5f;
            }
            EyesoreRenderer.vertex(ivertexbuilder, matrix4f, matrix3f, f11, f4, f12, j, k, l, 0.5f, f31 + 0.5f);
            EyesoreRenderer.vertex(ivertexbuilder, matrix4f, matrix3f, f13, f4, f14, j, k, l, 1.0f, f31 + 0.5f);
            EyesoreRenderer.vertex(ivertexbuilder, matrix4f, matrix3f, f17, f4, f18, j, k, l, 1.0f, f31);
            EyesoreRenderer.vertex(ivertexbuilder, matrix4f, matrix3f, f15, f4, f16, j, k, l, 0.5f, f31);
            matrixStack.m_85849_();
        }
    }

    private static void vertex(VertexConsumer builder, Matrix4f matrix, Matrix3f normal, float x, float y, float z, int r, int g, int b, float u, float v) {
        builder.m_85982_(matrix, x, y, z).m_6122_(r, g, b, 255).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    public float getAttackAnimationScale(EyesoreEntity entity, float p_175477_1_) {
        return ((float)entity.laserAttack.tick + p_175477_1_) / 80.0f;
    }

    private Vec3 getPosition(LivingEntity entityLivingBaseIn, double p_177110_2_, float p_177110_4_) {
        double d0 = Mth.m_14139_((double)p_177110_4_, (double)entityLivingBaseIn.f_19790_, (double)entityLivingBaseIn.m_20185_());
        double d1 = Mth.m_14139_((double)p_177110_4_, (double)entityLivingBaseIn.f_19791_, (double)entityLivingBaseIn.m_20186_()) + p_177110_2_;
        double d2 = Mth.m_14139_((double)p_177110_4_, (double)entityLivingBaseIn.f_19792_, (double)entityLivingBaseIn.m_20189_());
        return new Vec3(d0, d1, d2);
    }
}

