/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.renderer.elite;

import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.VaultMod;
import iskallia.vault.entity.renderer.elite.EliteEnderEyesLayer;
import iskallia.vault.entity.renderer.elite.EliteEnderOrnamentLayer;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.model.EndermanModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CarriedBlockLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class EliteEndermanRenderer
extends MobRenderer<EnderMan, EndermanModel<EnderMan>> {
    private static final ResourceLocation TEXTURE_LOCATION = VaultMod.id("textures/entity/elite/enderman.png");
    private final Random random = new Random();

    public EliteEndermanRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new EndermanModel(context.m_174023_(ModelLayers.f_171142_)), 0.5f);
        this.m_115326_((RenderLayer)new EliteEnderEyesLayer((RenderLayerParent<EnderMan, EndermanModel<EnderMan>>)this));
        this.m_115326_((RenderLayer)new CarriedBlockLayer((RenderLayerParent)this));
        int ornamentCount = 3;
        for (int i = 0; i < ornamentCount; ++i) {
            this.m_115326_(new EliteEnderOrnamentLayer(this, context.m_174027_(), (float)i * 360.0f / (float)ornamentCount));
        }
    }

    @Nonnull
    public ResourceLocation getTextureLocation(@Nonnull EnderMan entity) {
        return TEXTURE_LOCATION;
    }

    protected void scale(@Nonnull EnderMan entity, @Nonnull PoseStack poseStack, float partialTickTime) {
        super.m_7546_((LivingEntity)entity, poseStack, partialTickTime);
        float scale = 1.2f;
        poseStack.m_85841_(scale, scale, scale);
    }

    @Nonnull
    public Vec3 getRenderOffset(EnderMan entity, float partialTicks) {
        if (entity.m_32531_()) {
            double d0 = 0.02;
            return new Vec3(this.random.nextGaussian() * 0.02, 0.0, this.random.nextGaussian() * 0.02);
        }
        return super.m_7860_((Entity)entity, partialTicks);
    }

    public void render(@Nonnull EnderMan entity, float pEntityYaw, float pPartialTicks, @Nonnull PoseStack matrixStack, @Nonnull MultiBufferSource buffer, int pPackedLight) {
        BlockState blockstate = entity.m_32530_();
        EndermanModel endermanmodel = (EndermanModel)this.m_7200_();
        endermanmodel.f_102576_ = blockstate != null;
        endermanmodel.f_102577_ = entity.m_32531_();
        super.m_7392_((Mob)entity, pEntityYaw, pPartialTicks, matrixStack, buffer, pPackedLight);
    }
}

