/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.renderer;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import iskallia.vault.entity.entity.SpiritEntity;
import iskallia.vault.entity.renderer.PlayerSkinUpdater;
import java.util.List;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class SpiritRenderer
extends EntityRenderer<SpiritEntity> {
    private final SpiritPlayerRenderer steveSpiritRenderer;
    private final SpiritPlayerRenderer alexSpiritRenderer;

    public SpiritRenderer(EntityRendererProvider.Context context) {
        super(context);
        PlayerModel<SpiritEntity> steveModel = new PlayerModel<SpiritEntity>(context.m_174027_().m_171103_(ModelLayers.f_171162_), false){

            public void setupAnim(SpiritEntity pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
                super.m_6973_((LivingEntity)pEntity, pLimbSwing, pLimbSwingAmount, pAgeInTicks, pNetHeadYaw, pHeadPitch);
                this.f_102814_.f_104203_ = 0.0f;
                this.f_103376_.f_104203_ = 0.0f;
                this.f_102813_.f_104203_ = 0.0f;
                this.f_103377_.f_104203_ = 0.0f;
                this.f_102812_.f_104203_ = 0.0f;
                this.f_103374_.f_104203_ = 0.0f;
                this.f_102811_.f_104203_ = 0.0f;
                this.f_103375_.f_104203_ = 0.0f;
            }
        };
        steveModel.f_102610_ = false;
        this.steveSpiritRenderer = new SpiritPlayerRenderer(context, steveModel);
        PlayerModel<SpiritEntity> alexModel = new PlayerModel<SpiritEntity>(context.m_174027_().m_171103_(ModelLayers.f_171166_), true){

            public void setupAnim(SpiritEntity pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
                super.m_6973_((LivingEntity)pEntity, pLimbSwing, pLimbSwingAmount, pAgeInTicks, pNetHeadYaw, pHeadPitch);
                this.f_102814_.f_104203_ = 0.0f;
                this.f_103376_.f_104203_ = 0.0f;
                this.f_102813_.f_104203_ = 0.0f;
                this.f_103377_.f_104203_ = 0.0f;
                this.f_102812_.f_104203_ = 0.0f;
                this.f_103374_.f_104203_ = 0.0f;
                this.f_102811_.f_104203_ = 0.0f;
                this.f_103375_.f_104203_ = 0.0f;
            }
        };
        alexModel.f_102610_ = false;
        this.alexSpiritRenderer = new SpiritPlayerRenderer(context, alexModel);
    }

    private static boolean playerCarriesSpirit(Player player) {
        List passengers = player.m_20197_();
        return !passengers.isEmpty() && passengers.get(0) instanceof SpiritEntity;
    }

    public static void handleStaticHandHoldingSpirit(Player player, ModelPart leftArm) {
        if (SpiritRenderer.playerCarriesSpirit(player)) {
            leftArm.f_104203_ = (float)Math.PI;
        }
    }

    public void render(SpiritEntity spirit, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        if (spirit.hasSlimSkin()) {
            this.alexSpiritRenderer.render(spirit, entityYaw, partialTicks, poseStack, buffer, packedLight);
        } else {
            this.steveSpiritRenderer.render(spirit, entityYaw, partialTicks, poseStack, buffer, packedLight);
        }
    }

    public ResourceLocation getTextureLocation(SpiritEntity entity) {
        return DefaultPlayerSkin.m_118626_();
    }

    private static class SpiritPlayerRenderer
    extends LivingEntityRenderer<SpiritEntity, PlayerModel<SpiritEntity>> {
        private PlayerSkinUpdater playerSkinUpdater = new PlayerSkinUpdater();

        public SpiritPlayerRenderer(EntityRendererProvider.Context context, PlayerModel<SpiritEntity> model) {
            super(context, model, 0.5f);
        }

        public ResourceLocation getTextureLocation(SpiritEntity spirit) {
            return spirit.getSkinLocation().orElseGet(() -> spirit.getGameProfile().map(gp -> this.playerSkinUpdater.updatePlayerSkin(spirit, (GameProfile)gp)).orElse(DefaultPlayerSkin.m_118626_()));
        }

        protected void scale(SpiritEntity entity, PoseStack poseStack, float partialTickTime) {
            poseStack.m_85841_(0.9375f, 0.9375f, 0.9375f);
        }

        protected boolean shouldShowName(SpiritEntity entity) {
            return false;
        }

        public void render(SpiritEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
            poseStack.m_85836_();
            float yBodyRot = Mth.m_14189_((float)partialTicks, (float)entity.f_20884_, (float)entity.f_20883_);
            float yHeadRot = Mth.m_14189_((float)partialTicks, (float)entity.f_20886_, (float)entity.f_20885_);
            float netHeadYaw = yHeadRot - yBodyRot;
            float xRot = Mth.m_14179_((float)partialTicks, (float)entity.f_19860_, (float)entity.m_146909_());
            float bob = this.m_6930_((LivingEntity)entity, partialTicks);
            this.m_7523_((LivingEntity)entity, poseStack, bob, yBodyRot, partialTicks);
            float yTranslation = -1.501f;
            float zTranslation = 0.0f;
            if (entity.m_20089_() == Pose.SLEEPING) {
                float angle;
                if (entity.m_20202_() != null) {
                    angle = entity.m_20202_().m_6080_();
                } else {
                    Vec3 movement = entity.m_20184_();
                    angle = (float)(Mth.m_14136_((double)movement.m_7094_(), (double)movement.m_7096_()) * 180.0 / Math.PI - 90.0);
                }
                poseStack.m_85845_(Vector3f.f_122227_.m_122240_(angle - 90.0f));
                yTranslation = -0.5f;
                zTranslation = -0.7f;
            }
            poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
            this.scale(entity, poseStack, partialTicks);
            poseStack.m_85837_(0.0, (double)yTranslation, (double)zTranslation);
            float animationSpeed = 0.0f;
            float animationPosition = 0.0f;
            if (entity.m_6084_()) {
                animationSpeed = Mth.m_14179_((float)partialTicks, (float)entity.f_20923_, (float)entity.f_20924_);
                animationPosition = entity.f_20925_ - entity.f_20924_ * (1.0f - partialTicks);
                if (animationSpeed > 1.0f) {
                    animationSpeed = 1.0f;
                }
            }
            ((PlayerModel)this.f_115290_).m_6839_((LivingEntity)entity, animationPosition, animationSpeed, partialTicks);
            ((PlayerModel)this.f_115290_).m_6973_((LivingEntity)entity, animationPosition, animationSpeed, bob, netHeadYaw, xRot);
            RenderType rendertype = this.m_7225_((LivingEntity)entity, true, true, false);
            if (rendertype != null) {
                VertexConsumer vertexconsumer = buffer.m_6299_(rendertype);
                int i = SpiritPlayerRenderer.m_115338_((LivingEntity)entity, (float)this.m_6931_((LivingEntity)entity, partialTicks));
                ((PlayerModel)this.f_115290_).m_7695_(poseStack, vertexconsumer, packedLight, i, 0.5f, 0.5f, 0.5f, 0.5f);
            }
            for (RenderLayer renderlayer : this.f_115291_) {
                renderlayer.m_6494_(poseStack, buffer, packedLight, (Entity)entity, animationPosition, animationSpeed, partialTicks, bob, netHeadYaw, xRot);
            }
            poseStack.m_85849_();
        }
    }
}

