/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.renderer;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import iskallia.vault.VaultMod;
import iskallia.vault.client.gui.overlay.ArenaScoreboardOverlay;
import iskallia.vault.entity.entity.EternalEntity;
import iskallia.vault.entity.model.EternalModel;
import iskallia.vault.entity.model.ModModelLayers;
import iskallia.vault.world.data.EternalsData;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ArrowLayer;
import net.minecraft.client.renderer.entity.layers.BeeStingerLayer;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;

public class EternalRenderer
extends LivingEntityRenderer<EternalEntity, EternalModel> {
    private static final Map<EternalsData.EternalVariant, ResourceLocation> LOCATION_BY_VARIANT = (Map)Util.m_137469_((Object)Maps.newEnumMap(EternalsData.EternalVariant.class), p_114874_ -> {
        p_114874_.put(EternalsData.EternalVariant.CAVE, VaultMod.id("textures/entity/vaultdwellercave.png"));
        p_114874_.put(EternalsData.EternalVariant.DESERT, VaultMod.id("textures/entity/vaultdwellerdesert.png"));
        p_114874_.put(EternalsData.EternalVariant.HELL, VaultMod.id("textures/entity/vaultdwellerhell.png"));
        p_114874_.put(EternalsData.EternalVariant.ICE, VaultMod.id("textures/entity/vaultdwellerice.png"));
        p_114874_.put(EternalsData.EternalVariant.LUSH, VaultMod.id("textures/entity/vaultdwellerlush.png"));
        p_114874_.put(EternalsData.EternalVariant.VOID, VaultMod.id("textures/entity/vaultdwellervoid.png"));
    });

    public static Map<EternalsData.EternalVariant, ResourceLocation> getLocationByVariant() {
        return LOCATION_BY_VARIANT;
    }

    public EternalRenderer(EntityRendererProvider.Context context) {
        this(context, false);
    }

    public EternalRenderer(EntityRendererProvider.Context context, boolean slim) {
        super(context, (EntityModel)new EternalModel(context.m_174023_(ModModelLayers.ETERNAL), slim), 0.5f);
        this.m_115326_((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, new HumanoidModel(context.m_174023_(slim ? ModelLayers.f_171167_ : ModelLayers.f_171164_)), new HumanoidModel(context.m_174023_(slim ? ModelLayers.f_171168_ : ModelLayers.f_171165_))));
        this.m_115326_((RenderLayer)new ArrowLayer(context, (LivingEntityRenderer)this));
        this.m_115326_((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, context.m_174027_()));
        this.m_115326_((RenderLayer)new ElytraLayer((RenderLayerParent)this, context.m_174027_()));
        this.m_115326_((RenderLayer)new BeeStingerLayer((LivingEntityRenderer)this));
    }

    protected void scale(EternalEntity entity, PoseStack matrixStack, float partialTickTime) {
        float f = entity.sizeMultiplier;
        matrixStack.m_85841_(f, f, f);
    }

    public void render(EternalEntity entity, float entityYaw, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int packedLightIn) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        this.setModelVisibilities(entity);
        String nickname = entity.m_5446_().getString();
        if (nickname.equals(ArenaScoreboardOverlay.scoreboard.getMVP())) {
            this.renderCrown(entity, matrixStack, buffer);
        }
        super.m_7392_((LivingEntity)entity, entityYaw, partialTicks, matrixStack, buffer, packedLightIn);
    }

    public void renderCrown(EternalEntity entity, PoseStack matrixStack, MultiBufferSource buffer) {
        matrixStack.m_85836_();
        float sizeMultiplier = entity.getSizeMultiplier();
        matrixStack.m_85841_(sizeMultiplier, sizeMultiplier, sizeMultiplier);
        matrixStack.m_85837_(0.0, 2.5, 0.0);
        float scale = 2.5f;
        matrixStack.m_85841_(scale, scale, scale);
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_((float)entity.f_19797_));
        matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(20.0f));
        ItemStack itemStack = new ItemStack((ItemLike)Registry.f_122827_.m_7745_(VaultMod.id("mvp_crown")));
        BakedModel ibakedmodel = Minecraft.m_91087_().m_91291_().m_174264_(itemStack, null, null, 0);
        Minecraft.m_91087_().m_91291_().m_115143_(itemStack, ItemTransforms.TransformType.GROUND, true, matrixStack, buffer, 0xF000E0, 655360, ibakedmodel);
        matrixStack.m_85849_();
    }

    public Vec3 getRenderOffset(EternalEntity entityIn, float partialTicks) {
        return entityIn.m_6047_() ? new Vec3(0.0, -0.125, 0.0) : super.m_7860_((Entity)entityIn, partialTicks);
    }

    private void setModelVisibilities(EternalEntity clientPlayer) {
        EternalModel playermodel = (EternalModel)this.m_7200_();
        if (clientPlayer.m_5833_()) {
            playermodel.m_8009_(false);
            playermodel.f_102808_.f_104207_ = true;
            playermodel.f_102809_.f_104207_ = true;
        } else {
            playermodel.m_8009_(true);
            playermodel.f_102817_ = clientPlayer.m_6047_();
            HumanoidModel.ArmPose bipedmodel$armpose = EternalRenderer.getArmPose(clientPlayer, InteractionHand.MAIN_HAND);
            HumanoidModel.ArmPose bipedmodel$armpose1 = EternalRenderer.getArmPose(clientPlayer, InteractionHand.OFF_HAND);
            if (bipedmodel$armpose.m_102897_()) {
                HumanoidModel.ArmPose armPose = bipedmodel$armpose1 = clientPlayer.m_21206_().m_41619_() ? HumanoidModel.ArmPose.EMPTY : HumanoidModel.ArmPose.ITEM;
            }
            if (clientPlayer.m_5737_() == HumanoidArm.RIGHT) {
                playermodel.f_102816_ = bipedmodel$armpose;
                playermodel.f_102815_ = bipedmodel$armpose1;
            } else {
                playermodel.f_102816_ = bipedmodel$armpose1;
                playermodel.f_102815_ = bipedmodel$armpose;
            }
        }
    }

    private static HumanoidModel.ArmPose getArmPose(EternalEntity p_241741_0_, InteractionHand p_241741_1_) {
        ItemStack itemstack = p_241741_0_.m_21120_(p_241741_1_);
        if (itemstack.m_41619_()) {
            return HumanoidModel.ArmPose.EMPTY;
        }
        if (p_241741_0_.m_7655_() == p_241741_1_ && p_241741_0_.m_21212_() > 0) {
            UseAnim useaction = itemstack.m_41780_();
            if (useaction == UseAnim.BLOCK) {
                return HumanoidModel.ArmPose.BLOCK;
            }
            if (useaction == UseAnim.BOW) {
                return HumanoidModel.ArmPose.BOW_AND_ARROW;
            }
            if (useaction == UseAnim.SPEAR) {
                return HumanoidModel.ArmPose.THROW_SPEAR;
            }
            if (useaction == UseAnim.CROSSBOW && p_241741_1_ == p_241741_0_.m_7655_()) {
                return HumanoidModel.ArmPose.CROSSBOW_CHARGE;
            }
        } else if (!p_241741_0_.f_20911_ && itemstack.m_41720_() == Items.f_42717_ && CrossbowItem.m_40932_((ItemStack)itemstack)) {
            return HumanoidModel.ArmPose.CROSSBOW_HOLD;
        }
        return HumanoidModel.ArmPose.ITEM;
    }

    public ResourceLocation getTextureLocation(EternalEntity entity) {
        if (!entity.isUsingPlayerSkin()) {
            return LOCATION_BY_VARIANT.get((Object)entity.getVariant());
        }
        return entity.getLocationSkin();
    }

    protected void preRenderCallback(AbstractClientPlayer entitylivingbaseIn, PoseStack matrixStackIn, float partialTickTime) {
        float f = 0.9375f;
        matrixStackIn.m_85841_(0.9375f, 0.9375f, 0.9375f);
    }

    protected boolean shouldShowName(EternalEntity pEntity) {
        return pEntity.m_6052_() && super.m_6512_((LivingEntity)pEntity);
    }

    protected void renderNameTag(EternalEntity entityIn, Component displayNameIn, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        double d0 = this.f_114476_.m_114471_((Entity)entityIn);
        matrixStackIn.m_85836_();
        super.m_7649_((Entity)entityIn, displayNameIn, matrixStackIn, bufferIn, packedLightIn);
        matrixStackIn.m_85849_();
    }

    public void renderRightArm(PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, EternalEntity playerIn) {
        this.renderItem(matrixStackIn, bufferIn, combinedLightIn, playerIn, ((EternalModel)this.f_115290_).f_102811_, ((EternalModel)this.f_115290_).f_103375_);
    }

    public void renderLeftArm(PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, EternalEntity playerIn) {
        this.renderItem(matrixStackIn, bufferIn, combinedLightIn, playerIn, ((EternalModel)this.f_115290_).f_102812_, ((EternalModel)this.f_115290_).f_103374_);
    }

    private void renderItem(PoseStack matrixStackIn, MultiBufferSource buffer, int combinedLight, EternalEntity entity, ModelPart rendererArm, ModelPart rendererArmWear) {
        EternalModel playermodel = (EternalModel)this.m_7200_();
        this.setModelVisibilities(entity);
        playermodel.f_102608_ = 0.0f;
        playermodel.f_102817_ = false;
        playermodel.f_102818_ = 0.0f;
        playermodel.m_6973_((LivingEntity)entity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        rendererArm.f_104203_ = 0.0f;
        rendererArm.m_104301_(matrixStackIn, buffer.m_6299_(RenderType.m_110446_((ResourceLocation)this.getTextureLocation(entity))), combinedLight, OverlayTexture.f_118083_);
        rendererArmWear.f_104203_ = 0.0f;
        rendererArmWear.m_104301_(matrixStackIn, buffer.m_6299_(RenderType.m_110473_((ResourceLocation)this.getTextureLocation(entity))), combinedLight, OverlayTexture.f_118083_);
    }

    protected void setupRotations(EternalEntity pEntityLiving, PoseStack pMatrixStack, float pAgeInTicks, float pRotationYaw, float pPartialTicks) {
        float f = pEntityLiving.m_20998_(pPartialTicks);
        if (pEntityLiving.m_21255_()) {
            super.m_7523_((LivingEntity)pEntityLiving, pMatrixStack, pAgeInTicks, pRotationYaw, pPartialTicks);
            float f1 = (float)pEntityLiving.m_21256_() + pPartialTicks;
            float f2 = Mth.m_14036_((float)(f1 * f1 / 100.0f), (float)0.0f, (float)1.0f);
            if (!pEntityLiving.m_21209_()) {
                pMatrixStack.m_85845_(Vector3f.f_122223_.m_122240_(f2 * (-90.0f - pEntityLiving.m_146909_())));
            }
            Vec3 vec3 = pEntityLiving.m_20252_(pPartialTicks);
            Vec3 vec31 = pEntityLiving.m_20184_();
            double d0 = vec31.m_165925_();
            double d1 = vec3.m_165925_();
            if (d0 > 0.0 && d1 > 0.0) {
                double d2 = (vec31.f_82479_ * vec3.f_82479_ + vec31.f_82481_ * vec3.f_82481_) / Math.sqrt(d0 * d1);
                double d3 = vec31.f_82479_ * vec3.f_82481_ - vec31.f_82481_ * vec3.f_82479_;
                pMatrixStack.m_85845_(Vector3f.f_122225_.m_122270_((float)(Math.signum(d3) * Math.acos(d2))));
            }
        } else if (f > 0.0f) {
            super.m_7523_((LivingEntity)pEntityLiving, pMatrixStack, pAgeInTicks, pRotationYaw, pPartialTicks);
            float f3 = pEntityLiving.m_20069_() ? -90.0f - pEntityLiving.m_146909_() : -90.0f;
            float f4 = Mth.m_14179_((float)f, (float)0.0f, (float)f3);
            pMatrixStack.m_85845_(Vector3f.f_122223_.m_122240_(f4));
            if (pEntityLiving.m_6067_()) {
                pMatrixStack.m_85837_(0.0, -1.0, (double)0.3f);
            }
        } else {
            super.m_7523_((LivingEntity)pEntityLiving, pMatrixStack, pAgeInTicks, pRotationYaw, pPartialTicks);
        }
    }
}

