/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.eternal;

import iskallia.vault.entity.eternal.EternalAttributes;
import iskallia.vault.entity.eternal.EternalData;
import iskallia.vault.entity.eternal.EternalDataAccess;
import iskallia.vault.entity.eternal.EternalHelper;
import iskallia.vault.gear.attribute.type.VaultGearAttributeTypeMerger;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.snapshot.AttributeSnapshot;
import iskallia.vault.snapshot.AttributeSnapshotHelper;
import iskallia.vault.world.data.EternalsData;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;

public class EternalDataSnapshot
implements EternalDataAccess {
    public static final String ATTR_HEALTH = Attributes.f_22276_.getRegistryName().toString();
    public static final String ATTR_DAMAGE = Attributes.f_22281_.getRegistryName().toString();
    public static final String ATTR_SPEED = Attributes.f_22279_.getRegistryName().toString();
    private final UUID eternalUUID;
    private final long seed;
    private final String eternalName;
    private final Map<EquipmentSlot, ItemStack> equipment;
    private final Map<String, Float> attributes;
    private final int level;
    private final int usedLevels;
    private final int maxLevel;
    private final float levelPercent;
    private final boolean alive;
    private final boolean ancient;
    private final String abilityName;
    private EternalsData.EternalVariant variant;
    private final boolean isUsingPlayerSkin;
    private final AttributeSnapshot attributeSnapshot;

    public EternalDataSnapshot(UUID eternalUUID, long seed, String eternalName, Map<EquipmentSlot, ItemStack> equipment, Map<String, Float> attributes, int level, int usedLevels, int maxLevel, float levelPercent, boolean alive, boolean ancient, String abilityName, EternalsData.EternalVariant variant, boolean isUsingPlayerSkin) {
        this.eternalUUID = eternalUUID;
        this.seed = seed;
        this.eternalName = eternalName;
        this.equipment = equipment;
        this.attributes = attributes;
        this.level = level;
        this.usedLevels = usedLevels;
        this.maxLevel = maxLevel;
        this.levelPercent = levelPercent;
        this.alive = alive;
        this.ancient = ancient;
        this.abilityName = abilityName;
        this.attributeSnapshot = AttributeSnapshotHelper.getInstance().makeGearSnapshot(this::getEquipment);
        this.variant = variant;
        this.isUsingPlayerSkin = isUsingPlayerSkin;
    }

    public static EternalDataSnapshot getFromEternal(EternalsData.EternalGroup playerGroup, EternalData eternal) {
        UUID eternalUUID = eternal.getId();
        long seed = eternal.getSeed();
        String eternalName = eternal.getName();
        HashMap<EquipmentSlot, ItemStack> equipment = new HashMap<EquipmentSlot, ItemStack>();
        for (EquipmentSlot slotType : EquipmentSlot.values()) {
            ItemStack stack = eternal.getStack(slotType);
            if (stack.m_41619_()) continue;
            equipment.put(slotType, stack.m_41777_());
        }
        EternalAttributes eternalAttributes = eternal.getAttributes();
        HashMap<String, Float> attributes = new HashMap<String, Float>();
        float value = eternalAttributes.getAttributeValue(Attributes.f_22276_).orElse(Float.valueOf(0.0f)).floatValue();
        value = EternalHelper.getEternalGearModifierAdjustments(eternal, Attributes.f_22276_, value);
        attributes.put(ATTR_HEALTH, Float.valueOf(value));
        value = eternalAttributes.getAttributeValue(Attributes.f_22281_).orElse(Float.valueOf(0.0f)).floatValue();
        value = EternalHelper.getEternalGearModifierAdjustments(eternal, Attributes.f_22281_, value);
        attributes.put(ATTR_DAMAGE, Float.valueOf(value));
        value = eternalAttributes.getAttributeValue(Attributes.f_22279_).orElse(Float.valueOf(0.0f)).floatValue();
        value = EternalHelper.getEternalGearModifierAdjustments(eternal, Attributes.f_22279_, value);
        attributes.put(ATTR_SPEED, Float.valueOf(value));
        int level = eternal.getLevel();
        int usedLevels = eternal.getUsedLevels();
        int maxLevel = eternal.getMaxLevel();
        float levelPercent = eternal.getLevelPercent();
        boolean alive = eternal.isAlive();
        boolean ancient = eternal.isAncient();
        String abilityName = eternal.getAura() != null ? eternal.getAura().getAuraName() : null;
        EternalsData.EternalVariant variant = eternal.getVariant();
        boolean isUsingPlayerSkin = eternal.isUsingPlayerSkin();
        return new EternalDataSnapshot(eternalUUID, seed, eternalName, equipment, attributes, level, usedLevels, maxLevel, levelPercent, alive, ancient, abilityName, variant, isUsingPlayerSkin);
    }

    @Override
    public UUID getId() {
        return this.eternalUUID;
    }

    @Override
    public long getSeed() {
        return this.seed;
    }

    @Override
    public String getName() {
        return this.eternalName;
    }

    @Override
    public Map<EquipmentSlot, ItemStack> getEquipment() {
        return Collections.unmodifiableMap(this.equipment);
    }

    @Nonnull
    public ItemStack getEquipment(EquipmentSlot slotType) {
        return this.equipment.getOrDefault(slotType, ItemStack.f_41583_).m_41777_();
    }

    public Map<String, Float> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public AttributeSnapshot getAttributeSnapshot() {
        return this.attributeSnapshot;
    }

    @Override
    public Map<Attribute, Float> getEntityAttributes() {
        return this.getAttributes().entrySet().stream().map(e -> {
            Attribute attr = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation((String)e.getKey()));
            if (attr != null) {
                return new Tuple((Object)attr, (Object)((Float)e.getValue()));
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toMap(Tuple::m_14418_, Tuple::m_14419_));
    }

    public float getResistance() {
        return this.attributeSnapshot.getAttributeValue(ModGearAttributes.RESISTANCE, VaultGearAttributeTypeMerger.floatSum()).floatValue();
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    public int getUsedLevels() {
        return this.usedLevels;
    }

    @Override
    public int getMaxLevel() {
        return this.maxLevel;
    }

    public float getLevelPercent() {
        return this.levelPercent;
    }

    @Override
    public boolean isAlive() {
        return this.alive;
    }

    @Override
    public boolean isAncient() {
        return this.ancient;
    }

    @Override
    public EternalsData.EternalVariant getVariant() {
        return this.variant;
    }

    @Override
    public boolean isUsingPlayerSkin() {
        return this.isUsingPlayerSkin;
    }

    @Override
    @Nullable
    public String getAbilityName() {
        return this.abilityName;
    }

    public boolean areStatisticsEqual(EternalDataSnapshot other) {
        float thatVal;
        if (this.alive != other.alive || !Objects.equals(this.abilityName, other.abilityName)) {
            return false;
        }
        if (this.level != other.level || this.maxLevel != other.maxLevel || this.usedLevels != other.usedLevels) {
            return false;
        }
        if (this.levelPercent != other.levelPercent) {
            return false;
        }
        float thisVal = this.attributes.get(ATTR_HEALTH).floatValue();
        if (thisVal != (thatVal = other.attributes.get(ATTR_HEALTH).floatValue())) {
            return false;
        }
        thisVal = this.attributes.get(ATTR_DAMAGE).floatValue();
        if (thisVal != (thatVal = other.attributes.get(ATTR_DAMAGE).floatValue())) {
            return false;
        }
        thisVal = this.attributes.get(ATTR_SPEED).floatValue();
        return thisVal == (thatVal = other.attributes.get(ATTR_SPEED).floatValue());
    }

    public void serialize(FriendlyByteBuf buffer, boolean useEquipment) {
        buffer.m_130077_(this.eternalUUID);
        buffer.writeLong(this.seed);
        buffer.m_130070_(this.eternalName);
        buffer.writeInt(this.equipment.size());
        this.equipment.forEach((slot, stack) -> {
            buffer.m_130068_((Enum)slot);
            buffer.m_130055_(useEquipment ? stack : ItemStack.f_41583_);
        });
        buffer.writeInt(this.attributes.size());
        this.attributes.forEach((attr, value) -> {
            buffer.m_130070_(attr);
            buffer.writeFloat(value.floatValue());
        });
        buffer.writeInt(this.level);
        buffer.writeInt(this.usedLevels);
        buffer.writeInt(this.maxLevel);
        buffer.writeFloat(this.levelPercent);
        buffer.writeBoolean(this.alive);
        buffer.writeBoolean(this.ancient);
        buffer.writeBoolean(this.abilityName != null);
        if (this.abilityName != null) {
            buffer.m_130070_(this.abilityName);
        }
        buffer.m_130068_((Enum)this.variant);
        buffer.writeBoolean(this.isUsingPlayerSkin);
    }

    public static EternalDataSnapshot deserialize(FriendlyByteBuf buffer) {
        UUID eternalUUID = buffer.m_130259_();
        long seed = buffer.readLong();
        String eternalName = buffer.m_130136_(Short.MAX_VALUE);
        HashMap<EquipmentSlot, ItemStack> equipment = new HashMap<EquipmentSlot, ItemStack>();
        int equipmentSize = buffer.readInt();
        for (int i = 0; i < equipmentSize; ++i) {
            EquipmentSlot type = (EquipmentSlot)buffer.m_130066_(EquipmentSlot.class);
            ItemStack stack = buffer.m_130267_();
            equipment.put(type, stack);
        }
        HashMap<String, Float> attributes = new HashMap<String, Float>();
        int attrSize = buffer.readInt();
        for (int i = 0; i < attrSize; ++i) {
            String attribute = buffer.m_130136_(Short.MAX_VALUE);
            float val = buffer.readFloat();
            attributes.put(attribute, Float.valueOf(val));
        }
        int level = buffer.readInt();
        int usedLevels = buffer.readInt();
        int maxLevel = buffer.readInt();
        float levelPercent = buffer.readFloat();
        boolean alive = buffer.readBoolean();
        boolean ancient = buffer.readBoolean();
        String abilityName = buffer.readBoolean() ? buffer.m_130136_(Short.MAX_VALUE) : null;
        EternalsData.EternalVariant variant = (EternalsData.EternalVariant)buffer.m_130066_(EternalsData.EternalVariant.class);
        boolean isUsingPlayerSkin = buffer.readBoolean();
        return new EternalDataSnapshot(eternalUUID, seed, eternalName, equipment, attributes, level, usedLevels, maxLevel, levelPercent, alive, ancient, abilityName, variant, isUsingPlayerSkin);
    }
}

