/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.entity;

import com.mojang.authlib.GameProfile;
import iskallia.vault.core.Version;
import iskallia.vault.core.data.sync.context.DiskSyncContext;
import iskallia.vault.core.net.ArrayBitBuffer;
import iskallia.vault.core.vault.EntityState;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.entity.IPlayerSkinHolder;
import iskallia.vault.gear.attribute.type.VaultGearAttributeTypeMerger;
import iskallia.vault.gear.data.AttributeGearData;
import iskallia.vault.init.ModEntities;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.integration.IntegrationCurios;
import iskallia.vault.util.SidedHelper;
import iskallia.vault.world.data.ServerVaults;
import iskallia.vault.world.vault.modifier.modifier.PlayerInventoryRestoreModifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class SpiritEntity
extends Mob
implements IPlayerSkinHolder {
    private static final String OWNER_PROFILE_TAG = "ownerProfile";
    private static final String JOIN_STATE_TAG = "joinState";
    private GameProfile gameProfile = null;
    private final NonNullList<ItemStack> items = NonNullList.m_122779_();
    private int vaultLevel;
    private long yeetCooldown;
    private ResourceLocation skinLocation = null;
    private boolean updatingSkin = false;
    private boolean slimSkin = false;
    @Nullable
    private EntityState joinState = null;

    public SpiritEntity(EntityType<SpiritEntity> entityType, Level level) {
        super(entityType, level);
    }

    public void transferPlayerData(Player player, Collection<ItemEntity> drops, EntityState joinState) {
        this.setGameProfile(player.m_36316_());
        this.setVaultLevel(SidedHelper.getVaultLevel(player));
        this.addDrops(drops);
        this.setJoinState(joinState);
    }

    private void addDrops(Collection<ItemEntity> drops) {
        drops.stream().map(ItemEntity::m_32055_).filter(this::shouldAddItem).forEach(arg_0 -> this.items.add(arg_0));
    }

    public void setJoinState(EntityState joinState) {
        this.joinState = joinState;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onPlayerInVaultDrops(LivingDropsEvent event) {
        Player player;
        block3: {
            block2: {
                Entity entity = event.getEntity();
                if (!(entity instanceof Player)) break block2;
                player = (Player)entity;
                if (!player.f_19853_.m_5776_()) break block3;
            }
            return;
        }
        Level level = player.f_19853_;
        ServerVaults.get(level).ifPresent(vault -> {
            if (level instanceof ServerLevel) {
                Entity entity;
                ServerLevel serverLevel = (ServerLevel)level;
                if (level.m_6907_().size() > 1 && vault.get(Vault.MODIFIERS).getModifiers().stream().noneMatch(m -> m instanceof PlayerInventoryRestoreModifier) && (entity = ModEntities.SPIRIT.m_20592_(serverLevel, null, null, player.m_142538_(), MobSpawnType.EVENT, false, false)) instanceof SpiritEntity) {
                    SpiritEntity spirit = (SpiritEntity)entity;
                    EntityState joinState = vault.get(Vault.LISTENERS).get(player.m_142081_()).get(Listener.JOIN_STATE);
                    spirit.transferPlayerData(player, event.getDrops(), joinState);
                }
            }
        });
    }

    public void addPlayersItems(Player player) {
        for (int slot = 0; slot < player.m_150109_().m_6643_(); ++slot) {
            ItemStack stackInSlot = player.m_150109_().m_8020_(slot);
            if (!this.shouldAddItem(stackInSlot)) continue;
            this.items.add((Object)stackInSlot.m_41777_());
        }
        if (ModList.get().isLoaded("curios")) {
            IntegrationCurios.getCuriosItemStacks((LivingEntity)player).forEach((slotType, stacks) -> stacks.forEach(stack -> {
                if (this.shouldAddItem((ItemStack)stack)) {
                    this.items.add((Object)stack.m_41777_());
                }
            }));
        }
    }

    private boolean shouldAddItem(ItemStack stack) {
        return !stack.m_41619_() && (!AttributeGearData.hasData(stack) || ((AttributeGearData)((Object)AttributeGearData.read(stack))).get(ModGearAttributes.SOULBOUND, VaultGearAttributeTypeMerger.anyTrue()) == false);
    }

    public List<ItemStack> getItems() {
        return this.items;
    }

    public void setVaultLevel(int vaultLevel) {
        this.vaultLevel = vaultLevel;
    }

    public int getVaultLevel() {
        return this.vaultLevel;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IPlayerSkinHolder.OPTIONAL_GAME_PROFILE, Optional.empty());
    }

    public void m_6043_() {
    }

    public boolean m_6573_(Player pPlayer) {
        return false;
    }

    protected InteractionResult m_6071_(Player player, InteractionHand pHand) {
        if (player.m_20197_().isEmpty() && this.putInPlayersHand(player)) {
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, pHand);
    }

    public boolean putInPlayersHand(Player player) {
        if (!player.m_21206_().m_41619_()) {
            player.m_5661_((Component)new TextComponent("You can't pick me up with that in offhand"), true);
            return false;
        }
        if (this.m_20329_((Entity)player)) {
            this.m_20124_(Pose.SLEEPING);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.f_8906_.m_141995_((Packet)new ClientboundSetPassengersPacket((Entity)player));
            }
            this.yeetCooldown = player.f_19853_.m_46467_() + 20L;
            return true;
        }
        return false;
    }

    public boolean m_7998_(Entity pEntity, boolean pForce) {
        boolean ret = super.m_7998_(pEntity, pForce);
        if (this.m_20159_()) {
            this.m_20124_(Pose.SLEEPING);
        }
        return ret;
    }

    public void m_8119_() {
        Vec3 movement;
        super.m_8119_();
        if (this.f_19853_.m_5776_()) {
            return;
        }
        Entity vehicle = this.m_20202_();
        if (vehicle != null) {
            Player player;
            if (this.yeetCooldown > this.f_19853_.m_46467_()) {
                return;
            }
            if (vehicle instanceof Player && !(player = (Player)vehicle).m_21206_().m_41619_()) {
                this.m_8127_();
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverPlayer.f_8906_.m_141995_((Packet)new ClientboundSetPassengersPacket(vehicle));
                }
                float motionAngle = vehicle.m_6080_() + 90.0f;
                float x = Mth.m_14089_((float)(motionAngle * ((float)Math.PI / 180)));
                float z = Mth.m_14031_((float)(motionAngle * ((float)Math.PI / 180)));
                this.m_146884_(this.m_20318_(0.0f).m_82520_((double)x, 0.0, (double)z));
                player.m_5661_((Component)new TextComponent("You can't hold me with that in offhand"), true);
            } else if (vehicle.m_6047_()) {
                this.m_8127_();
                if (vehicle instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)vehicle;
                    serverPlayer.f_8906_.m_141995_((Packet)new ClientboundSetPassengersPacket(vehicle));
                }
                this.m_146884_(this.m_20318_(0.0f).m_82520_(0.0, 1.0, 0.0));
                float motionAngle = vehicle.m_6080_() + 90.0f;
                float x = Mth.m_14089_((float)(motionAngle * ((float)Math.PI / 180)));
                float z = Mth.m_14031_((float)(motionAngle * ((float)Math.PI / 180)));
                Vec3 vehicleMotion = vehicle.m_20184_();
                this.m_20256_(new Vec3((double)x + vehicleMotion.m_7096_() * 10.0, 0.1, (double)z + vehicleMotion.m_7094_() * 10.0));
            }
        } else if (this.m_20089_() == Pose.SLEEPING && Math.abs((movement = this.m_20184_()).m_7096_()) + Math.abs(movement.m_7094_()) < 0.2) {
            this.m_20124_(Pose.STANDING);
        }
    }

    public boolean m_5825_() {
        return true;
    }

    public boolean m_6128_() {
        return true;
    }

    public boolean m_6673_(DamageSource pSource) {
        return true;
    }

    public Iterable<ItemStack> m_6168_() {
        return new ArrayList<ItemStack>();
    }

    public ItemStack m_6844_(EquipmentSlot pSlot) {
        return ItemStack.f_41583_;
    }

    public void m_8061_(EquipmentSlot pSlot, ItemStack pStack) {
    }

    public HumanoidArm m_5737_() {
        return HumanoidArm.RIGHT;
    }

    @Override
    public Optional<GameProfile> getGameProfile() {
        return (Optional)this.f_19804_.m_135370_(IPlayerSkinHolder.OPTIONAL_GAME_PROFILE);
    }

    @Override
    public void setGameProfile(GameProfile gameProfile) {
        this.f_19804_.m_135381_(OPTIONAL_GAME_PROFILE, Optional.ofNullable(gameProfile));
        this.gameProfile = gameProfile;
    }

    @Override
    public Optional<ResourceLocation> getSkinLocation() {
        return Optional.ofNullable(this.skinLocation);
    }

    @Override
    public boolean isUpdatingSkin() {
        return this.updatingSkin;
    }

    @Override
    public void setSkinLocation(ResourceLocation skinLocation) {
        this.skinLocation = skinLocation;
    }

    @Override
    public void startUpdatingSkin() {
        this.updatingSkin = true;
    }

    @Override
    public void stopUpdatingSkin() {
        this.updatingSkin = false;
    }

    @Override
    public boolean hasSlimSkin() {
        return this.slimSkin;
    }

    @Override
    public void setSlimSkin(boolean slimSkin) {
        this.slimSkin = slimSkin;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.gameProfile != null) {
            compound.m_128365_(OWNER_PROFILE_TAG, (Tag)NbtUtils.m_129230_((CompoundTag)new CompoundTag(), (GameProfile)this.gameProfile));
        }
        ListTag itemList = new ListTag();
        for (ItemStack item : this.items) {
            itemList.add((Object)item.m_41739_(new CompoundTag()));
        }
        compound.m_128365_("items", (Tag)itemList);
        compound.m_128405_("vaultLevel", this.vaultLevel);
        if (this.joinState != null) {
            ArrayBitBuffer buffer = ArrayBitBuffer.empty();
            this.joinState.write(buffer, new DiskSyncContext(Version.v1_0));
            compound.m_128388_(JOIN_STATE_TAG, buffer.toLongArray());
        }
        if (this.m_20159_()) {
            compound.m_128379_("isBeingCarried", true);
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setGameProfile(compound.m_128441_(OWNER_PROFILE_TAG) ? NbtUtils.m_129228_((CompoundTag)compound.m_128469_(OWNER_PROFILE_TAG)) : null);
        this.items.clear();
        for (Tag tag : compound.m_128437_("items", 10)) {
            this.items.add((Object)ItemStack.m_41712_((CompoundTag)((CompoundTag)tag)));
        }
        this.vaultLevel = compound.m_128451_("vaultLevel");
        this.joinState = compound.m_128425_(JOIN_STATE_TAG, 12) ? (EntityState)new EntityState().read(ArrayBitBuffer.backing(compound.m_128467_(JOIN_STATE_TAG), 0), new DiskSyncContext(Version.v1_0)) : null;
        if (compound.m_128471_("isBeingCarried")) {
            this.m_20124_(Pose.SLEEPING);
        }
    }

    public void setItems(List<ItemStack> items) {
        this.items.clear();
        this.items.addAll(items);
    }

    public void teleportOut() {
        if (this.joinState != null) {
            if (this.m_20159_()) {
                this.m_8127_();
            }
            this.joinState.teleport((Entity)this);
            this.joinState = null;
        }
    }
}

