/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.entity;

import com.mojang.datafixers.util.Either;
import iskallia.vault.aura.AuraManager;
import iskallia.vault.aura.EntityAuraProvider;
import iskallia.vault.config.EternalAuraConfig;
import iskallia.vault.entity.ai.FollowEntityGoal;
import iskallia.vault.entity.entity.EtchingVendorEntity;
import iskallia.vault.entity.eternal.ActiveEternalData;
import iskallia.vault.entity.eternal.EternalData;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.FighterSizeMessage;
import iskallia.vault.util.EntityHelper;
import iskallia.vault.util.SkinProfile;
import iskallia.vault.util.calc.GrantedEffectHelper;
import iskallia.vault.util.damage.DamageUtil;
import iskallia.vault.world.data.EternalsData;
import java.util.Comparator;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveThroughVillageGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.ZombieAttackGoal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PacketDistributor;

public class EternalEntity
extends Zombie {
    private static final EntityDataAccessor<String> ETERNAL_NAME = SynchedEntityData.m_135353_(EternalEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Integer> ETERNAL_VARIANT = SynchedEntityData.m_135353_(EternalEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> ETERNAL_SHOW_SKIN = SynchedEntityData.m_135353_(EternalEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public SkinProfile skin;
    public float sizeMultiplier = 1.0f;
    private boolean ancient = false;
    private long despawnTime = Long.MAX_VALUE;
    private final ServerBossEvent bossInfo;
    private UUID owner;
    private UUID eternalId;
    private String providedAura;

    public EternalEntity(EntityType<? extends EternalEntity> type, Level world) {
        super(type, world);
        if (this.f_19853_.f_46443_) {
            this.skin = new SkinProfile();
        }
        this.bossInfo = new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.PROGRESS);
        this.bossInfo.m_7003_(true);
        this.bossInfo.m_8321_(false);
        this.m_21553_(false);
        this.m_20340_(true);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ETERNAL_NAME, (Object)"Eternal");
        this.f_19804_.m_135372_(ETERNAL_VARIANT, (Object)EternalsData.EternalVariant.CAVE.getId());
        this.f_19804_.m_135372_(ETERNAL_SHOW_SKIN, (Object)false);
    }

    protected void m_6878_() {
        this.f_21345_.m_25352_(2, (Goal)new ZombieAttackGoal((Zombie)this, 1.1, false));
        this.f_21345_.m_25352_(6, (Goal)new MoveThroughVillageGoal((PathfinderMob)this, 1.1, true, 4, () -> ((EternalEntity)this).m_34330_()));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.1));
        this.f_21346_.m_25352_(2, new FollowEntityGoal(this, 1.1, 32.0f, 3.0f, false, () -> this.getOwner().right()));
    }

    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getLocationSkin() {
        return this.skin.getLocationSkin();
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
    }

    public void setSkinName(String skinName) {
        this.f_19804_.m_135381_(ETERNAL_NAME, (Object)skinName);
    }

    public String getSkinName() {
        return (String)this.f_19804_.m_135370_(ETERNAL_NAME);
    }

    public void setAncient(boolean ancient) {
        this.ancient = ancient;
    }

    public boolean isAncient() {
        return this.ancient;
    }

    public void setEternalId(UUID eternalId) {
        this.eternalId = eternalId;
    }

    public UUID getEternalId() {
        return this.eternalId;
    }

    public void setProvidedAura(String providedAura) {
        this.providedAura = providedAura;
    }

    public String getProvidedAura() {
        return this.providedAura;
    }

    public void setDespawnTime(long despawnTime) {
        this.despawnTime = despawnTime;
    }

    public void setVariant(EternalsData.EternalVariant variant) {
        this.f_19804_.m_135381_(ETERNAL_VARIANT, (Object)variant.getId());
    }

    public EternalsData.EternalVariant getVariant() {
        return EternalsData.EternalVariant.byId((Integer)this.f_19804_.m_135370_(ETERNAL_VARIANT));
    }

    public void setUsingPlayerSkin(boolean usingPlayerSkin) {
        this.f_19804_.m_135381_(ETERNAL_SHOW_SKIN, (Object)usingPlayerSkin);
    }

    public boolean isUsingPlayerSkin() {
        return (Boolean)this.f_19804_.m_135370_(ETERNAL_SHOW_SKIN);
    }

    public boolean m_6162_() {
        return false;
    }

    protected boolean m_5884_() {
        return false;
    }

    protected void m_7595_() {
    }

    protected boolean m_7593_() {
        return false;
    }

    public boolean m_21222_() {
        return false;
    }

    public MobCategory getClassification(boolean forSpawnCount) {
        return MobCategory.MONSTER;
    }

    public Either<UUID, ServerPlayer> getOwner() {
        if (this.f_19853_.m_5776_()) {
            return Either.left((Object)this.owner);
        }
        ServerPlayer player = this.m_20194_().m_6846_().m_11259_(this.owner);
        return player == null ? Either.left((Object)this.owner) : Either.right((Object)player);
    }

    public void m_8119_() {
        super.m_8119_();
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            double amplitude;
            ServerLevel sWorld = (ServerLevel)level;
            int tickCounter = sWorld.m_142572_().m_129921_();
            if ((long)tickCounter < this.despawnTime) {
                ActiveEternalData.getInstance().updateEternal(this);
            }
            if (this.f_20890_) {
                return;
            }
            if ((long)tickCounter >= this.despawnTime) {
                this.m_6074_();
            }
            if ((amplitude = this.m_20184_().m_82531_(0.0, this.m_20184_().m_7098_(), 0.0)) > 0.004) {
                this.m_6858_(true);
            } else {
                this.m_6858_(false);
            }
            this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
            if (this.f_19797_ % 10 == 0) {
                this.updateAttackTarget();
            }
            if (this.providedAura != null && this.f_19797_ % 4 == 0) {
                this.getOwner().ifRight(sPlayer -> {
                    EternalAuraConfig.AuraConfig auraCfg = ModConfigs.ETERNAL_AURAS.getByName(this.providedAura);
                    if (auraCfg != null) {
                        AuraManager.getInstance().provideAura(EntityAuraProvider.ofEntity((LivingEntity)this, auraCfg));
                    }
                });
            }
            GrantedEffectHelper.applyEffects((LivingEntity)this, GrantedEffectHelper.getSnapshotEffectData((LivingEntity)this));
        } else {
            if (this.f_20890_) {
                return;
            }
            if (!Objects.equals(this.getSkinName(), this.skin.getLatestNickname())) {
                this.skin.updateSkin(this.getSkinName());
            }
        }
    }

    protected void m_6153_() {
        super.m_6153_();
    }

    public void m_6710_(LivingEntity entity) {
        if (entity == this.getOwner().right().orElse(null) || entity instanceof EternalEntity || entity instanceof Player || entity instanceof EtchingVendorEntity) {
            return;
        }
        super.m_6710_(entity);
    }

    public void m_6703_(LivingEntity entity) {
        if (entity == this.getOwner().right().orElse(null) || entity instanceof EternalEntity || entity instanceof Player || entity instanceof EtchingVendorEntity) {
            return;
        }
        super.m_6703_(entity);
    }

    private void updateAttackTarget() {
        AABB box = this.m_142469_().m_82400_(32.0);
        this.f_19853_.m_6443_(LivingEntity.class, box, e -> {
            Either<UUID, ServerPlayer> owner = this.getOwner();
            if (owner.right().isPresent() && owner.right().get() == e) {
                return false;
            }
            return !(e instanceof EternalEntity) && !(e instanceof Player) && !(e instanceof EtchingVendorEntity);
        }).stream().sorted(Comparator.comparingDouble(e -> e.m_20182_().m_82554_(this.m_20182_()))).findFirst().ifPresent(this::m_6710_);
    }

    private Predicate<LivingEntity> ignoreEntities() {
        return e -> !(e instanceof EternalEntity) && !(e instanceof Player);
    }

    protected SoundEvent m_7515_() {
        return null;
    }

    public SoundEvent m_5592_() {
        return SoundEvents.f_12322_;
    }

    public SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_12323_;
    }

    public void m_6593_(Component name) {
        super.m_6593_(name);
        this.bossInfo.m_6456_(this.m_5446_());
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("ancient", this.ancient);
        tag.m_128350_("SizeMultiplier", this.sizeMultiplier);
        tag.m_128356_("DespawnTime", this.despawnTime);
        if (this.providedAura != null) {
            tag.m_128359_("providedAura", this.providedAura);
        }
        if (this.owner != null) {
            tag.m_128359_("Owner", this.owner.toString());
        }
        if (this.eternalId != null) {
            tag.m_128359_("eternalId", this.eternalId.toString());
        }
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.ancient = tag.m_128471_("ancient");
        this.sizeMultiplier = tag.m_128457_("SizeMultiplier");
        this.changeSize(this.sizeMultiplier);
        this.despawnTime = tag.m_128454_("DespawnTime");
        if (tag.m_128425_("providedAura", 8)) {
            this.providedAura = tag.m_128461_("providedAura");
        }
        if (tag.m_128425_("Owner", 8)) {
            this.owner = UUID.fromString(tag.m_128461_("Owner"));
        }
        if (tag.m_128425_("eternalId", 8)) {
            this.eternalId = UUID.fromString(tag.m_128461_("eternalId"));
        }
        this.bossInfo.m_6456_(this.m_5446_());
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossInfo.m_6543_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossInfo.m_6539_(player);
    }

    public EntityDimensions m_6972_(Pose pose) {
        return this.f_19815_;
    }

    public float getSizeMultiplier() {
        return this.sizeMultiplier;
    }

    public EternalEntity changeSize(float m) {
        this.sizeMultiplier = m;
        EntityHelper.changeSize(this, this.sizeMultiplier);
        if (!this.f_19853_.m_5776_()) {
            ModNetwork.CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new FighterSizeMessage((Entity)this, this.sizeMultiplier));
        }
        return this;
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return super.m_6431_(pose, size) * this.sizeMultiplier;
    }

    public void m_6667_(DamageSource cause) {
        super.m_6667_(cause);
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            EternalData eternal;
            ServerLevel sWorld = (ServerLevel)level;
            if (this.f_20890_ && this.owner != null && this.eternalId != null && !cause.m_19378_() && (eternal = EternalsData.get(sWorld).getEternal(this.eternalId)) != null) {
                eternal.setAlive(false);
            }
        }
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, SpawnGroupData spawnData, CompoundTag dataTag) {
        Chicken chicken;
        this.m_6593_(this.m_7770_());
        this.m_34336_(true);
        this.m_21553_(false);
        this.m_21530_();
        if (this.f_19796_.nextInt(100) == 0 && (chicken = (Chicken)EntityType.f_20555_.m_20615_(this.f_19853_)) != null) {
            chicken.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), 0.0f);
            chicken.m_6518_(world, difficulty, reason, spawnData, dataTag);
            chicken.m_28273_(true);
            ((ServerLevel)this.f_19853_).m_8847_((Entity)chicken);
            this.m_20329_((Entity)chicken);
        }
        return spawnData;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        ServerPlayer player;
        Entity src = source.m_7639_();
        if (src instanceof ServerPlayer && (player = (ServerPlayer)src).m_142081_().equals(this.owner)) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public boolean m_7327_(Entity entity) {
        Level level;
        if (!this.f_19853_.m_5776_() && (level = this.f_19853_) instanceof ServerLevel) {
            ServerLevel sWorld = (ServerLevel)level;
            sWorld.m_8767_((ParticleOptions)ParticleTypes.f_123766_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
            this.f_19853_.m_5594_(null, this.m_142538_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, this.f_19796_.nextFloat() - this.f_19796_.nextFloat());
        }
        return DamageUtil.shotgunAttackApply(entity, x$0 -> super.m_7327_(x$0));
    }
}

