/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.entity;

import iskallia.vault.block.entity.EtchingVendorControllerTileEntity;
import iskallia.vault.container.inventory.EtchingTradeContainer;
import iskallia.vault.world.data.ServerVaults;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class EtchingVendorEntity
extends Mob {
    private static final EntityDataAccessor<BlockPos> VENDOR_POS = SynchedEntityData.m_135353_(EtchingVendorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);

    public EtchingVendorEntity(EntityType<? extends Mob> type, Level world) {
        super(type, world);
        this.m_20331_(true);
        this.m_20242_(true);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VENDOR_POS, (Object)BlockPos.f_121853_);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_ = new GoalSelector(this.f_19853_.m_46658_());
        this.f_21346_ = new GoalSelector(this.f_19853_.m_46658_());
        this.f_21345_.m_25352_(1, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public void setVendorPos(BlockPos pos) {
        this.f_19804_.m_135381_(VENDOR_POS, (Object)pos);
    }

    public BlockPos getVendorPos() {
        return (BlockPos)this.f_19804_.m_135370_(VENDOR_POS);
    }

    public void m_8119_() {
        super.m_8119_();
        this.m_21455_(true, false);
        if (this.f_19853_.m_5776_()) {
            return;
        }
        if (!this.isValid()) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public boolean isValid() {
        if (!ServerVaults.isVaultWorld(this.f_19853_)) {
            return false;
        }
        if (!this.f_19853_.isAreaLoaded(this.getVendorPos(), 1)) {
            return false;
        }
        if (this.m_20238_(Vec3.m_82512_((Vec3i)this.getVendorPos())) > 4.0) {
            return false;
        }
        BlockEntity te = this.f_19853_.m_7702_(this.getVendorPos());
        if (!(te instanceof EtchingVendorControllerTileEntity)) {
            return false;
        }
        return ((EtchingVendorControllerTileEntity)te).getMonitoredEntityId() == this.m_142049_();
    }

    @Nullable
    public EtchingVendorControllerTileEntity getControllerTile() {
        return (EtchingVendorControllerTileEntity)this.f_19853_.m_7702_(this.getVendorPos());
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (player instanceof ServerPlayer) {
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)new MenuProvider(){

                public Component m_5446_() {
                    return new TextComponent("Etching Trader");
                }

                @Nullable
                public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
                    return new EtchingTradeContainer(windowId, playerInventory, EtchingVendorEntity.this.m_142049_());
                }
            }, buf -> buf.writeInt(this.m_142049_()));
        }
        return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return SoundEvents.f_12503_;
    }

    public SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_12506_;
    }

    public SoundEvent m_5592_() {
        return SoundEvents.f_12505_;
    }
}

