/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.dynamodel.model.armor;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import iskallia.vault.dynamodel.model.armor.ArmorPieceModel;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class ArmorLayers {
    @OnlyIn(value=Dist.CLIENT)
    public abstract Supplier<LayerDefinition> getGeometrySupplier(EquipmentSlot var1);

    @OnlyIn(value=Dist.CLIENT)
    public abstract VaultArmorLayerSupplier<? extends BaseLayer> getLayerSupplier(EquipmentSlot var1);

    @OnlyIn(value=Dist.CLIENT)
    public static ModelLayerLocation createLayerLocation(EquipmentSlot equipmentSlot, ResourceLocation id) {
        return switch (equipmentSlot) {
            case EquipmentSlot.HEAD -> new ModelLayerLocation(new ResourceLocation(id.m_135827_(), id.m_135815_() + "_helmet"), "main");
            case EquipmentSlot.CHEST -> new ModelLayerLocation(new ResourceLocation(id.m_135827_(), id.m_135815_() + "_chestplate"), "main");
            case EquipmentSlot.LEGS -> new ModelLayerLocation(new ResourceLocation(id.m_135827_(), id.m_135815_() + "_leggings"), "main");
            case EquipmentSlot.FEET -> new ModelLayerLocation(new ResourceLocation(id.m_135827_(), id.m_135815_() + "_boots"), "main");
            default -> throw new InternalError("Invalid armor slot -> " + equipmentSlot);
        };
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class LeggingsLayer
    extends BaseLayer {
        protected final ModelPart f_102810_;
        protected final ModelPart right_leg;
        protected final ModelPart left_leg;

        public LeggingsLayer(ArmorPieceModel definition, ModelPart root) {
            super(definition, root);
            this.f_102810_ = root.m_171324_("body");
            this.right_leg = root.m_171324_("right_leg");
            this.left_leg = root.m_171324_("left_leg");
        }

        public void m_7695_(@Nonnull PoseStack poseStack, @Nonnull VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
            poseStack.m_85836_();
            this.adjustForRender(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
            this.f_102810_.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
            this.right_leg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
            this.left_leg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
            poseStack.m_85849_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class MainLayer
    extends BaseLayer {
        protected final ModelPart f_102808_;
        protected final ModelPart f_102810_;
        protected final ModelPart f_102811_;
        protected final ModelPart f_102812_;
        protected final ModelPart f_102813_;
        protected final ModelPart f_102814_;

        public MainLayer(ArmorPieceModel definition, ModelPart root) {
            super(definition, root);
            this.f_102808_ = root.m_171324_("head");
            this.f_102810_ = root.m_171324_("body");
            this.f_102811_ = root.m_171324_("right_arm");
            this.f_102812_ = root.m_171324_("left_arm");
            this.f_102813_ = root.m_171324_("right_leg");
            this.f_102814_ = root.m_171324_("left_leg");
        }

        public ModelPart getRightArm() {
            return this.f_102811_;
        }

        public ModelPart getLeftArm() {
            return this.f_102812_;
        }

        public void m_7695_(@Nonnull PoseStack poseStack, @Nonnull VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
            poseStack.m_85836_();
            this.adjustForRender(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
            if (this.definition.getEquipmentSlot() == EquipmentSlot.HEAD) {
                this.f_102808_.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
            } else if (this.definition.getEquipmentSlot() == EquipmentSlot.CHEST) {
                this.f_102810_.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
                this.f_102811_.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
                this.f_102812_.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
            } else if (this.definition.getEquipmentSlot() == EquipmentSlot.FEET) {
                this.f_102813_.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
                this.f_102814_.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
            }
            poseStack.m_85849_();
        }

        public void adjustForFirstPersonRender(@Nonnull PoseStack poseStack) {
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static abstract class BaseLayer
    extends HumanoidModel<LivingEntity> {
        protected ArmorPieceModel definition;

        public BaseLayer(ArmorPieceModel associatedDefinition, ModelPart root) {
            super(root);
            this.definition = associatedDefinition;
        }

        public ArmorPieceModel getDefinition() {
            return this.definition;
        }

        protected void adjustForRender(PoseStack matrixStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        }

        public static MeshDefinition createBaseLayer() {
            MeshDefinition meshDefinition = new MeshDefinition();
            PartDefinition partDefinition = meshDefinition.m_171576_();
            partDefinition.m_171599_("head", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
            partDefinition.m_171599_("hat", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
            partDefinition.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
            partDefinition.m_171599_("right_arm", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
            partDefinition.m_171599_("left_arm", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
            partDefinition.m_171599_("right_leg", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
            partDefinition.m_171599_("left_leg", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
            return meshDefinition;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @FunctionalInterface
    public static interface VaultArmorLayerSupplier<T extends BaseLayer> {
        public T supply(ArmorPieceModel var1, ModelPart var2);
    }
}

