/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.dynamodel;

import iskallia.vault.dynamodel.DynamicBakedOverride;
import iskallia.vault.dynamodel.DynamicModel;
import iskallia.vault.dynamodel.DynamicModelItem;
import iskallia.vault.dynamodel.registry.DynamicModelRegistry;
import iskallia.vault.init.ModDynamicModels;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DynamicBakedModel
implements BakedModel {
    private final BakedModel original;
    private final ItemOverrides overrides;

    public DynamicBakedModel(BakedModel original, ModelBakery loader) {
        this.original = original;
        BlockModel missing = (BlockModel)loader.m_119341_((ResourceLocation)ModelBakery.f_119230_);
        this.overrides = new ItemOverrides(loader, missing, id2 -> missing, Collections.emptyList()){

            public BakedModel m_173464_(@NotNull BakedModel original, @NotNull ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity entity, int seed) {
                Item item = stack.m_41720_();
                if (!(item instanceof DynamicModelItem)) {
                    return original;
                }
                DynamicModelItem dynamicModelItem = (DynamicModelItem)item;
                ResourceLocation modelId = dynamicModelItem.getDynamicModelId(stack).orElse(null);
                if (modelId == null) {
                    return original;
                }
                DynamicModelRegistry registry = ModDynamicModels.REGISTRIES.getAssociatedRegistry(stack.m_41720_()).orElse(null);
                if (registry == null) {
                    return original;
                }
                DynamicModel dynamicModel = registry.get(modelId).orElse(null);
                if (dynamicModel == null) {
                    return original;
                }
                ResourceLocation bakedId = dynamicModel.resolveBakedIcon(stack, world, entity, seed);
                BakedModel bakedIcon = registry.getBakedIcon(bakedId);
                return new DynamicBakedOverride(original, bakedIcon);
            }
        };
    }

    @Nonnull
    public List<BakedQuad> m_6840_(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random random) {
        return this.original.m_6840_(state, side, random);
    }

    public boolean m_7541_() {
        return this.original.m_7541_();
    }

    public boolean m_7539_() {
        return this.original.m_7539_();
    }

    public boolean m_7547_() {
        return this.original.m_7547_();
    }

    public boolean m_7521_() {
        return this.original.m_7521_();
    }

    @NotNull
    public TextureAtlasSprite m_6160_() {
        return this.original.m_6160_();
    }

    @Nonnull
    public ItemTransforms m_7442_() {
        return this.original.m_7442_();
    }

    @Nonnull
    public ItemOverrides m_7343_() {
        return this.overrides;
    }
}

