/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.dump;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;

public class VaultDataDump {
    private static final Gson GSON = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().setPrettyPrinting().create();

    public static void onStart(ServerStartedEvent event) {
        VaultDataDump.dumpModData();
    }

    public static void dumpModData() {
        File dataFile;
        File dir = new File("data/the_vault/");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if ((dataFile = new File(dir, "data.json")).exists()) {
            dataFile.delete();
        }
        try {
            dataFile.createNewFile();
            FileWriter writer = new FileWriter(dataFile);
            GSON.toJson(VaultDataDump.getData(), (Appendable)writer);
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Map<String, String> getData() {
        HashMap<String, String> data = new HashMap<String, String>();
        String version = ModList.get().getModContainerById("the_vault").map(ModContainer::getModInfo).map(IModInfo::getVersion).map(Objects::toString).orElse("");
        data.put("version", version);
        return data;
    }
}

