/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.dump;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import iskallia.vault.config.EternalAuraConfig;
import iskallia.vault.entity.eternal.EternalData;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.research.ResearchTree;
import iskallia.vault.skill.PlayerVaultStats;
import iskallia.vault.skill.ability.AbilityTree;
import iskallia.vault.skill.talent.TalentTree;
import iskallia.vault.util.calc.BlockChanceHelper;
import iskallia.vault.util.calc.CooldownHelper;
import iskallia.vault.util.calc.FatalStrikeHelper;
import iskallia.vault.util.calc.PlayerStatisticsCollector;
import iskallia.vault.util.calc.ResistanceHelper;
import iskallia.vault.util.calc.ThornsHelper;
import iskallia.vault.world.data.EternalsData;
import iskallia.vault.world.data.PlayerAbilitiesData;
import iskallia.vault.world.data.PlayerFavourData;
import iskallia.vault.world.data.PlayerResearchesData;
import iskallia.vault.world.data.PlayerTalentsData;
import iskallia.vault.world.data.PlayerVaultStatsData;
import iskallia.vault.world.data.ServerVaults;
import java.time.Instant;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;

public class PlayerSnapshotDump {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static String createAndSerializeSnapshot(ServerPlayer sPlayer) {
        return GSON.toJson((Object)PlayerSnapshotDump.createSnapshot(sPlayer));
    }

    public static PlayerSnapshot createSnapshot(ServerPlayer sPlayer) {
        PlayerSnapshot snapshot = new PlayerSnapshot(sPlayer);
        ServerLevel sWorld = sPlayer.m_183503_();
        snapshot.inVault = ServerVaults.isInVault((Entity)sPlayer);
        PlayerVaultStats stats = PlayerVaultStatsData.get(sWorld).getVaultStats((Player)sPlayer);
        snapshot.vaultLevel = stats.getVaultLevel();
        snapshot.levelPercent = snapshot.vaultLevel >= ModConfigs.LEVELS_META.getMaxLevel() ? 1.0f : (float)stats.getExp() / (float)stats.getExpNeededToNextLevel();
        AttributeMap mgr = sPlayer.m_21204_();
        for (Attribute attribute : ForgeRegistries.ATTRIBUTES) {
            if (!mgr.m_22171_(attribute)) continue;
            ResourceLocation attrId = attribute.getRegistryName();
            snapshot.attributes.put(attrId == null ? attribute.m_22087_() : attrId.toString(), mgr.m_22181_(attribute));
        }
        snapshot.blockChance = BlockChanceHelper.getBlockChance((LivingEntity)sPlayer);
        snapshot.resistance = ResistanceHelper.getResistance((LivingEntity)sPlayer);
        snapshot.cooldownReduction = CooldownHelper.getCooldownMultiplier(sPlayer);
        snapshot.fatalStrikeChance = FatalStrikeHelper.getFatalStrikeChance((LivingEntity)sPlayer);
        snapshot.fatalStrikeDamage = FatalStrikeHelper.getFatalStrikeDamage((LivingEntity)sPlayer);
        snapshot.thornsChance = ThornsHelper.getThornsChance((LivingEntity)sPlayer);
        snapshot.thornsDamage = ThornsHelper.getThornsDamage((LivingEntity)sPlayer);
        Arrays.stream(EquipmentSlot.values()).forEach(slotType -> {
            ItemStack stack = sPlayer.m_6844_(slotType);
            if (!stack.m_41619_()) {
                snapshot.equipment.put(slotType.name(), new SerializableItemStack(stack));
            }
        });
        AbilityTree abilities = PlayerAbilitiesData.get(sWorld).getAbilities((Player)sPlayer);
        abilities.getLearnedNodes().forEach(node -> {
            if (node.getSpecialization() != null) {
                snapshot.abilities.put(node.getGroup().getParentName() + ": " + node.getSpecializationName(), node.getLevel());
            } else {
                snapshot.abilities.put(node.getGroup().getParentName(), node.getLevel());
            }
        });
        TalentTree talents = PlayerTalentsData.get(sWorld).getTalents((Player)sPlayer);
        talents.getLearnedNodes().forEach(node -> snapshot.talents.put(node.getGroup().getParentName(), node.getLevel()));
        ResearchTree researches = PlayerResearchesData.get(sWorld).getResearches((Player)sPlayer);
        snapshot.researches.addAll(researches.getResearchesDone());
        PlayerStatisticsCollector.VaultRunsSnapshot vaultRunsSnapshot = PlayerStatisticsCollector.VaultRunsSnapshot.ofPlayer(sPlayer);
        snapshot.vaultRuns = vaultRunsSnapshot.vaultRuns;
        snapshot.vaultWins = vaultRunsSnapshot.bossKills;
        snapshot.vaultDeaths = vaultRunsSnapshot.deaths;
        snapshot.artifactCount = vaultRunsSnapshot.artifacts;
        snapshot.powerLevel = stats.getTotalSpentSkillPoints() + stats.getUnspentSkillPoints();
        PlayerFavourData favourData = PlayerFavourData.get(sWorld);
        for (PlayerFavourData.VaultGodType type : PlayerFavourData.VaultGodType.values()) {
            snapshot.favors.put(type.getName(), favourData.getFavour(sPlayer.m_142081_(), type));
        }
        EternalsData.EternalGroup group = EternalsData.get(sWorld).getEternals((Player)sPlayer);
        for (EternalData eternal : group.getEternals()) {
            EternalAuraConfig.AuraConfig cfg;
            String auraName = null;
            if (eternal.getAbilityName() != null && (cfg = ModConfigs.ETERNAL_AURAS.getByName(eternal.getAbilityName())) != null) {
                auraName = cfg.getDisplayName();
            }
            EternalInformation eternalSnapshot = new EternalInformation(eternal.getName(), eternal.getLevel(), eternal.isAncient(), auraName);
            eternal.getEquipment().forEach((slot, stack) -> {
                if (!stack.m_41619_()) {
                    eternalSnapshot.equipment.put(slot.name(), new SerializableItemStack((ItemStack)stack));
                }
            });
            snapshot.eternals.add(eternalSnapshot);
        }
        return snapshot;
    }

    public static class PlayerSnapshot {
        protected final UUID playerUUID;
        protected final String playerNickname;
        protected final long timestamp;
        protected int vaultRuns;
        protected int vaultWins;
        protected int vaultDeaths;
        protected int artifactCount;
        protected boolean inVault = false;
        protected int powerLevel = 0;
        protected int vaultLevel = 0;
        protected float levelPercent = 0.0f;
        protected Map<String, Double> attributes = new LinkedHashMap<String, Double>();
        protected Map<String, Integer> favors = new LinkedHashMap<String, Integer>();
        protected float blockChance;
        protected float resistance;
        protected float cooldownReduction;
        protected float fatalStrikeChance;
        protected float fatalStrikeDamage;
        protected float thornsChance;
        protected float thornsDamage;
        protected Map<String, SerializableItemStack> equipment = new LinkedHashMap<String, SerializableItemStack>();
        protected Map<String, Integer> abilities = new LinkedHashMap<String, Integer>();
        protected Map<String, Integer> talents = new LinkedHashMap<String, Integer>();
        protected Set<String> researches = new LinkedHashSet<String>();
        protected Set<EternalInformation> eternals = new LinkedHashSet<EternalInformation>();

        public PlayerSnapshot(ServerPlayer playerEntity) {
            this.playerUUID = playerEntity.m_142081_();
            this.playerNickname = playerEntity.m_7755_().getString();
            this.timestamp = Instant.now().getEpochSecond();
        }
    }

    public static class EternalInformation {
        private final String name;
        private final int level;
        private final boolean isAncient;
        private final String auraName;
        private Map<String, SerializableItemStack> equipment = new LinkedHashMap<String, SerializableItemStack>();

        public EternalInformation(String name, int level, boolean isAncient, String auraName) {
            this.name = name;
            this.level = level;
            this.isAncient = isAncient;
            this.auraName = auraName;
        }
    }

    public static class SerializableItemStack {
        private final String itemKey;
        private final int count;
        private final String nbt;
        private final String gearData;

        private SerializableItemStack(ItemStack stack) {
            this.itemKey = stack.m_41720_().getRegistryName().toString();
            this.count = stack.m_41613_();
            this.nbt = stack.m_41782_() ? stack.m_41783_().toString() : null;
            this.gearData = VaultGearItem.serializeGearData(stack).toString();
        }
    }
}

