/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.world.template.data;

import iskallia.vault.core.Version;
import iskallia.vault.core.data.key.PaletteKey;
import iskallia.vault.core.data.key.TemplateKey;
import iskallia.vault.core.data.key.TemplatePoolKey;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.vault.VaultRegistry;
import iskallia.vault.core.world.template.data.TemplateEntry;
import iskallia.vault.core.world.template.data.TemplatePool;
import net.minecraft.resources.ResourceLocation;

public class IndirectTemplateEntry
implements TemplateEntry {
    protected ResourceLocation reference;

    public IndirectTemplateEntry(ResourceLocation reference) {
        this.reference = reference;
    }

    public ResourceLocation getReferenceId() {
        return this.reference;
    }

    public TemplatePoolKey getReference() {
        return VaultRegistry.TEMPLATE_POOL.getKey(this.reference);
    }

    @Override
    public TemplateKey getTemplate() {
        throw new UnsupportedOperationException("Indirect entry, flatten first");
    }

    @Override
    public Iterable<PaletteKey> getPalettes() {
        throw new UnsupportedOperationException("Indirect entry, flatten first");
    }

    @Override
    public TemplateEntry flatten(Version version, RandomSource random) {
        TemplateEntry flattened = ((TemplatePool)this.getReference().get(version)).getRandom(random).orElse(null);
        if (flattened == null) {
            return null;
        }
        return flattened.flatten(version, random);
    }

    @Override
    public boolean validate() {
        return VaultRegistry.TEMPLATE_POOL.getKey(this.reference) != null;
    }

    public String toString() {
        return "{reference=" + this.reference.toString() + "}";
    }
}

