/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.world.template.configured;

import iskallia.vault.core.util.iterator.MappingIterator;
import iskallia.vault.core.world.data.PartialEntity;
import iskallia.vault.core.world.data.PartialTile;
import iskallia.vault.core.world.processor.entity.EntityProcessor;
import iskallia.vault.core.world.processor.tile.TileProcessor;
import iskallia.vault.core.world.template.PlacementSettings;
import iskallia.vault.core.world.template.StaticTemplate;
import iskallia.vault.core.world.template.Template;
import iskallia.vault.core.world.template.configured.ConfiguredTemplate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ServerLevelAccessor;

public class ChunkedTemplate
extends ConfiguredTemplate {
    private final Map<ChunkPos, StaticTemplate> cache = new HashMap<ChunkPos, StaticTemplate>();
    private boolean locked;

    public ChunkedTemplate(Template parent, PlacementSettings settings) {
        super(parent, settings);
    }

    private void onTile(PartialTile tile) {
        StaticTemplate child = this.cache.computeIfAbsent(new ChunkPos(tile.getPos()), pos -> new StaticTemplate(new ArrayList<PartialTile>(8192), new ArrayList<PartialEntity>(8192)));
        ((List)child.getTiles()).add(tile);
    }

    private void onEntity(PartialEntity entity) {
        StaticTemplate child = this.cache.computeIfAbsent(new ChunkPos(entity.getBlockPos()), pos -> new StaticTemplate(new ArrayList<PartialTile>(8192), new ArrayList<PartialEntity>(8192)));
        ((List)child.getEntities()).add(entity);
    }

    @Override
    public void place(ServerLevelAccessor world, ChunkPos pos) {
        if (!this.locked) {
            new Wrapping(this.parent, pos).place(world, this.settings);
            this.locked = true;
            this.cache.values().forEach(t -> {
                ((ArrayList)t.getTiles()).trimToSize();
                ((ArrayList)t.getEntities()).trimToSize();
            });
        } else {
            StaticTemplate child = this.cache.get(pos);
            if (child != null) {
                child.place(world, this.settings);
            }
        }
    }

    protected class Wrapping
    extends Template {
        private final Template parent;
        private final TileProcessor tileBound;
        private final EntityProcessor entityBound;

        public Wrapping(Template parent, ChunkPos pos) {
            this.parent = parent;
            this.tileBound = TileProcessor.bound(pos.f_45578_ * 16, Integer.MIN_VALUE, pos.f_45579_ * 16, pos.f_45578_ * 16 + 15, Integer.MAX_VALUE, pos.f_45579_ * 16 + 15);
            this.entityBound = EntityProcessor.bound(pos.f_45578_ * 16, Integer.MIN_VALUE, pos.f_45579_ * 16, pos.f_45578_ * 16 + 15, Integer.MAX_VALUE, pos.f_45579_ * 16 + 15);
        }

        @Override
        public Iterator<ResourceLocation> getTags() {
            return this.parent.getTags();
        }

        @Override
        public void addTag(ResourceLocation tag) {
            this.parent.addTag(tag);
        }

        @Override
        public boolean hasTag(ResourceLocation tag) {
            return this.parent.hasTag(tag);
        }

        @Override
        public Iterator<PartialTile> getTiles(Predicate<PartialTile> filter, PlacementSettings settings) {
            return new MappingIterator<PartialTile, PartialTile>(this.parent.getTiles(filter, settings), tile -> {
                ChunkedTemplate.this.onTile((PartialTile)tile);
                return this.tileBound.process(tile, settings.getProcessorContext());
            });
        }

        @Override
        public Iterator<PartialEntity> getEntities(Predicate<PartialEntity> filter, PlacementSettings settings) {
            return new MappingIterator<PartialEntity, PartialEntity>(this.parent.getEntities(filter, settings), tile -> {
                ChunkedTemplate.this.onEntity((PartialEntity)tile);
                return this.entityBound.process(tile, settings.getProcessorContext());
            });
        }
    }
}

