/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.world.template;

import com.google.common.collect.Lists;
import iskallia.vault.VaultMod;
import iskallia.vault.core.util.iterator.MappingIterator;
import iskallia.vault.core.world.data.PartialEntity;
import iskallia.vault.core.world.data.PartialState;
import iskallia.vault.core.world.data.PartialTile;
import iskallia.vault.core.world.processor.Processor;
import iskallia.vault.core.world.template.PlacementSettings;
import iskallia.vault.core.world.template.Template;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPos;
import net.minecraft.core.IdMapper;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.INBTSerializable;

public class StructureTemplate
extends Template
implements INBTSerializable<CompoundTag> {
    public static final Comparator<PartialTile> SORTER = Comparator.comparingInt(tile -> tile.getPos().m_123342_()).thenComparingInt(tile -> tile.getPos().m_123341_()).thenComparingInt(tile -> tile.getPos().m_123343_());
    private Map<Predicate<PartialTile>, List<PartialTile>> tiles = new HashMap<Predicate<PartialTile>, List<PartialTile>>();
    private Map<Predicate<PartialEntity>, List<PartialEntity>> entities = new HashMap<Predicate<PartialEntity>, List<PartialEntity>>();
    private IdPalette palette;
    private Vec3i size = Vec3i.f_123288_;
    private Set<ResourceLocation> tags = new HashSet<ResourceLocation>();
    private String path;

    protected StructureTemplate(String path) {
        this.path = path;
    }

    public static StructureTemplate fromPath(String path) {
        CompoundTag nbt;
        try {
            nbt = NbtIo.m_128939_((InputStream)new FileInputStream(path));
        }
        catch (IOException e) {
            return null;
        }
        StructureTemplate template = new StructureTemplate(path);
        template.deserializeNBT(nbt);
        return template;
    }

    public String getPath() {
        return this.path;
    }

    @Override
    public Iterator<ResourceLocation> getTags() {
        return this.tags.iterator();
    }

    @Override
    public void addTag(ResourceLocation tag) {
        this.tags.add(tag);
    }

    @Override
    public boolean hasTag(ResourceLocation tag) {
        return this.tags.contains(tag);
    }

    @Override
    public Iterator<PartialTile> getTiles(Predicate<PartialTile> filter, PlacementSettings settings) {
        return new MappingIterator<PartialTile, PartialTile>(this.tiles.get(filter).iterator(), tile -> {
            tile = tile.copy();
            for (Processor processor : settings.getTileProcessors()) {
                if (tile == null || !filter.test((PartialTile)tile)) {
                    tile = null;
                    break;
                }
                tile = processor.process(tile, settings.getProcessorContext());
            }
            return tile;
        });
    }

    @Override
    public Iterator<PartialEntity> getEntities(Predicate<PartialEntity> filter, PlacementSettings settings) {
        return new MappingIterator<PartialEntity, PartialEntity>(this.entities.get(filter).iterator(), entity -> {
            entity = entity.copy();
            for (Processor processor : settings.getEntityProcessors()) {
                if (entity == null || !filter.test((PartialEntity)entity)) {
                    entity = null;
                    break;
                }
                entity = processor.process(entity, settings.getProcessorContext());
            }
            return entity;
        });
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        if (this.tiles.isEmpty()) {
            nbt.m_128365_("blocks", (Tag)new ListTag());
            nbt.m_128365_("palette", (Tag)new ListTag());
        } else {
            ListTag blocksNBT = new ListTag();
            for (PartialTile partialTile : this.tiles.get(ALL_TILES)) {
                int paletteId = this.palette.getIdFor(partialTile.getState());
                blocksNBT.add((Object)partialTile.toPaletteNBT(new CompoundTag(), paletteId));
            }
            nbt.m_128365_("blocks", (Tag)blocksNBT);
            ListTag paletteNBT = new ListTag();
            for (PartialState state : this.palette) {
                paletteNBT.add((Object)state.toNBT(new CompoundTag()));
            }
            nbt.m_128365_("palette", (Tag)paletteNBT);
        }
        ListTag entitiesNBT = new ListTag();
        for (PartialEntity partialEntity : this.entities.get(ALL_ENTITIES)) {
            CompoundTag entityNBT = new CompoundTag();
            ListTag posNBT = new ListTag();
            posNBT.add((Object)DoubleTag.m_128500_((double)partialEntity.getPos().f_82479_));
            posNBT.add((Object)DoubleTag.m_128500_((double)partialEntity.getPos().f_82480_));
            posNBT.add((Object)DoubleTag.m_128500_((double)partialEntity.getPos().f_82481_));
            entityNBT.m_128365_("pos", (Tag)posNBT);
            ListTag blockPosNBT = new ListTag();
            blockPosNBT.add((Object)IntTag.m_128679_((int)partialEntity.getBlockPos().m_123341_()));
            blockPosNBT.add((Object)IntTag.m_128679_((int)partialEntity.getBlockPos().m_123342_()));
            blockPosNBT.add((Object)IntTag.m_128679_((int)partialEntity.getBlockPos().m_123343_()));
            entityNBT.m_128365_("blockPos", (Tag)blockPosNBT);
            if (partialEntity.getNBT() != null) {
                entityNBT.m_128365_("nbt", (Tag)partialEntity.getNBT());
            }
            entitiesNBT.add((Object)entityNBT);
        }
        nbt.m_128365_("entities", (Tag)entitiesNBT);
        ListTag sizeNBT = new ListTag();
        sizeNBT.add((Object)IntTag.m_128679_((int)this.size.m_123341_()));
        sizeNBT.add((Object)IntTag.m_128679_((int)this.size.m_123342_()));
        sizeNBT.add((Object)IntTag.m_128679_((int)this.size.m_123343_()));
        nbt.m_128365_("size", (Tag)sizeNBT);
        nbt.m_128405_("DataVersion", SharedConstants.m_183709_().getWorldVersion());
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.tiles.clear();
        this.entities.clear();
        this.tiles.put(Template.ALL_TILES, new ArrayList());
        this.tiles.put(Template.JIGSAWS, new ArrayList());
        this.tiles.put(Template.PLACEHOLDERS, new ArrayList());
        this.tiles.put(Template.VAULT_PORTALS, new ArrayList());
        this.entities.put(Template.ALL_ENTITIES, new ArrayList());
        ListTag sizeNBT = nbt.m_128437_("size", 3);
        this.size = new Vec3i(sizeNBT.m_128763_(0), sizeNBT.m_128763_(1), sizeNBT.m_128763_(2));
        ListTag blocksNBT = nbt.m_128437_("blocks", 10);
        if (nbt.m_128425_("palettes", 9)) {
            this.loadPalette(nbt.m_128437_("palettes", 9).m_128744_(0), blocksNBT);
            VaultMod.LOGGER.error("Template does not support multiple palettes, using the first one instead");
        } else {
            this.loadPalette(nbt.m_128437_("palette", 10), blocksNBT);
        }
        ListTag entitiesNBT = nbt.m_128437_("entities", 10);
        for (int j = 0; j < entitiesNBT.size(); ++j) {
            CompoundTag entityNBT = entitiesNBT.m_128728_(j);
            ListTag posNBT = entityNBT.m_128437_("pos", 6);
            Vec3 pos = new Vec3(posNBT.m_128772_(0), posNBT.m_128772_(1), posNBT.m_128772_(2));
            ListTag blockPosNBT = entityNBT.m_128437_("blockPos", 3);
            BlockPos blockPos = new BlockPos(blockPosNBT.m_128763_(0), blockPosNBT.m_128763_(1), blockPosNBT.m_128763_(2));
            if (!entityNBT.m_128441_("nbt")) continue;
            PartialEntity entity = PartialEntity.of(pos, blockPos, entityNBT.m_128469_("nbt"));
            this.entities.forEach((filter, list) -> {
                if (filter.test(entity)) {
                    list.add(entity);
                }
            });
        }
    }

    private void loadPalette(ListTag paletteNBT, ListTag blocksNBT) {
        this.palette = new IdPalette();
        for (int i = 0; i < paletteNBT.size(); ++i) {
            this.palette.addMapping(PartialState.fromNBT(paletteNBT.m_128728_(i)), i);
        }
        ArrayList normal = Lists.newArrayList();
        ArrayList withNBT = Lists.newArrayList();
        ArrayList withSpecialShape = Lists.newArrayList();
        for (int j = 0; j < blocksNBT.size(); ++j) {
            CompoundTag blockNBT = blocksNBT.m_128728_(j);
            PartialTile tile = PartialTile.fromPaletteNBT(blockNBT, this.palette::getStateFor);
            if (tile.getNbt() != null) {
                withNBT.add(tile);
                continue;
            }
            if (!tile.getState().getBlock().m_49967_() && tile.getState().asBlockState().m_60838_((BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.f_121853_)) {
                normal.add(tile);
                continue;
            }
            withSpecialShape.add(tile);
        }
        for (PartialTile tile : StructureTemplate.getOrderedTiles(normal, withNBT, withSpecialShape)) {
            this.tiles.forEach((filter, list) -> {
                if (filter.test(tile)) {
                    list.add(tile);
                }
            });
        }
    }

    private static List<PartialTile> getOrderedTiles(List<PartialTile> normal, List<PartialTile> withNBT, List<PartialTile> withSpecialShape) {
        normal.sort(SORTER);
        withSpecialShape.sort(SORTER);
        withNBT.sort(SORTER);
        ArrayList<PartialTile> tiles = new ArrayList<PartialTile>();
        tiles.addAll(normal);
        tiles.addAll(withSpecialShape);
        tiles.addAll(withNBT);
        return tiles;
    }

    public static class IdPalette
    implements Iterable<PartialState> {
        public static final PartialState DEFAULT_STATE = PartialState.of(Blocks.f_50016_.m_49966_());
        private final IdMapper<PartialState> ids = new IdMapper(16);
        private int nextId;

        public int getIdFor(PartialState pState) {
            int i = this.ids.m_7447_((Object)pState);
            if (i == -1) {
                i = this.nextId++;
                this.ids.m_122664_((Object)pState, i);
            }
            return i;
        }

        public PartialState getStateFor(int id) {
            PartialState state = (PartialState)this.ids.m_7942_(id);
            return state == null ? DEFAULT_STATE : state;
        }

        public void addMapping(PartialState state, int id) {
            this.ids.m_122664_((Object)state, id);
        }

        @Override
        public Iterator<PartialState> iterator() {
            return this.ids.iterator();
        }
    }
}

