/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.world.processor.entity;

import iskallia.vault.core.util.WeightedList;
import iskallia.vault.core.world.data.EntityPredicate;
import iskallia.vault.core.world.data.PartialEntity;
import iskallia.vault.core.world.processor.ProcessorContext;
import iskallia.vault.core.world.processor.entity.TargetEntityProcessor;
import java.util.Optional;
import net.minecraft.world.entity.EntityType;

public class WeightedEntityProcessor
extends TargetEntityProcessor<WeightedEntityProcessor> {
    protected final WeightedList<PartialEntity> output = new WeightedList();

    @Override
    public WeightedEntityProcessor target(EntityType<?> type) {
        return this.target(EntityPredicate.of(type));
    }

    @Override
    public WeightedEntityProcessor target(EntityPredicate predicate) {
        this.predicate = predicate;
        return this;
    }

    @Override
    public PartialEntity process(PartialEntity entity, ProcessorContext context) {
        Optional<PartialEntity> output;
        if (this.predicate.test(entity) && (output = this.output.getRandom(context.random)).isPresent()) {
            return output.get().copy().fillMissing(entity);
        }
        return entity;
    }
}

