/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.world.loot;

import com.google.gson.JsonObject;
import iskallia.vault.core.random.RandomSource;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.util.INBTSerializable;

public interface LootRoll
extends INBTSerializable<CompoundTag> {
    public int get(RandomSource var1);

    public float getMean();

    public JsonObject serializeJson();

    public void deserializeJson(JsonObject var1);

    public static Constant ofConstant(int count) {
        return new Constant(count);
    }

    public static Uniform ofUniform(int min, int max) {
        return new Uniform(min, max);
    }

    public static LootRoll fromNBT(CompoundTag nbt) {
        LootRoll roll;
        switch (nbt.m_128461_("type")) {
            case "constant": {
                LootRoll lootRoll = new Constant();
                break;
            }
            case "uniform": {
                LootRoll lootRoll = new Uniform();
                break;
            }
            default: {
                LootRoll lootRoll = roll = null;
            }
        }
        if (roll != null) {
            roll.deserializeNBT((Tag)nbt);
        }
        return roll;
    }

    public static LootRoll fromJson(JsonObject object) {
        LootRoll roll;
        switch (object.get("type").getAsString()) {
            case "constant": {
                LootRoll lootRoll = new Constant();
                break;
            }
            case "uniform": {
                LootRoll lootRoll = new Uniform();
                break;
            }
            default: {
                LootRoll lootRoll = roll = null;
            }
        }
        if (roll != null) {
            roll.deserializeJson(object);
        }
        return roll;
    }

    public static class Constant
    implements LootRoll {
        private int count;

        protected Constant() {
        }

        protected Constant(int count) {
            this.count = count;
        }

        public int getCount() {
            return this.count;
        }

        @Override
        public int get(RandomSource random) {
            return this.count;
        }

        @Override
        public float getMean() {
            return this.count;
        }

        public CompoundTag serializeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128359_("type", "constant");
            nbt.m_128405_("count", this.count);
            return nbt;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.count = nbt.m_128451_("count");
        }

        @Override
        public JsonObject serializeJson() {
            JsonObject object = new JsonObject();
            object.addProperty("type", "constant");
            object.addProperty("count", (Number)this.count);
            return object;
        }

        @Override
        public void deserializeJson(JsonObject object) {
            this.count = object.get("count").getAsInt();
        }
    }

    public static class Uniform
    implements LootRoll {
        private int min;
        private int max;

        protected Uniform() {
        }

        protected Uniform(int min, int max) {
            this.min = min;
            this.max = max;
        }

        public int getMin() {
            return this.min;
        }

        public int getMax() {
            return this.max;
        }

        @Override
        public int get(RandomSource random) {
            return random.nextInt(this.max - this.min + 1) + this.min;
        }

        @Override
        public float getMean() {
            return (float)(this.min + this.max) / 2.0f;
        }

        public CompoundTag serializeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128359_("type", "uniform");
            nbt.m_128405_("min", this.min);
            nbt.m_128405_("max", this.max);
            return nbt;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.min = nbt.m_128451_("min");
            this.max = nbt.m_128451_("max");
        }

        @Override
        public JsonObject serializeJson() {
            JsonObject object = new JsonObject();
            object.addProperty("type", "uniform");
            object.addProperty("min", (Number)this.min);
            object.addProperty("max", (Number)this.max);
            return object;
        }

        @Override
        public void deserializeJson(JsonObject object) {
            this.min = object.get("min").getAsInt();
            this.max = object.get("max").getAsInt();
        }
    }
}

