/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.world.generator.layout;

import com.google.gson.JsonObject;
import iskallia.vault.core.Version;
import iskallia.vault.core.data.DataList;
import iskallia.vault.core.data.DataObject;
import iskallia.vault.core.data.adapter.Adapter;
import iskallia.vault.core.data.key.FieldKey;
import iskallia.vault.core.data.key.TemplatePoolKey;
import iskallia.vault.core.data.key.registry.FieldRegistry;
import iskallia.vault.core.vault.VaultRegistry;
import iskallia.vault.core.world.generator.layout.DIYVaultLayout;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.util.INBTSerializable;

public class DIYRoomEntry
extends DataObject<DIYRoomEntry>
implements INBTSerializable<CompoundTag> {
    public static final FieldRegistry FIELDS = new FieldRegistry();
    public static final FieldKey<Type> TYPE = (FieldKey)FieldKey.of("type", Type.class).with(Version.v1_0, Adapter.ofEnum(Type.class), DISK.all()).register(FIELDS);
    public static final FieldKey<ResourceLocation> POOL = (FieldKey)FieldKey.of("pool", ResourceLocation.class).with(Version.v1_0, Adapter.ofIdentifier(), DISK.all()).register(FIELDS);
    public static final FieldKey<Integer> COUNT = (FieldKey)FieldKey.of("count", Integer.class).with(Version.v1_0, Adapter.ofSegmentedInt(7), DISK.all()).register(FIELDS);
    public static final FieldKey<Integer> COLOR = (FieldKey)FieldKey.of("color", Integer.class).with(Version.v1_0, Adapter.ofInt(), DISK.all()).register(FIELDS);

    private DIYRoomEntry() {
    }

    public static DIYRoomEntry ofType(Type type, int count) {
        return (DIYRoomEntry)((DIYRoomEntry)new DIYRoomEntry().set(TYPE, type)).set(COUNT, count);
    }

    public static DIYRoomEntry ofPool(ResourceLocation pool, int count) {
        return (DIYRoomEntry)((DIYRoomEntry)new DIYRoomEntry().set(POOL, pool)).set(COUNT, count);
    }

    public static DIYRoomEntry fromNBT(CompoundTag nbt) {
        DIYRoomEntry entry = new DIYRoomEntry();
        entry.deserializeNBT(nbt);
        return entry;
    }

    public static DIYRoomEntry fromJson(JsonObject object) {
        DIYRoomEntry entry = new DIYRoomEntry();
        entry.deserializeJson(object);
        return entry;
    }

    @Override
    public FieldRegistry getFields() {
        return FIELDS;
    }

    public Component getName() {
        if (this.has(TYPE)) {
            return this.get(TYPE).getDisplay();
        }
        TemplatePoolKey pool = VaultRegistry.TEMPLATE_POOL.getKey(this.get(POOL));
        return pool == null ? new TextComponent("UNKNOWN") : new TextComponent(pool.getName()).m_130948_(Style.f_131099_.m_178520_(this.getOr(COLOR, 0xFFFFFF).intValue()));
    }

    public void mergeWith(DIYRoomEntry other) {
        if (this.has(TYPE) && other.has(TYPE) && this.get(TYPE) == other.get(TYPE)) {
            this.modify(COUNT, i -> i + other.get(COUNT));
            other.set(COUNT, 0);
        } else if (this.has(POOL) && other.has(POOL) && this.get(POOL).equals((Object)other.get(POOL))) {
            this.modify(COUNT, i -> i + other.get(COUNT));
            other.set(COUNT, 0);
        }
    }

    public TemplatePoolKey getPool(DIYVaultLayout layout) {
        if (this.has(TYPE)) {
            return switch (this.get(TYPE)) {
                default -> throw new IncompatibleClassChangeError();
                case Type.COMMON -> layout.get(DIYVaultLayout.COMMON_ROOM_POOL);
                case Type.CHALLENGE -> layout.get(DIYVaultLayout.CHALLENGE_ROOM_POOL);
                case Type.OMEGA -> layout.get(DIYVaultLayout.OMEGA_ROOM_POOL);
            };
        }
        return VaultRegistry.TEMPLATE_POOL.getKey(this.get(POOL));
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        if (this.has(TYPE)) {
            nbt.m_128359_("type", this.get(TYPE).name());
        }
        if (this.has(POOL)) {
            nbt.m_128359_("pool", this.get(POOL).toString());
        }
        nbt.m_128405_("count", this.get(COUNT).intValue());
        if (this.has(COLOR)) {
            nbt.m_128405_("color", this.get(COLOR).intValue());
        }
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (nbt.m_128441_("type")) {
            this.set(TYPE, Enum.valueOf(Type.class, nbt.m_128461_("type")));
        }
        if (nbt.m_128441_("pool")) {
            this.set(POOL, new ResourceLocation(nbt.m_128461_("pool")));
        }
        this.set(COUNT, nbt.m_128451_("count"));
        if (nbt.m_128425_("color", 3)) {
            this.set(COLOR, nbt.m_128451_("color"));
        }
    }

    public JsonObject serializeJson() {
        JsonObject object = new JsonObject();
        if (this.has(TYPE)) {
            object.addProperty("type", this.get(TYPE).name());
        }
        if (this.has(POOL)) {
            object.addProperty("pool", this.get(POOL).toString());
        }
        object.addProperty("count", (Number)this.get(COUNT));
        if (this.has(COLOR)) {
            object.addProperty("color", (Number)this.getOr(COLOR, 0xFFFFFF));
        }
        return object;
    }

    public void deserializeJson(JsonObject object) {
        if (object.has("type")) {
            this.set(TYPE, Enum.valueOf(Type.class, object.get("type").getAsString()));
        }
        if (object.has("pool")) {
            this.set(POOL, new ResourceLocation(object.get("pool").getAsString()));
        }
        this.set(COUNT, object.get("count").getAsInt());
        if (object.has("color")) {
            this.set(COLOR, object.get("color").getAsInt());
        }
    }

    public static enum Type {
        COMMON,
        CHALLENGE,
        OMEGA;


        public Component getDisplay() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case COMMON -> new TextComponent("Common").m_130940_(ChatFormatting.WHITE);
                case CHALLENGE -> new TextComponent("Challenge").m_130940_(ChatFormatting.LIGHT_PURPLE);
                case OMEGA -> new TextComponent("Omega").m_130940_(ChatFormatting.GREEN);
            };
        }
    }

    public static class List
    extends DataList<List, DIYRoomEntry> {
        public List() {
            super(new ArrayList(), Adapter.ofCompound(DIYRoomEntry::new));
        }

        public java.util.List<TemplatePoolKey> flatten(DIYVaultLayout layout) {
            ArrayList<TemplatePoolKey> result = new ArrayList<TemplatePoolKey>();
            for (DIYRoomEntry entry : this) {
                TemplatePoolKey pool = entry.getPool(layout);
                if (pool == null) continue;
                for (int i = 0; i < entry.get(COUNT); ++i) {
                    result.add(pool);
                }
            }
            return result;
        }

        public int getTotalCount() {
            int total = 0;
            for (DIYRoomEntry entry : this) {
                total += entry.get(COUNT).intValue();
            }
            return total;
        }
    }
}

